/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.user;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UserXMLCatalog
implements CatalogReader,
CatalogWriter,
CatalogDescriptor,
EntityResolver {
    private Map publicIds;
    private List catalogListeners = new ArrayList();
    private static final String catalogResource = "xml/catalogs/UserXMLCatalog.xml";
    private static final String URI_PREFIX = "URI:";
    private static final String PUBLIC_PREFIX = "PUBLIC:";
    private static final String SYSTEM_PREFIX = "SYSTEM:";
    private static final int TYPE_PUBLIC = 0;
    private static final int TYPE_SYSTEM = 1;
    private static final int TYPE_URI = 2;
    static /* synthetic */ Class class$org$apache$xml$resolver$Catalog;

    public String resolveURI(String name) {
        return (String)this.publicIds.get(URI_PREFIX + name);
    }

    public String resolvePublic(String publicId) {
        return (String)this.publicIds.get(PUBLIC_PREFIX + publicId);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.getPublicIdMap();
        String url = null;
        if (publicId != null) {
            url = (String)this.publicIds.get(PUBLIC_PREFIX + publicId);
            if (url == null) {
                url = (String)this.publicIds.get(URI_PREFIX + publicId);
            }
        } else if (systemId != null) {
            url = (String)this.publicIds.get(SYSTEM_PREFIX + systemId);
        }
        if (url != null) {
            return new InputSource(url);
        }
        return null;
    }

    public String getSystemID(String publicId) {
        return (String)this.publicIds.get(publicId);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removeCatalogListener(CatalogListener l) {
        this.catalogListeners.remove(l);
    }

    public void addCatalogListener(CatalogListener l) {
        this.catalogListeners.add(l);
    }

    protected void fireEntryAdded(String publicId) {
        Iterator it = this.catalogListeners.iterator();
        while (it.hasNext()) {
            CatalogListener listener = (CatalogListener)it.next();
            listener.notifyNew(publicId);
        }
    }

    protected void fireEntryRemoved(String publicId) {
        Iterator it = this.catalogListeners.iterator();
        while (it.hasNext()) {
            CatalogListener listener = (CatalogListener)it.next();
            listener.notifyRemoved(publicId);
        }
    }

    protected void fireEntryUpdated(String publicId) {
        Iterator it = this.catalogListeners.iterator();
        while (it.hasNext()) {
            CatalogListener listener = (CatalogListener)it.next();
            listener.notifyUpdate(publicId);
        }
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/netbeans/modules/xml/catalog/impl/xmlCatalog.gif", (boolean)true);
    }

    public void refresh() {
        Iterator it = this.catalogListeners.iterator();
        while (it.hasNext()) {
            CatalogListener listener = (CatalogListener)it.next();
            listener.notifyInvalidate();
        }
        FileObject userCatalog = Repository.getDefault().getDefaultFileSystem().findResource(catalogResource);
        userCatalog.refresh();
        this.publicIds = null;
    }

    public String getShortDescription() {
        return NbBundle.getMessage((Class)UserXMLCatalog.class, (String)"HINT_userCatalog");
    }

    public Iterator getPublicIDs() {
        return this.getPublicIdMap().keySet().iterator();
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)UserXMLCatalog.class, (String)"LBL_userCatalog");
    }

    private Map getPublicIdMap() {
        if (this.publicIds == null) {
            try {
                FileObject userCatalog = Repository.getDefault().getDefaultFileSystem().findResource(catalogResource);
                this.publicIds = this.parse(userCatalog);
            }
            catch (IOException ex) {
                this.publicIds = new HashMap();
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (SAXException ex) {
                this.publicIds = new HashMap();
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.publicIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(int entryType, String key, String value) throws IOException {
        FileObject userCatalog = Repository.getDefault().getDefaultFileSystem().findResource(catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        try {
            PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf("</catalog>") >= 0) {
                        switch (entryType) {
                            case 0: {
                                writer.println("  <public publicId=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(PUBLIC_PREFIX + key, value);
                                this.fireEntryAdded(PUBLIC_PREFIX + key);
                                break;
                            }
                            case 1: {
                                writer.println("  <system systemId=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(SYSTEM_PREFIX + key, value);
                                this.fireEntryAdded(SYSTEM_PREFIX + key);
                                break;
                            }
                            case 2: {
                                writer.println("  <uri name=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(URI_PREFIX + key, value);
                                this.fireEntryAdded(URI_PREFIX + key);
                            }
                        }
                    }
                    writer.println(line);
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(int entryType, String key) throws IOException {
        FileObject userCatalog = Repository.getDefault().getDefaultFileSystem().findResource(catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        try {
            PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));
            try {
                String line;
                block11: while ((line = reader.readLine()) != null) {
                    switch (entryType) {
                        case 0: {
                            if (line.indexOf("<public publicId=\"" + key + "\"") > 0) {
                                this.publicIds.remove(PUBLIC_PREFIX + key);
                                this.fireEntryRemoved(PUBLIC_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                        case 1: {
                            if (line.indexOf("<system systemId=\"" + key + "\"") > 0) {
                                this.publicIds.remove(SYSTEM_PREFIX + key);
                                this.fireEntryRemoved(SYSTEM_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                        case 2: {
                            if (line.indexOf("<uri name=\"" + key + "\"") > 0) {
                                this.publicIds.remove(URI_PREFIX + key);
                                this.fireEntryRemoved(URI_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                    }
                    writer.println(line);
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntry(int entryType, String key, String value) throws IOException {
        FileObject userCatalog = Repository.getDefault().getDefaultFileSystem().findResource(catalogResource);
        String tempBuffer = this.createCatalogBuffer(userCatalog);
        BufferedReader reader = new BufferedReader(new StringReader(tempBuffer));
        FileLock lock = userCatalog.lock();
        try {
            PrintWriter writer = new PrintWriter(userCatalog.getOutputStream(lock));
            try {
                String line;
                block11: while ((line = reader.readLine()) != null) {
                    switch (entryType) {
                        case 0: {
                            if (line.indexOf("<public publicId=\"" + key + "\"") > 0) {
                                writer.println("  <public publicId=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(PUBLIC_PREFIX + key, value);
                                this.fireEntryUpdated(PUBLIC_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                        case 1: {
                            if (line.indexOf("<system systemId=\"" + key + "\"") > 0) {
                                writer.println("  <system systemId=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(SYSTEM_PREFIX + key, value);
                                this.fireEntryUpdated(SYSTEM_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                        case 2: {
                            if (line.indexOf("<uri name=\"" + key + "\"") > 0) {
                                writer.println("  <uri name=\"" + key + "\" uri=\"" + value + "\"/>");
                                this.publicIds.put(URI_PREFIX + key, value);
                                this.fireEntryUpdated(URI_PREFIX + key);
                                continue block11;
                            }
                            writer.println(line);
                            continue block11;
                        }
                    }
                    writer.println(line);
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private String createCatalogBuffer(FileObject fo) throws IOException {
        int b;
        BufferedInputStream is = new BufferedInputStream(fo.getInputStream());
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((b = is.read(buf, 0, 512)) != -1) {
            temp.write(buf, 0, b);
        }
        is.close();
        temp.close();
        return temp.toString("UTF-8");
    }

    private Map parse(FileObject userCatalog) throws SAXException, IOException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(false);
        try {
            SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new OasisCatalogResolver());
            CatalogHandler handler = new CatalogHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(userCatalog.getInputStream()));
            return handler.getValues();
        }
        catch (ParserConfigurationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new HashMap();
        }
    }

    public void registerCatalogEntry(String key, String value) {
        this.getPublicIdMap();
        try {
            if (key.startsWith(PUBLIC_PREFIX)) {
                if (value != null) {
                    if (this.publicIds.get(key) != null) {
                        if (this.requestUpdate(key.substring(PUBLIC_PREFIX.length()))) {
                            this.updateEntry(0, key.substring(PUBLIC_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(0, key.substring(PUBLIC_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(0, key.substring(PUBLIC_PREFIX.length()));
                }
            } else if (key.startsWith(SYSTEM_PREFIX)) {
                if (value != null) {
                    if (this.publicIds.get(key) != null) {
                        if (this.requestUpdate(key.substring(SYSTEM_PREFIX.length()))) {
                            this.updateEntry(1, key.substring(SYSTEM_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(1, key.substring(SYSTEM_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(1, key.substring(SYSTEM_PREFIX.length()));
                }
            } else if (key.startsWith(URI_PREFIX)) {
                if (value != null) {
                    if (this.publicIds.get(key) != null) {
                        if (this.requestUpdate(key.substring(URI_PREFIX.length()))) {
                            this.updateEntry(2, key.substring(URI_PREFIX.length()), value);
                        }
                    } else {
                        this.addEntry(2, key.substring(URI_PREFIX.length()), value);
                    }
                } else {
                    this.removeEntry(2, key.substring(URI_PREFIX.length()));
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private boolean requestUpdate(String id) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)UserXMLCatalog.class, (String)"TXT_updateEntry", (Object)id), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        return NotifyDescriptor.YES_OPTION == desc.getValue();
    }

    private class OasisCatalogResolver
    implements EntityResolver {
        private OasisCatalogResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if ("-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN".equals(publicId)) {
                URL url = (class$org$apache$xml$resolver$Catalog == null ? (class$org$apache$xml$resolver$Catalog = UserXMLCatalog.class$("org.apache.xml.resolver.Catalog")) : class$org$apache$xml$resolver$Catalog).getResource("etc/catalog.dtd");
                return new InputSource(url.toExternalForm());
            }
            return null;
        }
    }

    private static class CatalogHandler
    extends DefaultHandler {
        private Map values = new HashMap();

        CatalogHandler() {
        }

        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            String val;
            if ("public".equals(rawName)) {
                String val2 = atts.getValue("publicId");
                if (val2 != null) {
                    this.values.put(UserXMLCatalog.PUBLIC_PREFIX + val2, atts.getValue("uri"));
                }
            } else if ("system".equals(rawName)) {
                String val3 = atts.getValue("systemId");
                if (val3 != null) {
                    this.values.put(UserXMLCatalog.SYSTEM_PREFIX + val3, atts.getValue("uri"));
                }
            } else if ("uri".equals(rawName) && (val = atts.getValue("name")) != null) {
                this.values.put(UserXMLCatalog.URI_PREFIX + val, atts.getValue("uri"));
            }
        }

        public Map getValues() {
            return this.values;
        }
    }
}

