/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.refactoring.api.ExtractSuperClassRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ExtractSuperClassPanel
extends CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_Selected", "LBL_ExtractSC_Member", "LBL_ExtractSC_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, NamedElement.class, Boolean.class};
    private final ExtractSuperClassRefactoring refactoring;
    private final TableModel tableModel;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JTable membersTable;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameText;
    private JScrollPane scrollPane;

    public ExtractSuperClassPanel(ExtractSuperClassRefactoring refactoring, final ParametersPanel parent) {
        this.refactoring = refactoring;
        this.tableModel = new TableModel();
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        String defaultName = "NewClass";
        this.nameText.setText(defaultName);
        this.nameText.setSelectionStart(0);
        this.nameText.setSelectionEnd(defaultName.length());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            public void insertUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            public void removeUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }
        });
    }

    public void requestFocus() {
        super.requestFocus();
        this.nameText.requestFocus();
    }

    public void initialize() {
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

            protected String extractText(Object value) {
                String displayValue = super.extractText(value);
                if (value instanceof MultipartId) {
                    displayValue = "implements " + displayValue;
                }
                return displayValue;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer());
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    public String getSuperClassName() {
        return this.nameText.getText();
    }

    public ExtractSuperClassRefactoring.MemberInfo[] getMembers() {
        ArrayList<ExtractSuperClassRefactoring.MemberInfo> list = new ArrayList<ExtractSuperClassRefactoring.MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object element = this.members[i][1];
            ExtractSuperClassRefactoring.MemberInfo member = element instanceof Field ? new ExtractSuperClassRefactoring.MemberInfo((Field)element) : (element instanceof JavaClass ? new ExtractSuperClassRefactoring.MemberInfo((JavaClass)element) : (element instanceof MultipartId ? new ExtractSuperClassRefactoring.MemberInfo((MultipartId)element) : new ExtractSuperClassRefactoring.MemberInfo((Method)element, (boolean)((Boolean)this.members[i][2]))));
            list.add(member);
        }
        return list.toArray(new ExtractSuperClassRefactoring.MemberInfo[list.size()]);
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.nameText = new JTextField();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.namePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"LBL_ExtractSC_Name"));
        this.namePanel.add((Component)this.nameLabel, "West");
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"LBL_ExtractSCLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.namePanel.add((Component)this.chooseLabel, "South");
        this.namePanel.add((Component)this.nameText, "Center");
        this.nameText.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"ACSD_SupeclassName"));
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"ACSD_SuperclassNameDescription"));
        this.add((Component)this.namePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"ACSD_MembersToExtract"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ExtractSuperClassPanel.class, (String)"ACSD_MembersToExtractDescription"));
        this.add((Component)this.scrollPane, "Center");
    }

    static /* synthetic */ Object[][] access$202(ExtractSuperClassPanel x0, Object[][] x1) {
        x0.members = x1;
        return x1;
    }

    private class TableModel
    extends AbstractTableModel {
        TableModel() {
            this.initialize();
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$ExtractSuperClassPanel == null ? (class$org$netbeans$modules$refactoring$ui$ExtractSuperClassPanel = ExtractSuperClassPanel.class$("org.netbeans.modules.refactoring.ui.ExtractSuperClassPanel")) : class$org$netbeans$modules$refactoring$ui$ExtractSuperClassPanel), (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        public int getRowCount() {
            return ExtractSuperClassPanel.this.members.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ExtractSuperClassPanel.this.members[rowIndex][columnIndex];
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((ExtractSuperClassPanel)ExtractSuperClassPanel.this).members[rowIndex][columnIndex] = value;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (ExtractSuperClassPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                Object element = ExtractSuperClassPanel.this.members[rowIndex][1];
                return !Modifier.isStatic(((Method)element).getModifiers()) && !Modifier.isAbstract(((Method)element).getModifiers());
            }
            return columnIndex == 0;
        }

        private void initialize() {
            JavaClass sourceType = ExtractSuperClassPanel.this.refactoring.getSourceType();
            if (sourceType == null) {
                return;
            }
            ArrayList result = new ArrayList();
            Iterator it = sourceType.getInterfaceNames().iterator();
            while (it.hasNext()) {
                result.add(it.next());
            }
            Feature[] features = sourceType.getFeatures().toArray(new Feature[0]);
            for (int j = 0; j < features.length; ++j) {
                if (!ExtractSuperClassPanel.this.refactoring.acceptFeature(features[j])) continue;
                result.add(features[j]);
            }
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    NamedElement ne1 = (NamedElement)o1;
                    NamedElement ne2 = (NamedElement)o2;
                    int result = ne1.getClass().getName().compareTo(ne2.getClass().getName());
                    if (result == 0) {
                        result = UIUtilities.getDisplayText(ne1).compareTo(UIUtilities.getDisplayText(ne2));
                    }
                    if (result == 0) {
                        result = ne1.refMofId().compareTo(ne2.refMofId());
                    }
                    return result;
                }
            });
            ExtractSuperClassPanel.access$202(ExtractSuperClassPanel.this, new Object[result.size()][3]);
            for (int i = 0; i < ExtractSuperClassPanel.this.members.length; ++i) {
                ((ExtractSuperClassPanel)ExtractSuperClassPanel.this).members[i][0] = Boolean.FALSE;
                ((ExtractSuperClassPanel)ExtractSuperClassPanel.this).members[i][1] = result.get(i);
                ((ExtractSuperClassPanel)ExtractSuperClassPanel.this).members[i][2] = ExtractSuperClassPanel.this.members[i][1] instanceof Method ? (Modifier.isAbstract(((Method)ExtractSuperClassPanel.this.members[i][1]).getModifiers()) ? Boolean.TRUE : Boolean.FALSE) : null;
            }
            this.fireTableDataChanged();
        }
    }
}

