/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassUI;
import org.netbeans.modules.refactoring.ui.MoveClassesUI;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class MoveClassAction
extends AbstractRefactoringAction {
    private boolean fromListener = false;
    private Set javaDataObjects;
    private FileObject targetFolder;
    private PasteType pasteType;

    public MoveClassAction() {
        super(NbBundle.getMessage((Class)MoveClassAction.class, (String)"LBL_MoveClassAction"), null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enabled(Node[] activatedNodes) {
        JEditorPane pane;
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        Lookup lkp = activatedNodes[0].getLookup();
        JavaDataObject javaObject = (JavaDataObject)lkp.lookup(JavaDataObject.class);
        if (javaObject != null && !((JMManager)JMManager.getManager()).mergedCPContains(javaObject.getPrimaryFile())) {
            return false;
        }
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane && (pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane()) != null) {
            return javaObject instanceof JavaDataObject;
        }
        Element elem = (Element)lkp.lookup(Element.class);
        if (javaObject != null && elem == null) {
            return true;
        }
        if (!(elem instanceof JavaClass)) {
            return false;
        }
        JavaClass clsElem = (JavaClass)elem;
        if (clsElem == null) {
            return false;
        }
        if (!clsElem.isValid()) {
            return false;
        }
        return clsElem.getDeclaringClass() == null;
    }

    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        if (this.fromListener) {
            if (this.javaDataObjects.size() == 1 && this.javaDataObjects.iterator().next() instanceof JavaDataObject) {
                return new MoveClassUI((JavaDataObject)this.javaDataObjects.iterator().next(), this.targetFolder, this.pasteType);
            }
            return new MoveClassesUI(this.javaDataObjects, this.targetFolder, this.pasteType);
        }
        if (selectedElement != null) {
            if (selectedElement instanceof ElementReference) {
                selectedElement = ((ElementReference)selectedElement).getElement();
            }
            if (selectedElement instanceof JavaClass) {
                return new MoveClassUI((JavaClass)selectedElement);
            }
        }
        if (nodes.length > 1) {
            return new MoveClassesUI(this.getJDOs(nodes));
        }
        JavaClass el = (JavaClass)nodes[0].getLookup().lookup(JavaClass.class);
        if (el != null && el.getDeclaringClass() == null) {
            return new MoveClassUI(el);
        }
        return new MoveClassUI((JavaDataObject)nodes[0].getCookie(JavaDataObject.class));
    }

    public void performAction(final Set a, final FileObject targetFolder, final PasteType pt) {
        Runnable run = new Runnable(){

            public void run() {
                MoveClassAction.this.fromListener = true;
                MoveClassAction.this.javaDataObjects = a;
                MoveClassAction.this.targetFolder = targetFolder;
                MoveClassAction.this.pasteType = pt;
                MoveClassAction.super.performAction(null);
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(run, NbBundle.getMessage((Class)MoveClassAction.class, (String)"LBL_MoveClasses"));
    }

    public void performAction() {
        this.fromListener = false;
        super.performAction();
    }

    private Set getJDOs(Node[] nodes) {
        HashSet<JavaDataObject> result = new HashSet<JavaDataObject>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            JavaDataObject jdo = (JavaDataObject)nodes[i].getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? MoveClassAction.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
            if (jdo == null) continue;
            result.add(jdo);
        }
        return result;
    }
}

