/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.faces;

import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.faces.MappingsHelper;

public class RemotingPhaseListener
implements PhaseListener {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.shale.remoting.Bundle");
    private MappingsHelper helper = new MappingsHelper();
    private transient Log log = null;

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Checking view identifier '" + context.getViewRoot().getViewId() + "'"));
        }
        Iterator mappings = this.helper.getMappings(context).getMappings().iterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            String resourceId = mapping.mapViewId(context);
            if (resourceId == null) continue;
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("View identifier '" + context.getViewRoot().getViewId() + "' matched pattern '" + mapping.getPattern() + "' with resource id '" + resourceId + "'"));
            }
            try {
                mapping.getProcessor().process(context, resourceId);
                break;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)RemotingPhaseListener.class);
        }
        return this.log;
    }
}

