/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Element;

public class ArchiveProjectProperties {
    private Project project;
    private AntProjectHelper helper;
    private EditableProperties projectProps;
    private EditableProperties privateProps;
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String SOURCE_ARCHIVE = "source.archive";
    public static final String DIST_DIR = "dist.dir";
    public static final String WAR_NAME = "war.name";
    public static final String PROXY_PROJECT_DIR = "proxy.project.dir";
    public static final String TMP_PROJ_DIR_VALUE = "tmpproj";
    public static final String DIST_DIR_VALUE = "dist";
    public static final String DIST_ARCHIVE = "dist.archive";
    public static final String CONTENT_DIR = "content.dir";
    public static final String CONF_DIR = "conf.dir";
    public static final String SETUP_DIR_VALUE = "setup";
    public static final String ARCHIVE_TYPE = "javaee.archive.type";
    public static final String PROJECT_TYPE_VALUE_UNKNOWN = "unknown";
    public static final String PROJECT_TYPE_VALUE_WAR = "war";
    public static final String PROJECT_TYPE_VALUE_EAR = "ear";
    public static final String PROJECT_TYPE_VALUE_CAR = "car";
    public static final String PROJECT_TYPE_VALUE_RAR = "rar";
    public static final String PROJECT_TYPE_VALUE_JAR = "jar";
    public static final String WAR_ARCHIVES = "javaee.archive.war.archives";
    public static final String JAR_ARCHIVES = "javaee.archive.jar.archives";
    public static final String RAR_ARCHIVES = "javaee.archive.rar.archives";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String CAR_ARCHIVES = "javaee.archive.car.archives";

    public ArchiveProjectProperties(Project project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
        this.privateProps = helper.getProperties("nbproject/private/private.properties");
        this.projectProps = helper.getProperties("nbproject/project.properties");
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    try {
                        ArchiveProjectProperties.this.helper.putProperties("nbproject/project.properties", ArchiveProjectProperties.this.projectProps);
                        ArchiveProjectProperties.this.helper.putProperties("nbproject/private/private.properties", ArchiveProjectProperties.this.privateProps);
                        Element data = ArchiveProjectProperties.this.helper.getPrimaryConfigurationData(true);
                        ArchiveProjectProperties.this.helper.putPrimaryConfigurationData(data, true);
                        ProjectManager.getDefault().saveProject(ArchiveProjectProperties.this.project);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)e.getException());
        }
    }

    public Object get(String propertyName) {
        String retVal = J2EE_SERVER_INSTANCE.equals(propertyName) ? this.privateProps.getProperty(J2EE_SERVER_INSTANCE) : this.projectProps.getProperty(propertyName);
        return retVal;
    }

    public void put(String propertyName, Object value) {
        if (J2EE_SERVER_INSTANCE.equals(propertyName)) {
            this.projectProps.put((Object)J2EE_SERVER_TYPE, (Object)Deployment.getDefault().getServerID((String)value));
            this.privateProps.put((Object)J2EE_SERVER_INSTANCE, value);
        } else {
            this.projectProps.put((Object)propertyName, value);
        }
    }

    public static void setServerInstance(final Project project, final AntProjectHelper helper, final String serverInstanceID) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                    EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                    ArchiveProjectProperties.setNewServerInstanceValue(serverInstanceID, projectProps, privateProps);
                    File projectFolder = FileUtil.toFile((FileObject)project.getProjectDirectory());
                    try {
                        AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, ArchiveProjectProperties.ANT_DEPLOY_BUILD_SCRIPT), (Object)ArchiveProjectProperties.mapType(projectProps.getProperty(ArchiveProjectProperties.ARCHIVE_TYPE)), (String)serverInstanceID);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                    File antDeployPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
                    if (antDeployPropsFile == null) {
                        privateProps.remove((Object)ArchiveProjectProperties.DEPLOY_ANT_PROPS_FILE);
                    } else {
                        privateProps.setProperty(ArchiveProjectProperties.DEPLOY_ANT_PROPS_FILE, antDeployPropsFile.getAbsolutePath());
                    }
                    helper.putProperties("nbproject/project.properties", projectProps);
                    helper.putProperties("nbproject/private/private.properties", privateProps);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    private static void setNewServerInstanceValue(String newServInstID, EditableProperties projectProps, EditableProperties privateProps) {
        projectProps.setProperty(J2EE_SERVER_TYPE, Deployment.getDefault().getServerID(newServInstID));
        privateProps.setProperty(J2EE_SERVER_INSTANCE, newServInstID);
    }

    public static Object mapType(String string) {
        Object retVal = J2eeModule.EJB;
        if (string.equals(PROJECT_TYPE_VALUE_CAR)) {
            retVal = J2eeModule.CLIENT;
        }
        if (string.equals(PROJECT_TYPE_VALUE_WAR)) {
            retVal = J2eeModule.WAR;
        }
        if (string.equals(PROJECT_TYPE_VALUE_JAR)) {
            retVal = J2eeModule.EJB;
        }
        if (string.equals(PROJECT_TYPE_VALUE_EAR)) {
            retVal = J2eeModule.EAR;
        }
        if (string.equals(PROJECT_TYPE_VALUE_RAR)) {
            retVal = J2eeModule.CONN;
        }
        return retVal;
    }
}

