/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MimeHeader;

public class MimeHeaders {
    private Vector headers = new Vector();

    public void removeAllHeaders() {
        this.headers.removeAllElements();
    }

    public void removeHeader(String string) {
        int n = 0;
        while (n < this.headers.size()) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(n);
            if (mimeHeader.getName().equalsIgnoreCase(string)) {
                this.headers.removeElementAt(n--);
            }
            ++n;
        }
    }

    public Iterator getAllHeaders() {
        return this.headers.iterator();
    }

    public String[] getHeader(String string) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.headers.size()) {
            objectArray = (Object[])this.headers.elementAt(n);
            if (objectArray.getName().equalsIgnoreCase(string) && objectArray.getValue() != null) {
                vector.addElement(objectArray.getValue());
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void addHeader(String string, String string2) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        int n = this.headers.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(n2);
            if (mimeHeader.getName().equalsIgnoreCase(string)) {
                this.headers.insertElementAt(new MimeHeader(string, string2), n2 + 1);
                return;
            }
            --n2;
        }
        this.headers.addElement(new MimeHeader(string, string2));
    }

    public void setHeader(String string, String string2) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        int n = 0;
        while (n < this.headers.size()) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(n);
            if (mimeHeader.getName().equalsIgnoreCase(string)) {
                if (!bl) {
                    this.headers.setElementAt(new MimeHeader(mimeHeader.getName(), string2), n);
                    bl = true;
                } else {
                    this.headers.removeElementAt(n--);
                }
            }
            ++n;
        }
        if (!bl) {
            this.addHeader(string, string2);
        }
    }

    public Iterator getMatchingHeaders(String[] stringArray) {
        return new MatchingIterator(stringArray, true);
    }

    public Iterator getNonMatchingHeaders(String[] stringArray) {
        return new MatchingIterator(stringArray, false);
    }

    class MatchingIterator
    implements Iterator {
        private boolean match;
        private Iterator iterator;
        private String[] names;
        private Object nextHeader;

        public void remove() {
            this.iterator.remove();
        }

        public boolean hasNext() {
            if (this.nextHeader == null) {
                this.nextHeader = this.nextMatch();
            }
            return this.nextHeader != null;
        }

        public Object next() {
            if (this.nextHeader != null) {
                Object object = this.nextHeader;
                this.nextHeader = null;
                return object;
            }
            if (this.hasNext()) {
                return this.nextHeader;
            }
            return null;
        }

        private Object nextMatch() {
            block0: while (this.iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)this.iterator.next();
                if (this.names == null) {
                    return this.match ? null : mimeHeader;
                }
                int n = 0;
                while (n < this.names.length) {
                    if (mimeHeader.getName().equalsIgnoreCase(this.names[n])) {
                        if (!this.match) continue block0;
                        return mimeHeader;
                    }
                    ++n;
                }
                if (this.match) continue;
                return mimeHeader;
            }
            return null;
        }

        MatchingIterator(String[] stringArray, boolean bl) {
            this.match = bl;
            this.names = stringArray;
            this.iterator = MimeHeaders.this.headers.iterator();
        }
    }
}

