/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;

public class MDRFinder
implements JCFinder,
SettingsChangeListener {
    public MDRepository repository = JavaModel.getJavaRepository();
    private boolean caseSensitive = false;
    private boolean showDeprecated = true;
    private boolean naturalSort = false;
    private FileObject fo;
    private Class kitClass;

    public MDRFinder(FileObject fo, Class kitClass) {
        this();
        this.fo = fo;
        this.kitClass = kitClass;
        this.caseSensitive = this.getCaseSensitive();
        this.showDeprecated = this.showDeprecated();
        this.naturalSort = this.getNaturalSort();
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public MDRFinder() {
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt == null || this.kitClass != evt.getKitClass()) {
            return;
        }
        if ("completion-case-sensitive".equals(evt.getSettingName())) {
            this.caseSensitive = this.getCaseSensitive();
        } else if ("completion-natural-sort".equals(evt.getSettingName())) {
            this.naturalSort = this.getNaturalSort();
        } else if ("show-deprecated-members".equals(evt.getSettingName())) {
            this.showDeprecated = this.showDeprecated();
        }
    }

    private boolean getCaseSensitive() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
    }

    private boolean getNaturalSort() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
    }

    private boolean showDeprecated() {
        return SettingsUtil.getBoolean((Class)this.kitClass, (String)"show-deprecated-members", (Boolean)ExtSettingsDefaults.defaultShowDeprecatedMembers);
    }

    private JavaPackage resolvePackage(String packageName, boolean caseSensitive) {
        JavaPackageClass pkgProxy = JavaModel.getDefaultExtent().getJavaPackage();
        if (this.fo != null) {
            JavaModel.setClassPath((FileObject)this.fo);
            JavaPackage pkg = pkgProxy.resolvePackage(packageName);
            if (pkg != null) {
                return pkg;
            }
        } else {
            return pkgProxy.resolvePackage(packageName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCPackage getExactPackage(String packageName) {
        this.repository.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            JavaPackage pkg = this.resolvePackage(packageName, true);
            if (pkg != null) {
                PackageImpl packageImpl = new PackageImpl(pkg);
                return packageImpl;
            }
        }
        finally {
            this.repository.endTrans(false);
        }
        return null;
    }

    public JCClass getExactClass(String classFullName) {
        Type cls = JavaModel.getDefaultExtent().getType().resolve(classFullName);
        if (cls instanceof UnresolvedClass) {
            return null;
        }
        return cls != null ? new ClassImpl((JavaClass)cls) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findPackages(String name, boolean exactMatch, boolean subPackages) {
        ArrayList<JCPackage> ret = new ArrayList<JCPackage>();
        this.repository.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            if (exactMatch) {
                JCPackage pkg = this.getExactPackage(name);
                if (pkg != null) {
                    ret.add(pkg);
                }
            } else {
                int index = name.lastIndexOf(46);
                String prefix = index > 0 ? name.substring(0, index) : "";
                JavaPackage pkg = this.resolvePackage(prefix, this.caseSensitive);
                if (pkg != null) {
                    Collection subpackages = pkg.getSubPackages();
                    ArrayList<JavaPackage> list = new ArrayList<JavaPackage>();
                    Iterator it = subpackages.iterator();
                    while (it.hasNext()) {
                        String csName;
                        JavaPackage subPackage = (JavaPackage)it.next();
                        String spName = this.caseSensitive ? subPackage.getName() : subPackage.getName().toUpperCase();
                        if (!spName.startsWith(csName = this.caseSensitive ? name : name.toUpperCase())) continue;
                        list.add(subPackage);
                    }
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        JavaPackage javaPkg = (JavaPackage)iter.next();
                        ret.add(new PackageImpl(javaPkg));
                    }
                }
            }
            if (subPackages) {
                int size = ret.size();
                for (int x = 0; x < size; ++x) {
                    PackageImpl pkgImpl = (PackageImpl)ret.get(x);
                    this.addSubPackages(ret, pkgImpl.javaPackage);
                }
            }
        }
        finally {
            this.repository.endTrans(false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findClasses(JCPackage pkg, String name, boolean exactMatch) {
        ArrayList<ClassImpl> ret = new ArrayList<ClassImpl>();
        this.repository.beginTrans(false);
        try {
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            String clsName = (pkg == null ? "" : pkg.getName() + '.') + name;
            if (this.fo == null) {
                ClassPath cp = JavaMetamodel.getManager().getClassPath();
                FileObject[] cpRoots = cp.getRoots();
                for (int i = 0; i < cpRoots.length; ++i) {
                    ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoots[i]));
                    if (ci == null) continue;
                    if (pkg == null) {
                        if (exactMatch) {
                            classes.addAll(ci.getClassesBySimpleName(name, this.caseSensitive));
                            continue;
                        }
                        classes.addAll((Collection<JavaClass>)ci.getClassesBySNPrefix(name, this.caseSensitive));
                        continue;
                    }
                    if (exactMatch) {
                        JavaClass cls = ci.getClassByFqn(name);
                        if (cls == null) continue;
                        classes.add(cls);
                        continue;
                    }
                    classes.addAll((Collection<JavaClass>)ci.getClassesByFQNPrefix(clsName));
                }
            } else {
                ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)this.fo));
                if (ci != null) {
                    if (pkg == null) {
                        if (exactMatch) {
                            classes.addAll(ci.getClassesBySimpleName(name, this.caseSensitive));
                        } else {
                            classes.addAll((Collection<JavaClass>)ci.getClassesBySNPrefix(name, this.caseSensitive));
                        }
                    } else if (exactMatch) {
                        JavaClass cls = ci.getClassByFqn(name);
                        if (cls != null) {
                            classes.add(cls);
                        }
                    } else {
                        classes.addAll((Collection<JavaClass>)ci.getClassesByFQNPrefix(clsName));
                    }
                }
            }
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                JavaClass jcls = (JavaClass)it.next();
                if (jcls == null || (jcls.getModifiers() & 1) == 0) continue;
                ret.add(new ClassImpl(jcls));
            }
            Collections.sort(ret, this.naturalSort ? JCBaseFinder.INSENSITIVE_CLASS_NAME_COMPARATOR : JCBaseFinder.CLASS_NAME_COMPARATOR);
        }
        finally {
            this.repository.endTrans(false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findFields(JCClass cls, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        TreeSet<FieldImpl> ts = this.naturalSort ? new TreeSet<FieldImpl>(JCBaseFinder.NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet();
        this.repository.beginTrans(false);
        try {
            JavaClass tempClass;
            Object typeProxy;
            Type o;
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            JavaClass jc = null;
            jc = cls instanceof ClassImpl ? ((ClassImpl)cls).javaSource : ((o = (typeProxy = JavaModel.getDefaultExtent().getType()).resolve(cls.getFullName())) instanceof JavaClass ? (JavaClass)o : (JavaClass)typeProxy.resolve("java.lang.Object"));
            if (jc == null) {
                typeProxy = new ArrayList();
                return typeProxy;
            }
            List clsList = this.getClassList(jc);
            String pkgName = cls.getPackageName();
            HashSet<JavaClass> ifaces = new HashSet<JavaClass>();
            for (int i = clsList.size() - 1; i >= 0; --i) {
                int outerInd;
                tempClass = (JavaClass)clsList.get(i);
                if (tempClass.isInterface()) {
                    ifaces.add(tempClass);
                }
                ifaces.addAll(tempClass.getInterfaces());
                String pName = MDRFinder.getPackageName(jc);
                boolean difPkg = !pName.equals(pkgName);
                List outerList = i == 0 && inspectOuterClasses && cls.getName().indexOf(46) >= 0 ? this.getOuterClasses(tempClass) : null;
                int n = outerInd = outerList != null ? outerList.size() - 1 : -1;
                do {
                    if (outerInd >= 0) {
                        tempClass = (JavaClass)outerList.get(outerInd--);
                    }
                    Iterator iter = tempClass.getFeatures().iterator();
                    while (iter.hasNext()) {
                        Feature feature = (Feature)iter.next();
                        if (!(feature instanceof Field)) continue;
                        Field fld = (Field)feature;
                        int mods = fld.getModifiers();
                        if (staticOnly && (mods & 8) == 0 || (mods & 2) != 0 || difPkg && (mods & 5) == 0 || outerInd > -1 && (jc.getModifiers() & 8) != 0 && (mods & 8) == 0 || (!exactMatch ? !this.startsWith(fld.getName(), name) : !fld.getName().equals(name))) continue;
                        boolean isLocal = jc.equals(tempClass) && outerInd == -1;
                        ts.add(new FieldImpl(fld, isLocal));
                    }
                } while (outerInd >= 0);
            }
            Iterator it = ifaces.iterator();
            while (it.hasNext()) {
                tempClass = (JavaClass)it.next();
                Iterator fieldsIter = tempClass.getFeatures().iterator();
                while (fieldsIter.hasNext()) {
                    Object tmp = fieldsIter.next();
                    if (!(tmp instanceof Field)) continue;
                    Field fld = (Field)tmp;
                    if (exactMatch ? !fld.getName().equals(name) : !this.startsWith(fld.getName(), name)) continue;
                    ts.add(new FieldImpl(fld));
                }
            }
            if (staticOnly && (exactMatch && "class".equals(name) || !exactMatch && this.startsWith("class", name))) {
                JavaCompletion.BaseField field = new JavaCompletion.BaseField((JCClass)JavaCompletion.CLASS_CLASS, "class", (JCType)JavaCompletion.CLASS_TYPE, 1);
                ts.add((FieldImpl)field);
            }
            if (cls == JavaCompletion.OBJECT_CLASS_ARRAY) {
                ts.add((FieldImpl)new JavaCompletion.BaseField((JCClass)JavaCompletion.INT_CLASS, "length", (JCType)JavaCompletion.INT_TYPE, 1));
            }
        }
        finally {
            this.repository.endTrans(false);
        }
        return new ArrayList(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findMethods(JCClass cls, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        TreeSet<MethodImpl> ts = this.naturalSort ? new TreeSet<MethodImpl>(JCBaseFinder.NATURAL_MEMBER_NAME_COMPARATOR) : new TreeSet();
        this.repository.beginTrans(false);
        try {
            Object typeProxy;
            Type o;
            ((JMManager)JMManager.getManager()).setSafeTrans(true);
            JavaClass jc = null;
            jc = cls instanceof ClassImpl ? ((ClassImpl)cls).javaSource : ((o = (typeProxy = JavaModel.getDefaultExtent().getType()).resolve(cls.getFullName())) instanceof JavaClass ? (JavaClass)o : (JavaClass)typeProxy.resolve("java.lang.Object"));
            if (jc == null) {
                typeProxy = new LinkedList();
                return typeProxy;
            }
            jc = (JavaClass)JMIUtils.getSourceElementIfExists((ClassDefinition)jc);
            List clsList = this.getClassList(jc);
            String pkgName = cls.getPackageName();
            for (int i = clsList.size() - 1; i >= 0; --i) {
                int outerInd;
                JavaClass tempCls = (JavaClass)clsList.get(i);
                if (tempCls == null) continue;
                String tempName = MDRFinder.getPackageName(tempCls);
                boolean difPkg = !tempName.equals(pkgName);
                List outerList = i == 0 && inspectOuterClasses && tempCls.getDeclaringClass() != null ? this.getOuterClasses(tempCls) : null;
                int n = outerInd = outerList != null ? outerList.size() - 1 : -1;
                do {
                    if (outerInd >= 0) {
                        tempCls = (JavaClass)outerList.get(outerInd--);
                    }
                    tempCls = (JavaClass)JMIUtils.getSourceElementIfExists((ClassDefinition)tempCls);
                    Iterator methodsIter = tempCls.getFeatures().iterator();
                    while (methodsIter.hasNext()) {
                        Object tmp = methodsIter.next();
                        if (!(tmp instanceof Method)) continue;
                        Method mtd = (Method)tmp;
                        int mods = mtd.getModifiers();
                        if (staticOnly && (mods & 8) == 0 || (mods & 2) != 0 || difPkg && (mods & 5) == 0 || outerInd > -1 && (jc.getModifiers() & 8) != 0 && (mods & 8) == 0 || (!exactMatch ? !this.startsWith(mtd.getName(), name) : !mtd.getName().equals(name))) continue;
                        boolean isLocal = jc.equals(tempCls) && outerInd == -1;
                        MethodImpl mtdImpl = new MethodImpl(mtd, isLocal);
                        if (ts.contains(mtdImpl)) {
                            ts.remove(mtdImpl);
                        }
                        ts.add(mtdImpl);
                    }
                } while (outerInd >= 0);
            }
        }
        finally {
            this.repository.endTrans(false);
        }
        return new ArrayList(ts);
    }

    private void addSubPackages(List list, JavaPackage pkg) {
        Iterator iter = pkg.getSubPackages().iterator();
        while (iter.hasNext()) {
            JavaPackage p = (JavaPackage)iter.next();
            list.add(new PackageImpl(p));
            this.addSubPackages(list, p);
        }
    }

    private List getClassListForList(List classes) {
        Iterator interfacesIt = classes.iterator();
        ArrayList ret = new ArrayList();
        while (interfacesIt.hasNext()) {
            ret.addAll(this.getClassList((JavaClass)interfacesIt.next()));
        }
        return ret;
    }

    private List getClassList(JavaClass jc) {
        ArrayList<JavaClass> ret = new ArrayList<JavaClass>();
        if (jc != null) {
            ret.add(jc);
            if (jc.isInterface()) {
                ret.addAll(this.getClassListForList(jc.getInterfaces()));
                JavaClass objectClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("java.lang.Object");
                if (objectClass != null) {
                    ret.add(objectClass);
                }
            } else {
                JavaClass superClass = jc.getSuperClass();
                if (superClass != null) {
                    ret.addAll(this.getClassList(superClass));
                }
                if (Modifier.isAbstract(jc.getModifiers())) {
                    ret.addAll(this.getClassListForList(jc.getInterfaces()));
                }
            }
        }
        return ret;
    }

    private List getOuterClasses(JavaClass jc) {
        ArrayList<JavaClass> outers = new ArrayList<JavaClass>();
        outers.add(jc);
        while (jc != null) {
            if ((jc = (JavaClass)jc.getDeclaringClass()) == null) continue;
            outers.add(jc);
        }
        return outers;
    }

    public Iterator getClasses() {
        return null;
    }

    public boolean append(JCClassProvider cp) {
        return true;
    }

    public void reset() {
    }

    public boolean notifyAppend(JCClass c, boolean appendFinished) {
        return false;
    }

    public void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public void setNaturalSort(boolean sort) {
        this.naturalSort = sort;
    }

    public void setShowDeprecated(boolean deprecated) {
        this.showDeprecated = deprecated;
    }

    public boolean getShowDeprecated() {
        return this.showDeprecated;
    }

    private boolean startsWith(String theString, String prefix) {
        return this.caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public JCClass createJCClass(JavaClass jc) {
        if (jc != null) {
            return new ClassImpl(jc);
        }
        throw new NullPointerException();
    }

    public JCType createJCType(Type desc) {
        if (desc instanceof PrimitiveType) {
            PrimitiveTypeKind kind = ((PrimitiveType)desc).getKind();
            if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
                return JavaCompletion.BOOLEAN_TYPE;
            }
            if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
                return JavaCompletion.INT_TYPE;
            }
            if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
                return JavaCompletion.CHAR_TYPE;
            }
            if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
                return JavaCompletion.BYTE_TYPE;
            }
            if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
                return JavaCompletion.SHORT_TYPE;
            }
            if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
                return JavaCompletion.LONG_TYPE;
            }
            if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
                return JavaCompletion.FLOAT_TYPE;
            }
            if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
                return JavaCompletion.DOUBLE_TYPE;
            }
            if (PrimitiveTypeKindEnum.VOID.equals((Object)kind)) {
                return JavaCompletion.VOID_TYPE;
            }
            return JavaCompletion.INVALID_TYPE;
        }
        if (desc instanceof JavaClass) {
            return new JavaCompletion.BaseType(this.createJCClass((JavaClass)desc), 0);
        }
        int depth = 0;
        while (desc instanceof Array) {
            ++depth;
            desc = ((Array)desc).getType();
        }
        return new JavaCompletion.BaseType(this.createJCType(desc).getClazz(), depth);
    }

    private static String getPackageName(JavaClass source) {
        if (source instanceof UnresolvedClass) {
            String name = source.getName();
            int index = name.lastIndexOf(46);
            return index < 0 ? "" : name.substring(0, index);
        }
        Resource resource = source.getResource();
        String result = null;
        if (resource != null) {
            result = resource.getPackageName();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public class MethodImpl
    extends ConstructorImpl
    implements JCMethod {
        private Method method;
        private int localFlag;

        public MethodImpl(Method method, boolean isLocal) {
            this(method);
            this.method = method;
            this.localFlag = isLocal ? 0x20000000 : 0;
        }

        public MethodImpl(Method method) {
            super((CallableFeature)method);
            this.method = method;
            this.localFlag = 0;
        }

        public String getName() {
            try {
                return this.method.getName();
            }
            catch (InvalidObjectException e) {
                return "";
            }
        }

        public int getModifiers() {
            try {
                return this.method.getModifiers() | this.localFlag;
            }
            catch (InvalidObjectException e) {
                return 0;
            }
        }

        public JCType getReturnType() {
            try {
                return MDRFinder.this.createJCType(this.method.getType());
            }
            catch (InvalidObjectException e) {
                return JavaCompletion.INVALID_TYPE;
            }
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCMethod m = (JCMethod)o;
            int order = this.getName().compareTo(m.getName());
            if (order == 0) {
                order = super.compareTo(o);
            }
            return order;
        }

        public int hashCode() {
            return this.getName().hashCode() ^ super.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCMethod) {
                return this.compareTo(o) == 0;
            }
            return false;
        }

        public String toString() {
            String rtn = this.getReturnType().toString();
            return this.toString(rtn.length() > 0 ? rtn + ' ' : "", this.getName());
        }
    }

    public class ConstructorImpl
    implements JCConstructor {
        private CallableFeature constr;

        public ConstructorImpl(CallableFeature constr) {
            this.constr = constr;
        }

        public JCClass getClazz() {
            try {
                return new ClassImpl((JavaClass)this.constr.getDeclaringClass());
            }
            catch (InvalidObjectException e) {
                return JavaCompletion.NULL_CLASS;
            }
        }

        public int getTagOffset() {
            return 0;
        }

        public int getModifiers() {
            try {
                return this.constr.getModifiers();
            }
            catch (InvalidObjectException e) {
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCParameter[] getParameters() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                List coll = this.constr.getParameters();
                JCParameter[] params = new JCParameter[coll.size()];
                Iterator iter = coll.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    params[x] = new ParameterImpl((Parameter)iter.next());
                    ++x;
                }
                JCParameter[] jCParameterArray = params;
                return jCParameterArray;
            }
            catch (InvalidObjectException e) {
                JCParameter[] jCParameterArray = new JCParameter[]{};
                return jCParameterArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCClass[] getExceptions() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                List coll = this.constr.getExceptions();
                JCClass[] exs = new JCClass[coll.size()];
                Iterator iter = coll.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    JavaClass exSource = (JavaClass)iter.next();
                    exs[x] = MDRFinder.this.createJCClass(exSource);
                    ++x;
                }
                JCClass[] jCClassArray = exs;
                return jCClassArray;
            }
            catch (InvalidObjectException e) {
                JCClass[] jCClassArray = new JCClass[]{};
                return jCClassArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCConstructor c = (JCConstructor)o;
            int order = 0;
            JCParameter[] mp = c.getParameters();
            JCParameter[] parameters = this.getParameters();
            int commonCnt = Math.min(parameters.length, mp.length);
            for (int i = 0; i < commonCnt; ++i) {
                order = parameters[i].compareTo((Object)mp[i]);
                if (order == 0) continue;
                return order;
            }
            order = parameters.length - mp.length;
            return order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCConstructor) {
                return this.compareTo(o) == 0;
            }
            return false;
        }

        public int hashCode() {
            JCParameter[] parameters = this.getParameters();
            int h = 0;
            for (int i = 0; i < parameters.length; ++i) {
                h ^= parameters[i].hashCode();
            }
            return h;
        }

        String toString(String returnTypeName, String methodName) {
            StringBuffer sb = new StringBuffer(Modifier.toString(this.getModifiers()));
            sb.append(' ');
            sb.append(returnTypeName);
            sb.append(methodName);
            sb.append('(');
            JCParameter[] parameters = this.getParameters();
            int cntM1 = parameters.length - 1;
            for (int i = 0; i <= cntM1; ++i) {
                sb.append(parameters[i].toString());
                if (i >= cntM1) continue;
                sb.append(", ");
            }
            sb.append(')');
            JCClass[] exceptions = this.getExceptions();
            cntM1 = exceptions.length - 1;
            if (cntM1 >= 0) {
                sb.append(" throws ");
                for (int i = 0; i <= cntM1; ++i) {
                    sb.append(exceptions[i].toString());
                    if (i >= cntM1) continue;
                    sb.append(", ");
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString("", this.getClazz().getName());
        }
    }

    public class FieldImpl
    implements JCField {
        private Field field;
        private int localFlag;

        public FieldImpl(Field field, boolean isLocal) {
            this.field = field;
            this.localFlag = isLocal ? 0x20000000 : 0;
        }

        public FieldImpl(Field field) {
            this.field = field;
            this.localFlag = 0;
        }

        public String getName() {
            try {
                return this.field.getName();
            }
            catch (InvalidObjectException e) {
                return "";
            }
        }

        public JCType getType() {
            try {
                return MDRFinder.this.createJCType(this.field.getType());
            }
            catch (InvalidObjectException e) {
                return JavaCompletion.INVALID_TYPE;
            }
        }

        public int getModifiers() {
            try {
                return this.field.getModifiers() | this.localFlag;
            }
            catch (InvalidObjectException e) {
                return 0;
            }
        }

        public JCClass getClazz() {
            try {
                return new ClassImpl((JavaClass)this.field.getDeclaringClass());
            }
            catch (InvalidObjectException e) {
                return JavaCompletion.NULL_CLASS;
            }
        }

        public int getTagOffset() {
            return 0;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCField f = (JCField)o;
            if (this == o) {
                return 0;
            }
            int order = this.getType().compareTo((Object)f.getType());
            if (order == 0) {
                order = this.getName().compareTo(f.getName());
            }
            return order;
        }

        public int hashCode() {
            return this.getType().hashCode() ^ this.getName().hashCode() ^ this.getModifiers();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCField) {
                JCField p = (JCField)o;
                return this.getName().equals(p.getName()) && this.getType().equals(p.getType());
            }
            return false;
        }

        public String toString() {
            return Modifier.toString(this.getModifiers()) + ' ' + this.getType() + ' ' + this.getName();
        }
    }

    public class ParameterImpl
    implements JCParameter {
        private Parameter param;

        public ParameterImpl(Parameter param) {
            this.param = param;
        }

        public String getName() {
            try {
                return this.param.getName();
            }
            catch (InvalidObjectException e) {
                return "";
            }
        }

        public JCType getType() {
            try {
                return MDRFinder.this.createJCType(this.param.getType());
            }
            catch (InvalidObjectException e) {
                return JavaCompletion.INVALID_TYPE;
            }
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCParameter p = (JCParameter)o;
            return this.getType().compareTo((Object)p.getType());
        }

        public int hashCode() {
            return this.getType().hashCode() ^ this.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCParameter) {
                JCParameter p = (JCParameter)o;
                return this.getType().equals(p.getType());
            }
            return false;
        }

        public String toString() {
            return this.getType().toString() + ' ' + this.getName();
        }
    }

    public class ClassImpl
    implements JCClass {
        private final JavaClass javaSource;
        private final String stringValue;
        private final String packageName;
        private final String fullName;
        private final String className;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassImpl(JavaClass source) {
            int pkgNameLength;
            String pkgName;
            String temp;
            this.javaSource = source;
            MDRFinder.this.repository.beginTrans(false);
            try {
                temp = source.getName();
                pkgName = MDRFinder.getPackageName(source);
            }
            catch (InvalidObjectException e) {
                pkgName = "";
                temp = "";
            }
            finally {
                MDRFinder.this.repository.endTrans();
            }
            this.fullName = temp;
            this.packageName = pkgName;
            if (pkgName.length() != 0) {
                pkgName = pkgName + ".";
            }
            this.className = (pkgNameLength = pkgName.length()) > temp.length() ? "" : temp.substring(pkgNameLength);
            this.stringValue = pkgName + this.className.replace('.', '$');
        }

        public final String getName() {
            return this.className;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public int getTagOffset() {
            return -1;
        }

        public boolean isInterface() {
            try {
                return this.javaSource.isInterface();
            }
            catch (InvalidObjectException e) {
                return false;
            }
        }

        public int getModifiers() {
            try {
                return this.javaSource.getModifiers();
            }
            catch (InvalidObjectException e) {
                return 0;
            }
        }

        public JCClass getSuperclass() {
            try {
                JavaClass superDesc = this.javaSource.getSuperClass();
                return superDesc != null ? MDRFinder.this.createJCClass(superDesc) : null;
            }
            catch (InvalidObjectException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCClass[] getInterfaces() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                List coll = this.javaSource.getInterfaces();
                JCClass[] superinterfaces = new JCClass[coll.size()];
                Iterator iter = coll.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    JavaClass inter = (JavaClass)iter.next();
                    superinterfaces[x] = MDRFinder.this.createJCClass(inter);
                    ++x;
                }
                JCClass[] jCClassArray = superinterfaces;
                return jCClassArray;
            }
            catch (InvalidObjectException e) {
                JCClass[] jCClassArray = new JCClass[]{};
                return jCClassArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCField[] getFields() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                List coll = this.javaSource.getFeatures();
                ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>(coll.size());
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Object temp = iter.next();
                    if (!(temp instanceof Field)) continue;
                    fields.add(new FieldImpl((Field)temp));
                }
                JCField[] jCFieldArray = fields.toArray(new JCField[fields.size()]);
                return jCFieldArray;
            }
            catch (InvalidObjectException e) {
                JCField[] jCFieldArray = new JCField[]{};
                return jCFieldArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCConstructor[] getConstructors() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                JavaClass tempCls = (JavaClass)JMIUtils.getSourceElementIfExists((ClassDefinition)this.javaSource);
                List coll = tempCls.getFeatures();
                ArrayList<ConstructorImpl> constr = new ArrayList<ConstructorImpl>(coll.size());
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Object temp = iter.next();
                    if (!(temp instanceof Constructor)) continue;
                    constr.add(new ConstructorImpl((CallableFeature)((Constructor)temp)));
                }
                JCConstructor[] jCConstructorArray = constr.toArray(new JCConstructor[constr.size()]);
                return jCConstructorArray;
            }
            catch (InvalidObjectException e) {
                JCConstructor[] jCConstructorArray = new JCConstructor[]{};
                return jCConstructorArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCMethod[] getMethods() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                List coll = this.javaSource.getFeatures();
                ArrayList<MethodImpl> fields = new ArrayList<MethodImpl>(coll.size());
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Object temp = iter.next();
                    if (!(temp instanceof Method)) continue;
                    fields.add(new MethodImpl((Method)temp));
                }
                JCMethod[] jCMethodArray = fields.toArray(new JCMethod[fields.size()]);
                return jCMethodArray;
            }
            catch (InvalidObjectException e) {
                JCMethod[] jCMethodArray = new JCMethod[]{};
                return jCMethodArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCClass c = (JCClass)o;
            int order = this.getPackageName().compareTo(c.getPackageName());
            if (order == 0) {
                order = this.getName().compareTo(c.getName());
            }
            return order;
        }

        public int hashCode() {
            return this.getName().hashCode() ^ this.getPackageName().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCClass) {
                JCClass c = (JCClass)o;
                return this.getName().equals(c.getName()) && this.getPackageName().equals(c.getPackageName());
            }
            return false;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public class PackageImpl
    implements JCPackage {
        JavaPackage javaPackage;

        public PackageImpl(JavaPackage javaPackage) {
            this.javaPackage = javaPackage;
        }

        public final String getName() {
            try {
                return this.javaPackage.getName();
            }
            catch (InvalidObjectException e) {
                return "";
            }
        }

        public String getLastName() {
            String name = this.getName();
            return name.substring(name.lastIndexOf(46) + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JCClass[] getClasses() {
            MDRFinder.this.repository.beginTrans(false);
            try {
                ((JMManager)JMManager.getManager()).setSafeTrans(true);
                ArrayList coll = new ArrayList();
                if (MDRFinder.this.fo == null) {
                    ClassPath cp = JavaMetamodel.getManager().getClassPath();
                    FileObject[] cpRoots = cp.getRoots();
                    for (int i = 0; i < cpRoots.length; ++i) {
                        ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoots[i]));
                        if (ci == null) continue;
                        coll.addAll(ci.getClassesByFQNPrefix(this.javaPackage.getName() + '.'));
                    }
                } else {
                    ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)MDRFinder.this.fo));
                    if (ci != null) {
                        coll.addAll(ci.getClassesByFQNPrefix(this.javaPackage.getName() + '.'));
                    }
                }
                JCClass[] res = new JCClass[coll.size()];
                Iterator iter = coll.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    res[x] = new ClassImpl((JavaClass)iter.next());
                    ++x;
                }
                JCClass[] jCClassArray = res;
                return jCClassArray;
            }
            catch (InvalidObjectException e) {
                JCClass[] jCClassArray = new JCClass[]{};
                return jCClassArray;
            }
            finally {
                MDRFinder.this.repository.endTrans(false);
            }
        }

        public void setClasses(JCClass[] classes) {
        }

        public int getDotCount() {
            int dotCnt = 0;
            int i = 0;
            do {
                ++dotCnt;
            } while ((i = this.getName().indexOf(46, i) + 1) > 0);
            return dotCnt;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCPackage p = (JCPackage)o;
            return this.getName().compareTo(p.getName());
        }

        public int hashCode() {
            return this.javaPackage.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCPackage) {
                return this.getName().equals(((JCPackage)o).getName());
            }
            if (o instanceof String) {
                return this.getName().equals((String)o);
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

