/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCFinderFactory;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;

public class NbJavaFastImport
extends JavaFastImport {
    static final /* synthetic */ boolean $assertionsDisabled;

    public NbJavaFastImport(JTextComponent target) {
        super(target);
    }

    protected JCFinder getFinder() {
        BaseDocument doc = Utilities.getDocument((JTextComponent)this.target);
        if (!$assertionsDisabled && doc == null) {
            throw new AssertionError();
        }
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (!$assertionsDisabled && dobj == null) {
            throw new AssertionError();
        }
        FileObject fo = dobj.getPrimaryFile();
        return JCFinderFactory.getDefault().getFinder(fo);
    }

    protected List findClasses(String exp, int importType) {
        ArrayList<Object> ret;
        block5: {
            ret = new ArrayList<Object>();
            JCFinder finder = this.getFinder();
            List classes = finder.findClasses(null, exp, true);
            if (classes == null) break block5;
            if (importType == 1) {
                JCPackage pkg;
                TreeSet<JCPackage> ts = new TreeSet<JCPackage>();
                for (int i = 0; i < classes.size(); ++i) {
                    pkg = finder.getExactPackage(((JCClass)classes.get(i)).getPackageName());
                    if (pkg == null) continue;
                    ts.add(pkg);
                }
                Iterator it = ts.iterator();
                while (it.hasNext()) {
                    pkg = (JCPackage)it.next();
                    ret.add(new JCResultItem.PackageResultItem(pkg, true));
                }
            } else {
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    JCClass cls = (JCClass)it.next();
                    ret.add(new JCResultItem.ClassResultItem(cls, true));
                }
            }
        }
        return ret;
    }

    protected void setFastImportSettings(int importType) {
        BaseOptions bop;
        Class kitClass = Utilities.getKitClass((JTextComponent)this.target);
        if (kitClass != null && (bop = BaseOptions.getOptions((Class)kitClass)) instanceof JavaOptions) {
            ((JavaOptions)bop).setFastImportSelection(importType);
        }
    }

    protected void updateImport(Object item) {
        SourceElement se;
        SourceCookie sc;
        DataObject dob;
        Object o;
        if ((item instanceof JCResultItem.PackageResultItem || item instanceof JCResultItem.ClassResultItem) && (o = this.target.getDocument().getProperty("stream")) instanceof DataObject && (dob = (DataObject)o) != null && (sc = (SourceCookie)dob.getCookie(SourceCookie.class)) != null && (se = sc.getSource()) != null) {
            try {
                if (item instanceof JCResultItem.ClassResultItem) {
                    JCClass cls = (JCClass)((JCResultItem.ClassResultItem)item).getAssociatedObject();
                    if (this.isAlreadyImported(cls) || this.isInTheSamePackage(cls)) {
                        Utilities.setStatusText((JTextComponent)this.target, (String)MessageFormat.format(NbBundle.getMessage((Class)NbJavaFastImport.class, (String)"NJFI_CLASS_ALREADY_IMPORTED"), cls.getFullName()));
                    } else {
                        se.addImport(new Import(Identifier.create((String)cls.getFullName()), false));
                    }
                } else if (item instanceof JCResultItem.PackageResultItem) {
                    String pkgName = ((JCResultItem.PackageResultItem)item).getItemText();
                    se.addImport(new Import(Identifier.create((String)pkgName), true));
                }
            }
            catch (SourceException e) {
                // empty catch block
            }
        }
    }

    private boolean isInTheSamePackage(JCClass cls) {
        BaseDocument doc = Utilities.getDocument((JTextComponent)this.target);
        if (doc == null) {
            return false;
        }
        NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)doc.getSyntaxSupport().get(NbJavaSyntaxSupport.class);
        if (sup == null) {
            return false;
        }
        JCClass topClass = sup.getTopClass();
        if (topClass == null) {
            return false;
        }
        String topPkgName = topClass.getPackageName();
        if (topPkgName == null) {
            topPkgName = "";
        }
        return topPkgName.equals(cls.getPackageName());
    }

    static {
        $assertionsDisabled = !NbJavaFastImport.class.desiredAssertionStatus();
    }
}

