/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codetemplates;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;

public class JavaCodeTemplateProcessor
implements CodeTemplateProcessor {
    private static final String INSTANCEOF_HINT = "instanceof";
    private static final String INDEX_HINT = "index";
    private static final String ARRAY_HINT = "array";
    private static final String TYPE_HINT = "type";
    private CodeTemplateInsertRequest request;

    JavaCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
        if (!typingChange) {
            // empty if block
        }
    }

    public void updateDefaultValues() {
        String varName;
        NbJavaJMISyntaxSupport jss;
        SyntaxSupport syntaxSupport;
        Map hints;
        CodeTemplateParameter master;
        JTextComponent component = this.request.getComponent();
        int offset = component.getCaretPosition();
        ArrayList<CodeTemplateParameter> typeHints = new ArrayList<CodeTemplateParameter>();
        Iterator masterParamsIt = this.request.getMasterParameters().iterator();
        while (masterParamsIt.hasNext()) {
            Collection globalVarNames;
            Iterator varNamesIt;
            master = (CodeTemplateParameter)masterParamsIt.next();
            hints = master.getHints();
            if (hints.isEmpty()) continue;
            String instanceOfType = (String)hints.get(INSTANCEOF_HINT);
            if (instanceOfType != null && (syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)component)) instanceof NbJavaJMISyntaxSupport) {
                String varName2;
                jss = (NbJavaJMISyntaxSupport)syntaxSupport;
                Type type = jss.getTypeFromName(instanceOfType, false, jss.getJavaClass(offset), true);
                Collection varNames = jss.getLocalVariableNamesOfType(offset, type);
                boolean resolved = false;
                varNamesIt = varNames.iterator();
                if (varNamesIt.hasNext()) {
                    varName2 = (String)varNamesIt.next();
                    master.setValue(varName2);
                    resolved = true;
                }
                if (!resolved && (varNamesIt = (varNames = jss.getGlobalVariableNamesOfType(offset, type)).iterator()).hasNext()) {
                    varName2 = (String)varNamesIt.next();
                    master.setValue(varName2);
                    resolved = true;
                }
            }
            if (hints.get(TYPE_HINT) != null) {
                typeHints.add(master);
            }
            if ("true".equals(hints.get(INDEX_HINT)) && (syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)component)) instanceof NbJavaJMISyntaxSupport) {
                jss = (NbJavaJMISyntaxSupport)syntaxSupport;
                boolean attemptLetters = true;
                int attemptIndex = 0;
                while (true) {
                    String attemptVarName = attemptLetters ? String.valueOf((char)(105 + attemptIndex)) : "i" + String.valueOf(attemptIndex);
                    Set varNames = jss.getLocalVariableMap(offset).keySet();
                    boolean varUsed = false;
                    Iterator varNamesIt2 = varNames.iterator();
                    while (varNamesIt2.hasNext()) {
                        String varName3 = (String)varNamesIt2.next();
                        if (!attemptVarName.equals(varName3)) continue;
                        varUsed = true;
                        break;
                    }
                    if (!varUsed) {
                        master.setValue(attemptVarName);
                        break;
                    }
                    if ("z".equals(attemptVarName)) {
                        attemptLetters = false;
                        attemptIndex = 2;
                        continue;
                    }
                    ++attemptIndex;
                }
            }
            if (!"true".equals(hints.get(ARRAY_HINT)) || !((syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)component)) instanceof NbJavaJMISyntaxSupport)) continue;
            jss = (NbJavaJMISyntaxSupport)syntaxSupport;
            Collection localVarNames = jss.getLocalVariableNamesOfArrayType(offset);
            boolean resolved = false;
            Iterator varNamesIt3 = localVarNames.iterator();
            if (varNamesIt3.hasNext()) {
                varName = (String)varNamesIt3.next();
                master.setValue(varName);
                resolved = true;
            }
            if (resolved || !(varNamesIt = (globalVarNames = jss.getGlobalVariableNamesOfArrayType(offset)).iterator()).hasNext()) continue;
            String varName4 = (String)varNamesIt.next();
            Collection localVars = jss.getLocalVariableNames(varName4, offset, true);
            if (localVars.size() > 0) {
                try {
                    JavaClass javaClass;
                    JavaClass jc = javaClass = jss.getJavaClass(offset);
                    Field field = null;
                    while (field == null && jc != null) {
                        field = jc.getField(varName4, true);
                        if (field != null || !(jc instanceof JavaClass)) continue;
                        jc = jc.getDeclaringClass();
                    }
                    if (field != null) {
                        varName4 = Modifier.isStatic(field.getModifiers()) ? ((JavaClass)field.getDeclaringClass()).getSimpleName() + '.' + varName4 : (javaClass != jc ? jc.getSimpleName() + ".this." + varName4 : "this." + varName4);
                    }
                }
                catch (InvalidObjectException e) {
                    // empty catch block
                }
            }
            master.setValue(varName4);
            resolved = true;
        }
        Iterator iter = typeHints.iterator();
        while (iter.hasNext()) {
            Type type;
            master = (CodeTemplateParameter)iter.next();
            hints = master.getHints();
            String typeHint = (String)hints.get(TYPE_HINT);
            syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)component);
            if (!(syntaxSupport instanceof NbJavaJMISyntaxSupport)) continue;
            jss = (NbJavaJMISyntaxSupport)syntaxSupport;
            JavaClass jc = jss.getJavaClass(offset);
            TypeReference id = JavaModelUtil.resolveImportsForType((Element)jc, (Type)(type = jss.getTypeFromName(typeHint, false, jc, true)));
            varName = id instanceof MultipartId ? JavaCodeTemplateProcessor.multipartIdToName((MultipartId)id) : typeHint;
            master.setValue(varName);
        }
    }

    private static String multipartIdToName(MultipartId id) {
        LinkedList<String> list = new LinkedList<String>();
        while (id != null) {
            list.addFirst(id.getName());
            id = id.getParent();
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    public void release() {
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new JavaCodeTemplateProcessor(request);
        }
    }
}

