/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private final FileStatusCache cache;
    private MessageFormat format;

    Annotator(CvsVersioningSystem cvs) {
        this.cache = cvs.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fields = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.endsWith("Format")) continue;
            this.initDefaultColor(name.substring(0, name.length() - 6));
        }
        String string = System.getProperty("netbeans.experimental.cvs.ui.statusLabelFormat");
        if (string != null) {
            ErrorManager.getDefault().log(16, "CVS status labels use format \"" + string + "\" where:");
            ErrorManager.getDefault().log(16, "\t{0} stays for revision");
            ErrorManager.getDefault().log(16, "\t{1} stays for status");
            ErrorManager.getDefault().log(16, "\t{2} stays for branch or sticky tag");
            ErrorManager.getDefault().log(16, "\t{3} stays for binary flag");
            this.format = new MessageFormat(string);
        }
    }

    private void initDefaultColor(String name) {
        String color = System.getProperty("cvs.color." + name);
        if (color == null) {
            return;
        }
        this.setAnnotationColor(name, color);
    }

    private void setAnnotationColor(String name, String colorString) {
        try {
            Field field = Annotator.class.getDeclaredField(name + "Format");
            MessageFormat format = new MessageFormat("<font color=\"" + colorString + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, format);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        String textAnnotationFormat = CvsModuleConfig.getDefault().getTextAnnotationsFormat();
        if (textAnnotationFormat != null && file != null && (status & 0x195E) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(info, file);
            } else {
                String sticky = Utils.getSticky(file);
                textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky.substring(1) + "]" : (sticky == null ? " [" + info.getShortStatusText() + "]" : " [" + info.getShortStatusText() + "; " + sticky.substring(1) + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage((Class)Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: {
                return name;
            }
            case 8: {
                return uptodateFormat.format(new Object[]{name, textAnnotation});
            }
            case 16: {
                return modifiedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 4: {
                return newLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 256: {
                return removedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 2048: {
                return deletedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 512: {
                return newInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 32: {
                return modifiedInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 1024: {
                return removedInRepositoryFormat.format(new Object[]{name, textAnnotation});
            }
            case 4096: {
                return addedLocallyFormat.format(new Object[]{name, textAnnotation});
            }
            case 128: {
                return mergeableFormat.format(new Object[]{name, textAnnotation});
            }
            case 64: {
                return conflictFormat.format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return excludedFormat.format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String formatAnnotation(FileInformation info, File file) {
        String stickyString;
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        String revisionString = "";
        String binaryString = "";
        Entry entry = info.getEntry(file);
        if (entry != null) {
            revisionString = entry.getRevision();
            binaryString = entry.getOptions();
            if (!"-kb".equals(binaryString)) {
                binaryString = "";
            }
        }
        stickyString = (stickyString = Utils.getSticky(file)) != null ? stickyString.substring(1) : "";
        Object[] arguments = new Object[]{revisionString, statusString, stickyString, binaryString};
        return this.format.format(arguments, new StringBuffer(), (FieldPosition)null).toString().trim();
    }

    private String annotateFolderNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        String textAnnotationFormat = CvsModuleConfig.getDefault().getTextAnnotationsFormat();
        if (textAnnotationFormat != null && file != null && (status & 0xFFFFFFFE) != 0) {
            String sticky = Utils.getSticky(file);
            textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky.substring(1) + "]" : (sticky == null ? " [" + info.getShortStatusText() + "]" : " [" + info.getShortStatusText() + "; " + sticky.substring(1) + "]"));
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage((Class)Annotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return name;
            }
            case 4: 
            case 8: 
            case 4096: {
                return uptodateFormat.format(new Object[]{name, textAnnotation});
            }
            case 2: {
                return excludedFormat.format(new Object[]{name, textAnnotation});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    String annotateNameHtml(String name, Set files, int includeStatus) {
        if (files.size() == 0) {
            return name;
        }
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        Iterator i = files.iterator();
        while (i.hasNext()) {
            FileObject fo = (FileObject)i.next();
            File file = FileUtil.toFile((FileObject)fo);
            FileInformation info = this.cache.getStatus(file);
            int status = info.getStatus();
            if ((status & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = fo.isFolder();
        }
        if (!folderAnnotation && files.size() > 1) {
            folderAnnotation = Annotator.looksLikeLogicalFolder(files);
        }
        if (mostImportantInfo == null) {
            return this.htmlEncode(name);
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return Utils.getComparableStatus(a.getStatus()) < Utils.getComparableStatus(b.getStatus());
    }

    String annotateName(String name, Set files) {
        return null;
    }

    Image annotateFolderIcon(Set roots, Image icon) {
        File file;
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        boolean allExcluded = true;
        boolean modified = false;
        Map map = this.cache.getAllModifiedFiles();
        HashMap<File, FileInformation> modifiedFiles = new HashMap<File, FileInformation>();
        Iterator<Object> i = map.keySet().iterator();
        while (i.hasNext()) {
            file = (File)i.next();
            FileInformation info = (FileInformation)map.get(file);
            if (info.isDirectory() || (info.getStatus() & 0x19D4) == 0) continue;
            modifiedFiles.put(file, info);
        }
        i = roots.iterator();
        while (i.hasNext()) {
            int status;
            FileInformation info;
            File mf;
            Iterator j;
            file = (File)i.next();
            if (file instanceof FlatFolder) {
                j = modifiedFiles.keySet().iterator();
                while (j.hasNext()) {
                    mf = (File)j.next();
                    if (!mf.getParentFile().equals(file) || (info = (FileInformation)modifiedFiles.get(mf)).isDirectory()) continue;
                    status = info.getStatus();
                    if (status == 64) {
                        Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                    }
                    modified = true;
                    allExcluded &= config.isExcludedFromCommit(mf.getAbsolutePath());
                }
                continue;
            }
            j = modifiedFiles.keySet().iterator();
            while (j.hasNext()) {
                mf = (File)j.next();
                if (!Utils.isParentOrEqual(file, mf)) continue;
                info = (FileInformation)modifiedFiles.get(mf);
                status = info.getStatus();
                if (status == 64) {
                    Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
                }
                modified = true;
                allExcluded &= config.isExcludedFromCommit(mf.getAbsolutePath());
            }
        }
        if (modified && !allExcluded) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return icon;
    }

    public static Action[] getActions(Lookup context) {
        ResourceBundle loc = NbBundle.getBundle((Class)Annotator.class);
        Node[] nodes = context.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]);
        File[] files = Utils.getCurrentContext(nodes).getRootFiles();
        if (Annotator.onlyFolders(files)) {
            return new Action[]{SystemActionBridge.createAction((Action)SystemAction.get((Class)StatusAction.class), loc.getString("CTL_PopupMenuItem_Status"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)DiffAction.class), loc.getString("CTL_PopupMenuItem_Diff"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)UpdateAction.class), loc.getString("CTL_PopupMenuItem_Update"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)CommitAction.class), loc.getString("CTL_PopupMenuItem_Commit"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)TagAction.class), loc.getString("CTL_PopupMenuItem_Tag"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)BranchAction.class), loc.getString("CTL_PopupMenuItem_Branch"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)SwitchBranchAction.class), loc.getString("CTL_PopupMenuItem_SwitchBranch"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)MergeBranchAction.class), loc.getString("CTL_PopupMenuItem_MergeBranch"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)SearchHistoryAction.class), loc.getString("CTL_PopupMenuItem_SearchHistory"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)GetCleanAction.class), loc.getString("CTL_PopupMenuItem_GetClean"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)ResolveConflictsAction.class), loc.getString("CTL_PopupMenuItem_ResolveConflicts"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(nodes) == 2 ? loc.getString("CTL_PopupMenuItem_Unignore") : loc.getString("CTL_PopupMenuItem_Ignore"), context)};
        }
        return new Action[]{SystemActionBridge.createAction((Action)SystemAction.get((Class)StatusAction.class), loc.getString("CTL_PopupMenuItem_Status"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)DiffAction.class), loc.getString("CTL_PopupMenuItem_Diff"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)UpdateAction.class), loc.getString("CTL_PopupMenuItem_Update"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)CommitAction.class), loc.getString("CTL_PopupMenuItem_Commit"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)TagAction.class), loc.getString("CTL_PopupMenuItem_Tag"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)BranchAction.class), loc.getString("CTL_PopupMenuItem_Branch"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)SwitchBranchAction.class), loc.getString("CTL_PopupMenuItem_SwitchBranch"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)MergeBranchAction.class), loc.getString("CTL_PopupMenuItem_MergeBranch"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)AnnotationsAction.class), ((AnnotationsAction)SystemAction.get((Class)AnnotationsAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)SearchHistoryAction.class), loc.getString("CTL_PopupMenuItem_SearchHistory"), context), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)GetCleanAction.class), loc.getString("CTL_PopupMenuItem_GetClean"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)ResolveConflictsAction.class), loc.getString("CTL_PopupMenuItem_ResolveConflicts"), context), SystemActionBridge.createAction((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(nodes) == 2 ? loc.getString("CTL_PopupMenuItem_Unignore") : loc.getString("CTL_PopupMenuItem_Ignore"), context)};
    }

    private static boolean onlyFolders(File[] files) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                return false;
            }
            if (files[i].exists() || cache.getStatus(files[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    static boolean looksLikeLogicalFolder(Set files) {
        Iterator it = files.iterator();
        FileObject fo = (FileObject)it.next();
        try {
            DataObject etalon = DataObject.find((FileObject)fo);
            while (it.hasNext()) {
                FileObject fileObject = (FileObject)it.next();
                if (etalon.equals(DataObject.find((FileObject)fileObject))) continue;
                return true;
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, "Can not find dataobject, annottaing as logical folder");
            err.notify((Throwable)e);
            return true;
        }
        return false;
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage((Class)Annotator.class, (String)key);
        return new MessageFormat(format);
    }
}

