/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteGzippedFileHandler;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class CvsVersioningSystem {
    private static CvsVersioningSystem instance;
    public static final String FILENAME_CVSIGNORE = ".cvsignore";
    public static final String FILENAME_CVS = "CVS";
    public static final Object EVENT_PARAM_CHANGED;
    public static final Object PARAM_BATCH_REFRESH_RUNNING;
    private static final String FILENAME_CVS_REPOSITORY = "CVS/Repository";
    private static final Set textExtensions;
    private final Map clientsCache = new HashMap();
    private final Map params = new HashMap();
    private GlobalOptions defaultGlobalOptions;
    private FileStatusCache fileStatusCache;
    private CvsLiteAdminHandler sah;
    private CvsLiteFileHandler workdirFileHandler;
    private CvsLiteGzippedFileHandler workdirGzippedFileHandler;
    private FilesystemHandler filesystemHandler;
    private Annotator annotator;
    private final Set userIgnorePatterns = new HashSet();
    private boolean userIgnorePatternsReset;
    private long userIgnorePatternsTimestamp;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public static synchronized CvsVersioningSystem getInstance() {
        if (instance == null) {
            instance = new CvsVersioningSystem();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.defaultGlobalOptions = CvsVersioningSystem.createGlobalOptions();
        this.sah = new CvsLiteAdminHandler();
        this.workdirFileHandler = new CvsLiteFileHandler();
        this.workdirGzippedFileHandler = new CvsLiteGzippedFileHandler();
        this.fileStatusCache = new FileStatusCache(this);
        this.filesystemHandler = new FilesystemHandler(this);
        this.annotator = new Annotator(this);
        this.cleanup();
    }

    private void cleanup() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (FileStatusProvider.getInstance() != null) {
                    CvsVersioningSystem.this.fileStatusCache.addVersioningListener(FileStatusProvider.getInstance());
                    FileStatusProvider.getInstance().init();
                }
                MetadataAttic.cleanUp();
                CvsVersioningSystem.this.fileStatusCache.cleanUp();
                CvsVersioningSystem.this.filesystemHandler.init();
            }
        }, 3000);
    }

    private CvsVersioningSystem() {
    }

    public CvsFileTableModel getFileTableModel(Context context, int displayStatuses) {
        return new CvsFileTableModel(context, displayStatuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRuntime getClientRuntime(String cvsRoot) {
        ClientRuntime clientRuntime;
        cvsRoot.length();
        Map map = this.clientsCache;
        synchronized (map) {
            clientRuntime = (ClientRuntime)this.clientsCache.get(cvsRoot);
            if (clientRuntime == null) {
                clientRuntime = new ClientRuntime(cvsRoot);
                this.clientsCache.put(cvsRoot, clientRuntime);
            }
        }
        return clientRuntime;
    }

    String detectCvsRoot(Command cmd) throws NotVersionedException {
        File[] files;
        AddCommand c;
        if (cmd instanceof AddCommand) {
            c = (AddCommand)cmd;
            files = c.getFiles();
        } else if (cmd instanceof BasicCommand) {
            c = (BasicCommand)cmd;
            files = c.getFiles();
        } else {
            throw new NotVersionedException("Cannot determine CVSRoot for command: " + cmd);
        }
        File oneFile = files[0];
        try {
            String cvsRoot = Utils.getCVSRootFor(oneFile);
            return cvsRoot;
        }
        catch (IOException e) {
            throw new NotVersionedException("Cannot determine CVSRoot for: " + oneFile);
        }
    }

    public RequestProcessor.Task post(Command cmd, ExecutorSupport mgr) throws CommandException, AuthenticationException, NotVersionedException, IllegalCommandException, IOException {
        return this.post(cmd, this.defaultGlobalOptions, mgr);
    }

    public RequestProcessor.Task post(Command cmd, GlobalOptions options, ExecutorSupport mgr) throws IllegalCommandException {
        ClientRuntime clientRuntime = this.getClientRuntime(cmd, options);
        RequestProcessor.Task task = clientRuntime.createTask(cmd, options != null ? options : this.defaultGlobalOptions, mgr);
        task.schedule(0);
        return task;
    }

    public ClientRuntime getClientRuntime(Command cmd, GlobalOptions options) {
        String root;
        if (options != null && options.getCVSRoot() != null) {
            root = options.getCVSRoot();
        } else {
            try {
                root = this.detectCvsRoot(cmd);
            }
            catch (NotVersionedException e) {
                if (options == null) {
                    return null;
                }
                root = options.getCVSRoot();
            }
        }
        return this.getClientRuntime(root);
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    boolean isIgnored(File file) {
        File cvsRepository;
        if (file.isDirectory() && (cvsRepository = new File(file, FILENAME_CVS_REPOSITORY)).canRead()) {
            return false;
        }
        String name = file.getName();
        if (FILENAME_CVSIGNORE.equals(name)) {
            return false;
        }
        if (".nbintdb".equals(name)) {
            return true;
        }
        HashSet<Pattern> patterns = new HashSet<Pattern>(Arrays.asList(CvsModuleConfig.getDefault().getIgnoredFilePatterns()));
        this.addUserPatterns(patterns);
        this.addCvsIgnorePatterns(patterns, file.getParentFile());
        Iterator i = patterns.iterator();
        while (i.hasNext()) {
            Pattern pattern = (Pattern)i.next();
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        int sharability = SharabilityQuery.getSharability((File)file);
        if (sharability == 2) {
            try {
                this.setIgnored(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addUserPatterns(Set patterns) {
        File userIgnores = new File(System.getProperty("user.home"), FILENAME_CVSIGNORE);
        long lm = userIgnores.lastModified();
        if (lm > this.userIgnorePatternsTimestamp || lm == 0L && this.userIgnorePatternsTimestamp > 0L) {
            this.userIgnorePatternsTimestamp = lm;
            this.parseUserPatterns(userIgnores);
        }
        if (this.userIgnorePatternsReset) {
            patterns.clear();
        }
        patterns.addAll(this.userIgnorePatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUserPatterns(File userIgnores) {
        this.userIgnorePatternsReset = false;
        this.userIgnorePatterns.clear();
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(userIgnores));
            while ((s = r.readLine()) != null) {
                if ("!".equals(s)) {
                    this.userIgnorePatternsReset = true;
                    this.userIgnorePatterns.clear();
                    continue;
                }
                try {
                    this.userIgnorePatterns.add(CvsVersioningSystem.sh2regex(s));
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Pattern sh2regex(String s) throws IOException {
        s = s.replaceAll("\\.", "\\\\.");
        s = s.replaceAll("\\*", ".*");
        try {
            return Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }

    boolean isManaged(File file) {
        if (file.isDirectory() && file.getName().equals(FILENAME_CVS)) {
            return false;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (file != null) {
            File repository = new File(file, FILENAME_CVS_REPOSITORY);
            if (repository.canRead()) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private void addCvsIgnorePatterns(Set patterns, File file) {
        Set shPatterns;
        try {
            shPatterns = this.readCvsIgnoreEntries(file);
        }
        catch (IOException e) {
            return;
        }
        Iterator i = shPatterns.iterator();
        while (i.hasNext()) {
            String shPattern = (String)i.next();
            if ("!".equals(shPattern)) {
                patterns.clear();
                continue;
            }
            try {
                patterns.add(CvsVersioningSystem.sh2regex(shPattern));
            }
            catch (IOException e) {}
        }
    }

    public boolean isInCvsIgnore(File file) {
        try {
            return this.readCvsIgnoreEntries(file.getParentFile()).contains(file.getName());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    public boolean isIgnoredFilename(File file) {
        return FILENAME_CVS.equals(file.getName());
    }

    public AdminHandler getAdminHandler() {
        return this.sah;
    }

    public FileHandler getFileHandler() {
        return this.workdirFileHandler;
    }

    public FileHandler getGzippedFileHandler() {
        return this.workdirGzippedFileHandler;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameter(Object key) {
        Map map = this.params;
        synchronized (map) {
            return this.params.get(key);
        }
    }

    public KeywordSubstitutionOptions getDefaultKeywordSubstitution(File file) {
        return this.isText(file) || !this.isBinary(file) ? KeywordSubstitutionOptions.DEFAULT : KeywordSubstitutionOptions.BINARY;
    }

    public boolean isText(File file) {
        if (FILENAME_CVSIGNORE.equals(file.getName())) {
            return true;
        }
        try {
            Entry entry = this.sah.getEntry(file);
            if (entry != null) {
                return !entry.isBinary();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return false;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            return dao.getCookie(EditorCookie.class) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            if (fo.getMIMEType().startsWith("text")) {
                return true;
            }
            return textExtensions.contains(fo.getExt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinary(File file) {
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            in = new BufferedInputStream(in);
            for (int i = 0; i < 1024; ++i) {
                int ch = in.read();
                if (ch == -1) {
                    break;
                }
                if (ch >= 32 || ch == 9 || ch == 10 || ch == 13) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.notify(1, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Object key, Object value) {
        Object old;
        Map map = this.params;
        synchronized (map) {
            old = this.params.put(key, value);
        }
        if (old != value) {
            this.listenerSupport.fireVersioningEvent(EVENT_PARAM_CHANGED, key);
        }
    }

    public void setIgnored(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            try {
                this.setIgnored(files[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void setIgnored(File file) throws IOException {
        if (file.exists()) {
            this.addToCvsIgnore(file);
        }
    }

    public void setNotignored(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            try {
                this.removeFromCvsIgnore(files[i]);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void addToCvsIgnore(File file) throws IOException {
        Set entries = this.readCvsIgnoreEntries(file.getParentFile());
        if (entries.add(file.getName())) {
            this.writeCvsIgnoreEntries(file.getParentFile(), entries);
        }
    }

    private void removeFromCvsIgnore(File file) throws IOException {
        Set entries = this.readCvsIgnoreEntries(file.getParentFile());
        if (entries.remove(file.getName())) {
            this.writeCvsIgnoreEntries(file.getParentFile(), entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set readCvsIgnoreEntries(File directory) throws IOException {
        File cvsIgnore = new File(directory, FILENAME_CVSIGNORE);
        HashSet<String> entries = new HashSet<String>(5);
        if (!cvsIgnore.canRead()) {
            return entries;
        }
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(new FileReader(cvsIgnore));
            while ((s = r.readLine()) != null) {
                entries.add(s.trim());
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCvsIgnoreEntries(File directory, Set entries) throws IOException {
        File cvsIgnore = new File(directory, FILENAME_CVSIGNORE);
        FileObject fo = FileUtil.toFileObject((File)cvsIgnore);
        if (entries.size() == 0) {
            if (fo != null) {
                fo.delete();
            }
            return;
        }
        if (fo == null || !fo.isValid()) {
            fo = FileUtil.toFileObject((File)directory);
            fo = fo.createData(FILENAME_CVSIGNORE);
        }
        FileLock lock = fo.lock();
        PrintWriter w = null;
        try {
            w = new PrintWriter(fo.getOutputStream(lock));
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                w.println(i.next());
            }
        }
        finally {
            lock.releaseLock();
            if (w != null) {
                w.close();
            }
        }
    }

    FilesystemHandler getFileSystemHandler() {
        return this.filesystemHandler;
    }

    public static void ignoreFilesystemEvents(boolean ignore) {
        FilesystemHandler.ignoreEvents(ignore);
    }

    public static boolean ignoringFilesystemEvents() {
        return FilesystemHandler.ignoringEvents();
    }

    void shutdown() {
        this.filesystemHandler.shutdown();
        FileStatusProvider.getInstance().shutdown();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    CvsSynchronizeTopComponent.getInstance().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static GlobalOptions createGlobalOptions() {
        GlobalOptions globalOptions = new GlobalOptions();
        if (System.getProperty("cvsClientLog") == null) {
            int gzipLevel = 4;
            String level = System.getProperty("netbeans.experimental.cvs.io.compressionLevel");
            if (level != null) {
                try {
                    int candidate = Integer.parseInt(level);
                    if (0 <= candidate && candidate < 10) {
                        gzipLevel = candidate;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (gzipLevel > 0) {
                globalOptions.setCompressionLevel(gzipLevel);
            }
        }
        return globalOptions;
    }

    static {
        EVENT_PARAM_CHANGED = new Object();
        PARAM_BATCH_REFRESH_RUNNING = new Object();
        textExtensions = new HashSet<String>(Arrays.asList("txt", "xml", "html", "properties", "mf", "jhm", "hs", "form"));
    }
}

