/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.docscan.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

class Choosers {
    public static Node icons = null;
    private static Component CONVERTOR_COMPONENT = new Panel();

    Choosers() {
    }

    public static Node projectView() {
        Children.SortedArray kids = new Children.SortedArray();
        kids.setComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Node)o1).getDisplayName().compareToIgnoreCase(((Node)o2).getDisplayName());
            }
        });
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int pi = 0; pi < projects.length; ++pi) {
            Project project = projects[pi];
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] group = sources.getSourceGroups("generic");
            if (group.length == 0) continue;
            if (group.length > 1) {
                kids.add(new Node[]{new ProjectNode(project)});
                continue;
            }
            FileObject folder = group[0].getRootFolder();
            if (!folder.isFolder()) continue;
            kids.add(new Node[]{new FolderNode(folder, group[0])});
            Choosers.prepareFolderIcons(folder);
        }
        AbstractNode content = new AbstractNode((Children)kids){

            public void setName(String name) {
                super.setName(name);
                super.setIconBase("org/netbeans/modules/tasklist/docscan/repository");
            }
        };
        content.setName(Util.getString("projects"));
        return content;
    }

    private static void prepareFolderIcons(FileObject fo) {
        if (icons == null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                icons = dobj.getNodeDelegate();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private static Image convertIconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        BufferedImage bImage = new BufferedImage(width, height, 2);
        icon.paintIcon(CONVERTOR_COMPONENT, bImage.getGraphics(), 0, 0);
        return bImage;
    }

    public static class FolderNode
    extends AbstractNode {
        private final FileObject fileObject;
        private SourceGroup group;

        public FolderNode(FileObject fileObject, SourceGroup root) {
            super((Children)new FolderContent(fileObject, root), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
            this.group = root;
        }

        public FolderNode(FileObject fileObject) {
            super((Children)new FolderContent(fileObject), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            return this.fileObject.getName();
        }

        public Image getIcon(int type) {
            Icon icon;
            if (this.group != null && (icon = this.group.getIcon(false)) != null) {
                return Choosers.convertIconToImage(icon);
            }
            if (icons != null) {
                return icons.getIcon(type);
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            Icon icon;
            if (this.group != null && (icon = this.group.getIcon(true)) != null) {
                return Choosers.convertIconToImage(icon);
            }
            if (icons != null) {
                return icons.getOpenedIcon(type);
            }
            return super.getOpenedIcon(type);
        }

        private static class FolderContent
        extends Children.Keys {
            private final FileObject fileObject;
            private final SourceGroup group;

            public FolderContent(FileObject fileObject) {
                this(fileObject, null);
            }

            public FolderContent(FileObject fileObject, SourceGroup group) {
                this.fileObject = fileObject;
                this.group = group;
            }

            protected void addNotify() {
                FileObject[] fo = this.fileObject.getChildren();
                Arrays.sort(fo, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((FileObject)o1).getNameExt().compareToIgnoreCase(((FileObject)o2).getNameExt());
                    }
                });
                this.setKeys(Arrays.asList(fo));
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object key) {
                FileObject fo = (FileObject)key;
                if (fo.isFolder() && (this.group == null || this.group.contains(fo))) {
                    return new Node[]{new FolderNode(fo)};
                }
                return new Node[0];
            }
        }
    }

    public static class ProjectNode
    extends AbstractNode {
        private final Project project;

        public ProjectNode(Project project) {
            this(new Children.SortedArray(), project);
        }

        private ProjectNode(Children.SortedArray children, Project project) {
            super((Children)children);
            this.project = project;
            children.setComparator(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Node)o1).getDisplayName().compareToIgnoreCase(((Node)o2).getDisplayName());
                }
            });
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] group = sources.getSourceGroups("generic");
            Arrays.sort(group, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((SourceGroup)o1).getDisplayName().compareToIgnoreCase(((SourceGroup)o2).getDisplayName());
                }
            });
            for (int i = 0; i < group.length; ++i) {
                FileObject folder = group[i].getRootFolder();
                if (!folder.isFolder()) continue;
                children.add(new Node[]{new FolderNode(folder, group[i])});
                Choosers.prepareFolderIcons(folder);
            }
        }

        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public Image getIcon(int type) {
            return Choosers.convertIconToImage(ProjectUtils.getInformation((Project)this.project).getIcon());
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }
}

