/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.reflect.Modifier;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.netbeans.modules.javacore.parser.ArrayMeasure;
import org.netbeans.modules.javacore.parser.ClassInfo;
import org.netbeans.modules.javacore.parser.ClassNameMeasure;
import org.netbeans.modules.javacore.parser.InfoUtil;
import org.netbeans.modules.javacore.parser.Measure;
import org.netbeans.modules.javacore.parser.StringMeasure;
import org.netbeans.modules.javacore.parser.TypeRef;

class ClassInfoMeasure
implements Measure {
    public static final ClassInfoMeasure INSTANCE = new ClassInfoMeasure();
    private static final int TYPE_WEIGHT = 100;
    private static final int NAME_WEIGHT = 60;
    private static final int EXTENDS_WEIGHT = 10;
    private static final int IMPLEMENTS_WEIGHT = 10;
    private static final int MEMBERS_WEIGHT = 20;

    private ClassInfoMeasure() {
    }

    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof ClassInfo) {
            JavaClassImpl refInfo = (JavaClassImpl)((Object)refObject);
            ClassInfo astInfo = (ClassInfo)ast;
            int result = 0;
            if (refInfo.isInterface() != Modifier.isInterface(astInfo.modifiers)) {
                result = 100;
            }
            result += StringMeasure.INSTANCE.getDistance(refInfo.getName(), astInfo.name) * 60;
            if (refInfo.isPersisted()) {
                result += ClassNameMeasure.INSTANCE.getDistance(refInfo.getSuperclassRef(), astInfo.superclass) * 10;
                List ifcRefs = refInfo.getInterfaceRefs();
                result += new ArrayMeasure(ClassNameMeasure.INSTANCE).getDistance(ifcRefs == null ? new Object[]{} : ifcRefs.toArray(), astInfo.interfaces) * 10;
                String[] refMemberNames = InfoUtil.getElementNames(refInfo.getFeatures());
                String[] astMemberNames = InfoUtil.getElementNames(astInfo.features);
                result += new ArrayMeasure(StringMeasure.INSTANCE).getDistance(refMemberNames, astMemberNames) * 20;
            }
            return (result /= 100) > 1000 ? 1000 : result;
        }
        if (ast instanceof TypeRef) {
            TypeRef tr = SemiPersistentElement.typeToTypeRef((Type)((JavaClass)refObject));
            if (tr.equals(ast)) {
                return 0;
            }
            return 1000;
        }
        return 1000;
    }
}

