/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;

class ClassElementFinder
implements ClassElement.Finder {
    private static final boolean DEBUG = false;
    private static ClassElementFinder finder;

    private ClassElementFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassElementFinder getInstance() {
        if (finder != null) {
            return finder;
        }
        Class clazz = ClassElementFinder.class;
        synchronized (clazz) {
            if (finder == null) {
                finder = new ClassElementFinder();
            }
        }
        return finder;
    }

    private ClassElement findSpecifiedInner(FileObject projectArtefact, String fullName, int packageDelimiter, int innerDelimiter) {
        int classnameOffset;
        String topName;
        String packName = packageDelimiter >= 0 ? fullName.substring(0, packageDelimiter) : "";
        FileObject fo = this.searchFile(projectArtefact, packName, topName = fullName.substring(classnameOffset = packageDelimiter + 1, innerDelimiter));
        if (fo == null) {
            return null;
        }
        StringTokenizer tt = new StringTokenizer(fullName.substring(classnameOffset), "$");
        return this.findClassInFile(fo, tt);
    }

    private ClassElement findInSource(SourceElement s, Enumeration names) {
        Identifier classID = Identifier.create((String)((String)names.nextElement()));
        ClassElement c = s.getClass(classID);
        if (!names.hasMoreElements() || c == null) {
            return c;
        }
        while ((c = c.getClass(classID = Identifier.create((String)((String)names.nextElement())))) != null && names.hasMoreElements()) {
        }
        return c;
    }

    public ClassElement find(String className, FileObject projectArtefact) {
        String packName;
        String baseName;
        int lastDot;
        int innerDelimiter = -1;
        if (lastDot < 0) {
            return null;
        }
        for (lastDot = className.length() - 1; lastDot > 0 && className.charAt(lastDot) != '.'; --lastDot) {
            if (className.charAt(lastDot) != '$') continue;
            innerDelimiter = lastDot;
        }
        if (lastDot == 0) {
            if (className.charAt(lastDot) == '.') {
                return null;
            }
            --lastDot;
        }
        if (innerDelimiter > 0) {
            return this.findSpecifiedInner(projectArtefact, className, lastDot, innerDelimiter);
        }
        int nameEnd = className.length();
        if (lastDot > 0) {
            baseName = className.substring(lastDot + 1, nameEnd);
            packName = className.substring(0, lastDot);
        } else {
            baseName = className;
            packName = "";
        }
        while (true) {
            String partName;
            ClassElement result;
            FileObject fo;
            if ((fo = this.searchFile(projectArtefact, packName, baseName)) != null && (result = this.findClassInFile(fo, new StringTokenizer(partName = lastDot > 0 ? className.substring(lastDot + 1) : className, "."))) != null) {
                return result;
            }
            if (lastDot <= 0) break;
            nameEnd = lastDot;
            if ((lastDot = className.lastIndexOf(46, lastDot - 1)) > 0) {
                baseName = className.substring(lastDot + 1, nameEnd);
                packName = className.substring(0, lastDot);
                continue;
            }
            packName = "";
            baseName = className.substring(0, nameEnd);
        }
        return null;
    }

    private ClassElement findClassInFile(FileObject f, Enumeration names) {
        SourceElement s;
        try {
            DataObject d = DataObject.find((FileObject)f);
            SourceCookie sc = (SourceCookie)d.getCookie(SourceCookie.class);
            if (sc == null) {
                return null;
            }
            s = sc.getSource();
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        return this.findInSource(s, names);
    }

    private FileObject searchFile(FileObject projectArtefact, String packName, String baseName) {
        StringBuffer sb = new StringBuffer(packName.replace('.', '/'));
        if (packName.length() != 0) {
            sb.append('/');
        }
        sb.append(baseName);
        String resNameBase = sb.toString();
        FileObject result = null;
        ClassPath classPath = ClassPath.getClassPath((FileObject)projectArtefact, (String)"classpath/source");
        if (classPath != null && (result = classPath.findResource(resNameBase + ".java")) != null) {
            return result;
        }
        classPath = ClassPath.getClassPath((FileObject)projectArtefact, (String)"classpath/compile");
        if (classPath != null) {
            result = classPath.findResource(resNameBase + ".class");
            if (result != null) {
                ClassPath.Entry root = ClassElementFinder.findRoot(classPath, result);
                FileObject[] sources = ClassElementFinder.findSourceFile(root, resNameBase);
                if (sources.length == 1) {
                    return sources[0];
                }
                return result;
            }
            Iterator it = classPath.entries().iterator();
            while (it.hasNext()) {
                ClassPath cp;
                ClassPath.Entry entry = (ClassPath.Entry)it.next();
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                if (sourceRoots.length <= 0 || (result = (cp = ClassPathSupport.createClassPath((FileObject[])sourceRoots)).findResource(resNameBase + ".java")) == null) continue;
                return result;
            }
        }
        if ((classPath = ClassPath.getClassPath((FileObject)projectArtefact, (String)"classpath/boot")) != null && (result = classPath.findResource(resNameBase + ".class")) != null) {
            ClassPath.Entry root = ClassElementFinder.findRoot(classPath, result);
            FileObject[] sources = ClassElementFinder.findSourceFile(root, resNameBase);
            if (sources.length == 1) {
                return sources[0];
            }
            return result;
        }
        return null;
    }

    public ClassElement find(Class clazz, FileObject context) {
        return null;
    }

    private static FileObject[] findSourceFile(ClassPath.Entry root, String resourceName) {
        HashSet result = new HashSet();
        if (resourceName != null) {
            resourceName = resourceName + ".java";
            FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots();
            if (sourceRoots.length > 0) {
                ClassPath cp = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
                result.addAll(cp.findAllResources(resourceName));
            }
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private static ClassPath.Entry findRoot(ClassPath cp, FileObject file) {
        FileObject owner = cp.findOwnerRoot(file);
        Iterator it = cp.entries().iterator();
        while (it.hasNext()) {
            ClassPath.Entry entry = (ClassPath.Entry)it.next();
            FileObject root = entry.getRoot();
            if (root == null || !root.equals(owner)) continue;
            return entry;
        }
        return null;
    }
}

