/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeChildren;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeFilter;
import org.netbeans.modules.java.ui.nodes.elements.ClassChildren;
import org.netbeans.modules.java.ui.nodes.elements.ClassElementFilter;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.EnumChildren;
import org.netbeans.modules.java.ui.nodes.elements.EnumFilter;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.actions.NewAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public final class Categories {
    private static final Object CATEGORY_FIELDS = new Object();
    private static final Object CATEGORY_METHODS = new Object();
    private static final Object CATEGORY_CONSTRUCTORS = new Object();
    private static final Object CATEGORY_CONSTANTS = new Object();
    private static final Object CATEGORY_ANN_TYPE_METHODS = new Object();
    private static final List CLASS_CATEGORIES;
    private static final List INTERFACE_CATEGORIES;
    private static final List ENUM_CATEGORIES;
    private static final List ANNTYPES_CATEGORIES;
    public static final int FILTER_CATEGORIES = 4096;
    private static final SystemAction[] CATEGORY_ACTIONS;
    static final int[][] FILTERS;
    static final String[] NAMES;
    static final String[] SHORTDESCRS;
    static final String[] CATEGORY_ICONS;

    public static final Children createClassChildren(ClassDefinition element, SourceNodeFactory factory, boolean writable) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren children = new CategorizingChildren(factory, element, writable);
            ClassElementFilter filter = new ClassElementFilter();
            filter.setOrder(new int[]{2, 4, 16, 8, 4096});
            children.setFilter(filter);
            return children;
        }
        return new ClassChildren(factory, element);
    }

    public static final Children createEnumChildren(JavaEnum element, SourceNodeFactory factory, boolean writable) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren children = new CategorizingChildren(factory, (ClassDefinition)element, writable);
            EnumFilter filter = new EnumFilter();
            filter.setOrder(new int[]{2, 4, 16, 8, 4096});
            children.setFilter(filter);
            return children;
        }
        return new EnumChildren(factory, element);
    }

    public static final Children createAnnotationTypeChildren(AnnotationType element, SourceNodeFactory factory, boolean writable) {
        if (ElementNode.getSourceOptions().getCategoriesUsage()) {
            CategorizingChildren children = new CategorizingChildren(factory, (ClassDefinition)element, writable);
            AnnotationTypeFilter filter = new AnnotationTypeFilter();
            filter.setOrder(new int[]{2, 4, 16, 8, 4096});
            children.setFilter(filter);
            return children;
        }
        return new AnnotationTypeChildren(factory, element);
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)Categories.class, (String)key);
    }

    static {
        CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)NewAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)PropertiesAction.class)};
        FILTERS = new int[][]{{64}, {32}, {128}, {1024}, {1024}};
        NAMES = new String[]{Categories.getString("Fields"), Categories.getString("Constructors"), Categories.getString("Methods"), Categories.getString("Constants"), Categories.getString("AnnTypeMethods")};
        SHORTDESCRS = new String[]{Categories.getString("Fields_HINT"), Categories.getString("Constructors_HINT"), Categories.getString("Methods_HINT"), Categories.getString("Constants_HINT"), Categories.getString("AnnTypeMethods_HINT")};
        CATEGORY_ICONS = new String[]{"org/openide/src/resources/variables", "org/openide/src/resources/constructors", "org/openide/src/resources/methods", "org/netbeans/modules/java/resources/constants", "org/openide/src/resources/methods"};
        CLASS_CATEGORIES = new ArrayList(4);
        CLASS_CATEGORIES.add(CATEGORY_FIELDS);
        CLASS_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        CLASS_CATEGORIES.add(CATEGORY_METHODS);
        INTERFACE_CATEGORIES = new ArrayList(2);
        INTERFACE_CATEGORIES.add(CATEGORY_FIELDS);
        INTERFACE_CATEGORIES.add(CATEGORY_METHODS);
        ENUM_CATEGORIES = new ArrayList(4);
        ENUM_CATEGORIES.add(CATEGORY_CONSTANTS);
        ENUM_CATEGORIES.add(CATEGORY_FIELDS);
        ENUM_CATEGORIES.add(CATEGORY_CONSTRUCTORS);
        ENUM_CATEGORIES.add(CATEGORY_METHODS);
        ANNTYPES_CATEGORIES = new ArrayList(2);
        ANNTYPES_CATEGORIES.add(CATEGORY_FIELDS);
        ANNTYPES_CATEGORIES.add(CATEGORY_ANN_TYPE_METHODS);
    }

    static final class ElementCategoryNode
    extends AbstractNode {
        ClassDefinition element;
        int newTypeIndex;

        private static ClassChildren createChildren(SourceNodeFactory f, ClassDefinition jc) {
            ClassChildren cc = jc instanceof AnnotationType ? new AnnotationTypeChildren(f, (AnnotationType)jc) : (jc instanceof JavaEnum ? new EnumChildren(f, (JavaEnum)jc) : new ClassChildren(f, jc));
            return cc;
        }

        ElementCategoryNode(int index, SourceNodeFactory factory, ClassDefinition element, boolean writeable) {
            this(index, ElementCategoryNode.createChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            switch (index) {
                case 0: {
                    this.setName("Fields");
                    break;
                }
                case 1: {
                    this.setName("Constructors");
                    break;
                }
                case 2: {
                    this.setName("Methods");
                    break;
                }
                case 3: {
                    this.setName("Constants");
                    break;
                }
                case 4: {
                    this.setName("AnnTypeMethods");
                }
            }
        }

        private ElementCategoryNode(int index, ClassChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.setShortDescription(SHORTDESCRS[index]);
            ClassElementFilter filter = new ClassElementFilter();
            filter.setOrder(FILTERS[index]);
            children.setFilter(filter);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        public boolean canCopy() {
            return false;
        }

        public NewType[] getNewTypes() {
            if (!SourceEditSupport.isWriteable((Element)this.element) || !(this.element instanceof JavaClass)) {
                return new NewType[0];
            }
            JavaClass jc = (JavaClass)this.element;
            switch (this.newTypeIndex) {
                case 0: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(jc, 1)};
                }
                case 1: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(jc, 0), new SourceEditSupport.ElementNewType(jc, 2)};
                }
                case 2: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(jc, 3)};
                }
                case 3: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(jc, 7)};
                }
                case 4: {
                    return new NewType[]{new SourceEditSupport.ElementNewType(jc, 13)};
                }
            }
            return super.getNewTypes();
        }
    }

    static final class CategorizingChildren
    extends ClassChildren {
        boolean writeable;

        CategorizingChildren(SourceNodeFactory factory, ClassDefinition data, boolean wr) {
            super(factory, data);
            this.writeable = wr;
        }

        protected Node[] createNodesImpl(Object key) {
            if (key == CATEGORY_FIELDS) {
                return new Node[]{new ElementCategoryNode(0, this.getFactory(), this.element, this.writeable)};
            }
            if (key == CATEGORY_METHODS) {
                return new Node[]{new ElementCategoryNode(2, this.getFactory(), this.element, this.writeable)};
            }
            if (key == CATEGORY_CONSTRUCTORS) {
                return new Node[]{new ElementCategoryNode(1, this.getFactory(), this.element, this.writeable)};
            }
            if (key == CATEGORY_CONSTANTS) {
                return new Node[]{new ElementCategoryNode(3, this.getFactory(), this.element, this.writeable)};
            }
            if (key == CATEGORY_ANN_TYPE_METHODS) {
                return new Node[]{new ElementCategoryNode(4, this.getFactory(), this.element, this.writeable)};
            }
            return super.createNodesImpl(key);
        }

        protected List getKeysOfType(Collection elements, int type) {
            if (type != 4096) {
                return super.getKeysOfType(elements, type);
            }
            if (this.element instanceof JavaEnum) {
                return ENUM_CATEGORIES;
            }
            if (this.element instanceof AnnotationType) {
                return ANNTYPES_CATEGORIES;
            }
            if (this.element instanceof JavaClass && ((JavaClass)this.element).isInterface()) {
                return INTERFACE_CATEGORIES;
            }
            return CLASS_CATEGORIES;
        }

        static {
            ClassChildren.propToFilter.put("classOrInterface", new Integer(4096));
        }
    }
}

