/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.retriever.DocumentParserFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverTask;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverEngine
implements Runnable {
    private LinkedList<RetrieveEntry> currentRetrievalList = new LinkedList();
    private File currentSaveRootFile = null;
    private File fixedSaveRootFolder = null;
    boolean startNewThread = true;
    protected boolean showErrorPopup = true;
    Thread taskThread = null;
    boolean STOP_PULL = false;
    boolean firstTime = true;
    String firstAddressParentStr = null;
    int currentPushCount = 0;
    int previousPushCount = 0;
    String opTabTitle = NbBundle.getMessage(RetrieverEngine.class, (String)"TITLE_retriever_output_tab_title");
    InputOutput iop = null;
    OutputWriter ioOut;
    OutputWriter ioError;
    List<RetrieveEntry> retrievedList = new ArrayList<RetrieveEntry>();
    boolean fileOverwrite = false;
    Map<RetrieveEntry, Exception> audits;
    FileObject catalogFileObject = null;
    private boolean save2SingleFolder = false;

    public RetrieverEngine(File fixedSaveRootFolder) {
        this.fixedSaveRootFolder = fixedSaveRootFolder;
        this.currentSaveRootFile = fixedSaveRootFolder;
    }

    public RetrieverEngine(File fixedSaveRootFolder, boolean startNewThread) {
        this.fixedSaveRootFolder = fixedSaveRootFolder;
        this.currentSaveRootFile = fixedSaveRootFolder;
        this.startNewThread = startNewThread;
    }

    public void addResourceToRetrieve(RetrieveEntry rent) {
        this.currentRetrievalList.add(rent);
    }

    public void start() {
        if (this.startNewThread) {
            this.taskThread = new Thread(this);
            this.taskThread.start();
        } else {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RetrieverEngine.class, (String)"LBL_PROGRESSBAR_Retrieve_XML"), (Cancellable)new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                RetrieverEngine retrieverEngine = RetrieverEngine.this;
                synchronized (retrieverEngine) {
                    if (!RetrieverEngine.this.STOP_PULL) {
                        RetrieverEngine.this.STOP_PULL = true;
                    }
                }
                return true;
            }
        }, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RetrieverEngine.this.getOPWindow().setOutputVisible(true);
                RetrieverEngine.this.getOPWindow().select();
            }
        });
        ph.start();
        ph.switchToIndeterminate();
        try {
            this.pullRecursively();
        }
        finally {
            ph.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullRecursively() {
        Class<RetrieverEngine> clazz = RetrieverEngine.class;
        synchronized (RetrieverEngine.class) {
            while (!this.currentRetrievalList.isEmpty() && !this.STOP_PULL) {
                RetrieveEntry rent = this.currentRetrievalList.getFirst();
                this.currentRetrievalList.removeFirst();
                RetrieverTask rt = new RetrieverTask(rent, this);
                if (this.firstTime) {
                    this.firstAddressParentStr = rent.getCurrentAddress().substring(0, rent.getCurrentAddress().lastIndexOf("/"));
                    this.firstTime = false;
                }
                this.updateDownloadingInfo(rent);
                HashMap<String, File> storedFileMap = null;
                try {
                    storedFileMap = rt.goGetIt();
                }
                catch (URISyntaxException ex) {
                    this.handleException(rent, ex);
                    continue;
                }
                catch (IOException ex) {
                    this.handleException(rent, ex);
                    continue;
                }
                if (!rent.isRecursive() || storedFileMap == null) continue;
                String effectiveSrcAddr = storedFileMap.keySet().iterator().next();
                File storedFile = storedFileMap.get(effectiveSrcAddr);
                rent.setSaveFile(storedFile);
                rent.setEffectiveAddress(effectiveSrcAddr);
                this.updateDownloadedInfo(rent);
                this.createCatalogIfRequired(rent);
                DocumentTypeParser dtp = DocumentParserFactory.getParser(rent.getDocType());
                List<String> thisFileRefs = null;
                try {
                    thisFileRefs = dtp.getAllLocationOfReferencedEntities(storedFile);
                }
                catch (Exception ex) {
                    continue;
                }
                for (String ref : thisFileRefs) {
                    this.currentRetrievalList.addLast(new RetrieveEntry(effectiveSrcAddr, ref, storedFile, null, rent.getDocType(), rent.isRecursive()));
                }
                this.printList();
            }
            this.closeOPOuts();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void printList() {
        for (RetrieveEntry retrieveEntry : this.currentRetrievalList) {
        }
    }

    public File getCurrentSaveRootFile() {
        return this.currentSaveRootFile;
    }

    public void getCurrentSaveRootFile(File currentSaveRootFile) {
        this.currentSaveRootFile = currentSaveRootFile;
    }

    private String getCorrectFolderName(int folderIndex) {
        StringTokenizer stok = new StringTokenizer(this.firstAddressParentStr, "/");
        Stack<String> stack = new Stack<String>();
        while (stok.hasMoreTokens()) {
            stack.push(stok.nextToken());
        }
        for (int i = 1; i < folderIndex; ++i) {
            stack.pop();
        }
        return (String)stack.pop();
    }

    void pushDownRoot(int pushCount) {
        File newTmpRoot;
        File leafFolder = newTmpRoot = new File(this.currentSaveRootFile.getParent() + File.separator + System.currentTimeMillis());
        leafFolder.mkdirs();
        for (int i = pushCount; i >= 2; --i) {
            leafFolder = new File(leafFolder.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + i));
            leafFolder.mkdirs();
        }
        File movedRoot = leafFolder = new File(leafFolder.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + 1));
        while (!this.currentSaveRootFile.renameTo(movedRoot)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        while (!newTmpRoot.renameTo(this.currentSaveRootFile)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        File newRoot = this.currentSaveRootFile;
        for (int i = pushCount; i >= 1; --i) {
            newRoot = new File(newRoot.toString() + File.separator + this.getCorrectFolderName(this.currentPushCount + i));
        }
        this.correctAllEntriesInTheList(newRoot);
        this.previousPushCount = this.currentPushCount;
        this.currentPushCount += pushCount;
    }

    File getNewFileForOld(File oldFile, int pushCount) {
        File newRoot = this.currentSaveRootFile;
        for (int i = pushCount; i >= 1; --i) {
            newRoot = new File(newRoot.toString() + File.separator + this.getCorrectFolderName(this.previousPushCount + i));
        }
        String oldPath = oldFile.toString();
        String newPath = new String(new StringBuffer(oldPath).replace(0, this.currentSaveRootFile.toString().length(), newRoot.toString()));
        File newFile = new File(newPath);
        return newFile;
    }

    private void correctAllEntriesInTheList(File newRoot) {
        for (RetrieveEntry rent : this.currentRetrievalList) {
            String oldPath = rent.getLocalBaseFile().toString();
            String newPath = new String(new StringBuffer(oldPath).replace(0, this.currentSaveRootFile.toString().length(), newRoot.toString()));
            File newLocalBaseFile = new File(newPath);
            rent.setLocalBaseFile(newLocalBaseFile);
        }
    }

    public File getFixedSaveRootFolder() {
        return this.fixedSaveRootFolder;
    }

    private void handleException(RetrieveEntry rent, Exception ex) {
        if (this.audits == null) {
            this.audits = new HashMap<RetrieveEntry, Exception>();
        }
        this.audits.put(rent, ex);
        if (ex instanceof UnknownHostException) {
            String errorMess = NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_unknown_host_p1") + ex.getLocalizedMessage() + "\n" + NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_unknownhost_p2");
            this.outputError(errorMess);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message ndm = new NotifyDescriptor.Message((Object)errorMess, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndm);
            }
            return;
        }
        if (ex instanceof URISyntaxException) {
            String errorMess = ex.getLocalizedMessage();
            this.outputError(errorMess);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message ndm = new NotifyDescriptor.Message((Object)errorMess, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndm);
            }
            return;
        }
        if (ex instanceof FileNotFoundException) {
            String errorMess = NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_unknown_file", (Object)ex.getMessage());
            this.outputError(errorMess);
            if (this.showErrorPopup) {
                NotifyDescriptor.Message ndm = new NotifyDescriptor.Message((Object)errorMess, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndm);
            }
            return;
        }
        if (ex instanceof IOException) {
            String exStr = NbBundle.getMessage(RetrieverEngine.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
            if (ex.getMessage().startsWith(exStr)) {
                this.outputMessage(ex.getMessage() + ":\n\t " + NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_retrieving_location_found_in", (Object)rent.getCurrentAddress(), (Object)rent.getBaseAddress()));
                return;
            }
            String errorMess = NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_general_io_error", (Object)ex.getMessage());
            if (this.showErrorPopup) {
                NotifyDescriptor.Message ndm = new NotifyDescriptor.Message((Object)errorMess, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)ndm);
            }
            this.outputError(errorMess);
            return;
        }
        this.outputError(ex.getMessage());
    }

    private InputOutput getOPWindow() {
        if (this.iop == null) {
            this.iop = IOProvider.getDefault().getIO(this.opTabTitle, false);
            this.iop.setErrSeparated(true);
            this.iop.setFocusTaken(false);
            this.ioOut = this.iop.getOut();
            DateFormat dtf = DateFormat.getDateTimeInstance();
            this.ioOut.print("\n\n" + dtf.format(new Date(System.currentTimeMillis())) + " : ");
        }
        return this.iop;
    }

    private void closeOPOuts() {
        this.getErrOut().close();
        this.getOPOut().close();
    }

    private OutputWriter getOPOut() {
        if (this.ioOut == null) {
            this.ioOut = this.getOPWindow().getOut();
        }
        return this.ioOut;
    }

    private OutputWriter getErrOut() {
        if (this.ioError == null) {
            this.ioError = this.getOPWindow().getErr();
        }
        return this.ioError;
    }

    private void outputError(String str) {
        OutputWriter err = this.getErrOut();
        err.println(NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_Error_str", (Object)str));
        err.flush();
    }

    private void outputMessage(String str) {
        OutputWriter err = this.getOPOut();
        err.println(str);
        err.flush();
    }

    private void updateDownloadingInfo(RetrieveEntry rent) {
        OutputWriter opt = this.getOPOut();
        if (rent.getBaseAddress() != null) {
            opt.println(NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_retrieving_location_found_in", (Object)rent.getCurrentAddress(), (Object)rent.getBaseAddress()));
        } else {
            opt.println(NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_retrieving_location", (Object)rent.getCurrentAddress()));
        }
        opt.flush();
    }

    private void updateDownloadedInfo(RetrieveEntry rent) {
        this.retrievedList.add(rent);
        OutputWriter opt = this.getOPOut();
        String str = "   " + rent.getEffectiveAddress();
        opt.println(NbBundle.getMessage(RetrieverEngine.class, (String)"MSG_retrieved_saved_at", (Object)str, (Object)rent.getSaveFile()));
        opt.flush();
    }

    public File getSeedFileLocation() {
        if (this.retrievedList.size() > 0) {
            RetrieveEntry rent = this.retrievedList.get(0);
            return rent.getSaveFile();
        }
        return null;
    }

    private void createCatalogIfRequired(RetrieveEntry rent) {
        URI curURI = null;
        String addr = rent.getEffectiveAddress();
        if (this.isSave2SingleFolder() && !rent.getCurrentAddress().equals(rent.getEffectiveAddress())) {
            addr = rent.getCurrentAddress();
        }
        try {
            curURI = new URI(addr);
        }
        catch (URISyntaxException ex) {
            return;
        }
        FileObject fobj = null;
        try {
            fobj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)rent.getSaveFile()));
        }
        catch (Exception e) {
            return;
        }
        if (fobj == null) {
            return;
        }
        CatalogWriteModel dr = null;
        try {
            dr = this.catalogFileObject == null ? CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fobj) : CatalogWriteModelFactory.getInstance().getCatalogWriteModelForCatalogFile(this.catalogFileObject);
        }
        catch (CatalogModelException ex) {
            return;
        }
        try {
            dr.addURI(curURI, fobj);
        }
        catch (Exception ex) {
            ex = new Exception("Exception while writing in to catalog.", ex);
            this.handleException(rent, ex);
            return;
        }
    }

    public void setFileOverwrite(boolean fileOverwrite) {
        this.fileOverwrite = fileOverwrite;
    }

    public boolean getFileOverwrite() {
        return this.fileOverwrite;
    }

    public Map<RetrieveEntry, Exception> getRetrievedResourceExceptionMap() {
        return this.audits;
    }

    public void setCatalogFile(FileObject catalogFileObject) {
        this.catalogFileObject = catalogFileObject;
    }

    public void setSave2SingleFolder(boolean save2SingleFolder) {
        this.save2SingleFolder = save2SingleFolder;
    }

    public boolean isSave2SingleFolder() {
        return this.save2SingleFolder;
    }
}

