/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapperDOMImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelFactoryImpl;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogModelImpl
implements CatalogModel {
    protected FileObject catalogFileObject = null;
    private static Logger logger = Utilities.getLogger();
    CatalogResolver catalogResolver;
    Catalog apacheCatalogResolverObj;
    long lastModTime = 0L;

    public CatalogModelImpl(Project myProject) throws IOException {
        assert (myProject != null);
        this.catalogFileObject = Utilities.getProjectCatalogFileObject(myProject);
    }

    public CatalogModelImpl(FileObject catalogFileObject) throws IOException {
        assert (catalogFileObject != null);
        this.catalogFileObject = catalogFileObject;
    }

    public CatalogModelImpl() {
    }

    public CatalogModelImpl(File tempFolder) throws IOException {
        tempFolder = FileUtil.normalizeFile((File)tempFolder);
        FileObject fo = FileUtil.toFileObject((File)tempFolder);
        String fileName = "catalog.xml";
        this.catalogFileObject = FileUtil.createData((FileObject)fo, (String)fileName);
    }

    public ModelSource getModelSource(URI locationURI, ModelSource modelSourceOfSourceDocument) throws CatalogModelException {
        logger.entering("CatalogModelImpl", "getModelSource", locationURI);
        this.useSuitableCatalogFile(modelSourceOfSourceDocument);
        if (this.isOrphan()) {
            return this.tryOrphanResolution(locationURI, modelSourceOfSourceDocument);
        }
        File absResourceFile = null;
        try {
            FileObject fob = null;
            if (modelSourceOfSourceDocument != null) {
                fob = (FileObject)modelSourceOfSourceDocument.getLookup().lookup(FileObject.class);
            }
            absResourceFile = this.resolveUsingCatalog(locationURI, fob);
        }
        catch (IOException ex) {
            throw new CatalogModelException((Throwable)ex);
        }
        logger.finer("Found  abs file res:" + absResourceFile);
        File normalizedFile = FileUtil.normalizeFile((File)absResourceFile);
        FileObject thisFileObj = FileUtil.toFileObject((File)normalizedFile);
        boolean editable = this.isEditable(absResourceFile);
        ModelSource result = this.createModelSource(thisFileObj, editable);
        logger.exiting("CatalogModelImpl", "getModelSource", result);
        return result;
    }

    private void useSuitableCatalogFile(ModelSource modelSourceOfSourceDocument) {
        if (modelSourceOfSourceDocument != null) {
            FileObject catFO;
            FileObject msfo = (FileObject)modelSourceOfSourceDocument.getLookup().lookup(FileObject.class);
            if (msfo == null) {
                return;
            }
            Project prj = FileOwnerQuery.getOwner((FileObject)msfo);
            if (prj == null) {
                return;
            }
            XMLCatalogProvider catPovider = (XMLCatalogProvider)prj.getLookup().lookup(XMLCatalogProvider.class);
            if (catPovider == null) {
                return;
            }
            URI caturi = catPovider.getCatalog(msfo);
            if (caturi == null) {
                return;
            }
            URI prjuri = FileUtil.toFile((FileObject)prj.getProjectDirectory()).toURI();
            URI catFileURI = prjuri.resolve(caturi);
            if (catFileURI == null) {
                return;
            }
            File catFile = new File(catFileURI);
            if (!catFile.isFile()) {
                try {
                    catFile.createNewFile();
                }
                catch (IOException ex) {
                    return;
                }
            }
            if ((catFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)catFile))) == null) {
                return;
            }
            this.catalogFileObject = catFO;
        }
    }

    public ModelSource getModelSource(URI locationURI) throws CatalogModelException {
        if (this.isOrphan()) {
            return this.tryOrphanResolution(locationURI, null);
        }
        return this.getModelSource(locationURI, null);
    }

    private Document getDocument(FileObject modelSourceFileObject) throws CatalogModelException {
        StyledDocument result = null;
        try {
            DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
            EditorCookie ec = (EditorCookie)dObject.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            assert (doc instanceof BaseDocument);
            result = doc;
        }
        catch (Exception dObjEx) {
            throw new CatalogModelException((Throwable)dObjEx);
        }
        return result;
    }

    protected ModelSource createModelSource(FileObject thisFileObj, boolean editable) throws CatalogModelException {
        ModelSource ms = Utilities.getModelSource(thisFileObj, editable);
        return ms;
    }

    protected CatalogModel createCatalogModel(FileObject fo) throws CatalogModelException {
        return new CatalogModelFactoryImpl().getCatalogModel(fo);
    }

    private ModelSource tryOrphanResolution(URI locationURI, ModelSource modelSource) {
        logger.entering("CatalogModelImpl", "getModelSource", locationURI);
        if (this.catalogFileObject == null) {
            try {
                FileObject fo;
                File file;
                if (locationURI.isAbsolute()) {
                    File file2 = new File(locationURI);
                    if (file2.isFile()) {
                        file2 = FileUtil.normalizeFile((File)file2);
                        FileObject fo2 = FileUtil.toFileObject((File)file2);
                        return this.createModelSource(fo2, this.isEditable(file2));
                    }
                } else if (modelSource != null && (file = this.resolveRelativeURI(locationURI, fo = (FileObject)modelSource.getLookup().lookup(FileObject.class))) != null) {
                    file = FileUtil.normalizeFile((File)file);
                    FileObject fobj = FileUtil.toFileObject((File)file);
                    return this.createModelSource(fobj, this.isEditable(file));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private boolean isOrphan() {
        return this.catalogFileObject == null;
    }

    protected File resolveUsingCatalog(URI locationURI, FileObject sourceFileObject) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "resolveUsingCatalog", locationURI);
        if (locationURI == null) {
            return null;
        }
        File result = null;
        result = this.resolveUsingPublicCatalog(locationURI);
        if (result != null) {
            return result;
        }
        if (sourceFileObject != null) {
            result = this.resolveRelativeURI(locationURI, sourceFileObject);
        }
        if (result != null) {
            return result;
        }
        if (locationURI.isAbsolute() && locationURI.getScheme().equalsIgnoreCase("file")) {
            result = new File(locationURI);
            if (result.isFile()) {
                logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                return result;
            }
            throw new FileNotFoundException(locationURI.toString() + ": is absolute but " + result.getAbsolutePath() + " Not Found.");
        }
        if (locationURI.isAbsolute() && locationURI.getScheme().toLowerCase().startsWith("http") && !CatalogFileWrapperDOMImpl.TEST_ENVIRONMENT) {
            boolean res = false;
            try {
                res = Utilities.retrieveAndCache(locationURI, sourceFileObject);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (res && (result = this.resolveUsingPublicCatalog(locationURI)) != null) {
                return result;
            }
        }
        throw new CatalogModelException(locationURI.toString() + " : Entry is not a relative or absolute and catalog entry not found");
    }

    protected File resolveUsingPublicCatalog(URI locationURI) throws IOException, CatalogModelException {
        File publicCatalogFile;
        File result = null;
        if (this.catalogFileObject != null && (publicCatalogFile = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            if (publicCatalogFile.length() < 20L) {
                return null;
            }
            URI strRes = this.resolveUsingApacheCatalog(publicCatalogFile, locationURI.toString());
            if (strRes != null && strRes.isAbsolute()) {
                if (strRes.getScheme().equalsIgnoreCase("file")) {
                    result = new File(strRes);
                    if (result.isFile()) {
                        logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                        return result;
                    }
                    throw new FileNotFoundException(result.getAbsolutePath() + " Not Found.");
                }
                throw new CatalogModelException("Catalog contains non-file URI. Catalog Maps URI to a local file only.");
            }
        }
        return null;
    }

    protected File resolveRelativeURI(URI locationURI, FileObject sourceFileObject) throws CatalogModelException, FileNotFoundException {
        File result = null;
        if (!locationURI.isAbsolute()) {
            if (sourceFileObject == null) {
                throw new CatalogModelException(locationURI.toString() + " : Entry is relative but base file now known. Pass base file to the factory");
            }
            URI sourceFileObjectURI = FileUtil.toFile((FileObject)sourceFileObject).toURI();
            URI resultURI = sourceFileObjectURI.resolve(locationURI);
            try {
                result = new File(resultURI);
            }
            catch (Exception e) {
                throw new CatalogModelException(locationURI.toString() + " : Entry is relative but resolved entry is not absolute");
            }
            if (result.isFile()) {
                logger.exiting("CatalogModelImpl", "resolveUsingCatalog", result);
                return result;
            }
            throw new FileNotFoundException(result.getAbsolutePath() + " Not Found.");
        }
        return null;
    }

    protected URI resolveUsingApacheCatalog(File catalogFile, String locationURI) throws IOException, CatalogModelException {
        ArrayList<File> catalogFileList = new ArrayList<File>();
        catalogFileList.add(catalogFile);
        return this.resolveUsingApacheCatalog(catalogFileList, locationURI);
    }

    protected URI resolveUsingApacheCatalog(List<File> catalogFileList, String locationURI) throws CatalogModelException, IOException {
        if (logger.getLevel() != null && logger.getLevel().intValue() <= Level.FINER.intValue()) {
            Debug debug = CatalogManager.getStaticManager().debug;
            debug.setDebug(logger.getLevel().intValue());
        }
        if (this.reparseRequired(catalogFileList)) {
            CatalogManager manager = new CatalogManager(null);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(false);
            this.catalogResolver = new CatalogResolver(manager);
            this.apacheCatalogResolverObj = this.catalogResolver.getCatalog();
            for (File catFile : catalogFileList) {
                try {
                    this.apacheCatalogResolverObj.parseCatalog(catFile.getAbsolutePath());
                }
                catch (MalformedURLException ex) {
                    throw new CatalogModelException((Throwable)ex);
                }
            }
        }
        String result = null;
        try {
            result = this.apacheCatalogResolverObj.resolveSystem(locationURI);
        }
        catch (MalformedURLException ex) {
            result = "";
        }
        catch (IOException ex) {
            result = "";
        }
        if (result == null) {
            result = "";
        } else {
            try {
                result = Utilities.normalizeURI(result);
                URI uri = new URI(result);
                if (uri.isOpaque() && uri.getScheme().equalsIgnoreCase("file")) {
                    StringBuffer resBuff = new StringBuffer(result);
                    result = resBuff.insert("file:".length(), "/").toString();
                }
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        if (result.length() > 0) {
            try {
                URI res = new URI(result);
                return res;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean reparseRequired(List<File> catalogFileList) {
        return true;
    }

    boolean isEditable(File absResourceFile) {
        return true;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        try {
            return this.getInputSource(new URI(systemId));
        }
        catch (CatalogModelException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (URISyntaxException e) {
            throw new IOException("SystemID not a URL");
        }
    }

    private InputSource getInputSource(URI locationURI) throws CatalogModelException, IOException {
        logger.entering("CatalogModelImpl", "getInputSource", locationURI);
        File absResourceFile = this.resolveUsingCatalog(locationURI, null);
        logger.finer("Found  abs file res:" + absResourceFile);
        InputSource result = new InputSource(new FileInputStream(absResourceFile));
        result.setSystemId(locationURI.toString());
        logger.exiting("CatalogModelImpl", "getInputSource", result);
        return result;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURIStr) {
        if (systemId == null || systemId.trim().length() <= 0) {
            return null;
        }
        URI systemIdURI = null;
        try {
            systemIdURI = new URI(systemId);
        }
        catch (URISyntaxException ex) {
            return null;
        }
        FileObject baseFO = null;
        CatalogModelImpl depRez = null;
        try {
            baseFO = this.getFileObject(baseURIStr);
            depRez = this.getResolver(baseFO);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        if (depRez == null) {
            return null;
        }
        ModelSource baseMS = null;
        try {
            baseMS = this.createModelSource(baseFO, false);
        }
        catch (CatalogModelException ex) {
            // empty catch block
        }
        ModelSource resultMS = null;
        try {
            resultMS = depRez.getModelSource(systemIdURI, baseMS);
        }
        catch (CatalogModelException ex) {
            return null;
        }
        if (resultMS == null) {
            return null;
        }
        FileObject resultFob = (FileObject)resultMS.getLookup().lookup(FileObject.class);
        if (resultFob == null) {
            return null;
        }
        File resultFile = FileUtil.toFile((FileObject)resultFob);
        if (resultFile == null) {
            return null;
        }
        URI resultURI = resultFile.toURI();
        DOMImplementation domImpl = null;
        try {
            domImpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
        DOMImplementationLS dols = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        LSInput lsi = dols.createLSInput();
        Reader is = this.getFileStreamFromDocument(resultFile);
        if (is != null) {
            lsi.setCharacterStream(is);
        }
        lsi.setSystemId(resultURI.toString());
        return lsi;
    }

    private FileObject getFileObject(String baseURIStr) throws IOException {
        if (baseURIStr == null) {
            return null;
        }
        URI baseURI = null;
        try {
            baseURI = new URI(baseURIStr);
        }
        catch (URISyntaxException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
        if (baseURI.isAbsolute() && baseURI.getScheme().equalsIgnoreCase("file")) {
            File baseFile = null;
            try {
                baseFile = new File(baseURI);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            baseFile = FileUtil.normalizeFile((File)baseFile);
            FileObject baseFileObject = null;
            try {
                baseFileObject = FileUtil.toFileObject((File)baseFile);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            return baseFileObject;
        }
        return null;
    }

    private CatalogModelImpl getResolver(FileObject baseFileObject) throws CatalogModelException {
        return this;
    }

    private Reader getFileStreamFromDocument(File resultFile) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)resultFile));
        if (fo != null) {
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                return null;
            }
            if (dobj.isValid() && dobj.isModified()) {
                return DataObjectAdapters.inputSource((DataObject)dobj).getCharacterStream();
            }
            return null;
        }
        return null;
    }
}

