/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ListViewDropSupport
implements DropTargetListener,
Runnable {
    boolean active = false;
    boolean dropTargetPopupAllowed;
    DropTarget dropTarget;
    int lastIndex = -1;
    protected ListView view;
    protected JList list;

    public ListViewDropSupport(ListView view, JList list) {
        this(view, list, true);
    }

    public ListViewDropSupport(ListView view, JList list, boolean dropTargetPopupAllowed) {
        this.view = view;
        this.list = list;
        this.dropTargetPopupAllowed = dropTargetPopupAllowed;
    }

    public void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
    }

    public boolean isDropTargetPopupAllowed() {
        return this.dropTargetPopupAllowed;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        int dropAction = ExplorerDnDManager.getDefault().getAdjustedDropAction(dtde.getDropAction(), this.view.getAllowedDropActions());
        ExplorerDnDManager.getDefault().prepareCursor(DragDropUtilities.chooseCursor(dtde.getDropTargetContext().getComponent(), dropAction, (dropAction & this.view.getAllowedDropActions()) != 0));
        this.lastIndex = this.indexWithCheck(dtde);
        if (this.lastIndex < 0) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dropAction);
            NodeRenderer.dragEnter(this.list.getModel().getElementAt(this.lastIndex));
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        int dropAction = ExplorerDnDManager.getDefault().getAdjustedDropAction(dtde.getDropAction(), this.view.getAllowedDropActions());
        ExplorerDnDManager.getDefault().prepareCursor(DragDropUtilities.chooseCursor(dtde.getDropTargetContext().getComponent(), dropAction, (dropAction & this.view.getAllowedDropActions()) != 0));
        int index = this.indexWithCheck(dtde);
        if (index < 0) {
            dtde.rejectDrag();
            if (this.lastIndex >= 0) {
                NodeRenderer.dragExit();
                this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
                this.lastIndex = -1;
            }
        } else {
            dtde.acceptDrag(dropAction);
            if (this.lastIndex != index) {
                if (this.lastIndex < 0) {
                    this.lastIndex = index;
                }
                NodeRenderer.dragExit();
                NodeRenderer.dragEnter(this.list.getModel().getElementAt(index));
                this.list.repaint(this.list.getCellBounds(this.lastIndex, index));
                this.lastIndex = index;
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.lastIndex >= 0) {
            NodeRenderer.dragExit();
            this.list.repaint(this.list.getCellBounds(this.lastIndex, this.lastIndex));
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        int index = this.list.locationToIndex(dtde.getLocation());
        Object obj = this.list.getModel().getElementAt(index);
        Node dropNode = null;
        if (obj instanceof VisualizerNode) {
            dropNode = ((VisualizerNode)obj).node;
        }
        int dropAction = ExplorerDnDManager.getDefault().getAdjustedDropAction(dtde.getDropAction(), this.view.getAllowedDropActions());
        if (index < 0 || !this.canDrop(dropNode, dropAction, index)) {
            dtde.rejectDrop();
            return;
        }
        PasteType pt = DragDropUtilities.getDropType(dropNode, ExplorerDnDManager.getDefault().getDraggedTransferable((2 & dropAction) != 0), dropAction, index);
        if (pt == null) {
            dtde.dropComplete(false);
            RequestProcessor.getDefault().post((Runnable)this, 500);
            return;
        }
        dtde.acceptDrop(dropAction);
        if (dropAction != 0x40000000) {
            DragDropUtilities.performPaste(pt, null);
        }
    }

    private boolean canDrop(Node n, int dropAction, int dropIndex) {
        Transferable trans;
        if (n == null) {
            return false;
        }
        if (ExplorerDnDManager.getDefault().getNodeAllowedActions() == 0) {
            return false;
        }
        if ((2 & dropAction) != 0) {
            Node[] nodes = ExplorerDnDManager.getDefault().getDraggedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                if (!n.equals((Object)nodes[i].getParentNode())) continue;
                return false;
            }
        }
        if ((trans = ExplorerDnDManager.getDefault().getDraggedTransferable((2 & dropAction) != 0)) == null) {
            return false;
        }
        PasteType pt = DragDropUtilities.getDropType(n, trans, dropAction, dropIndex);
        return pt != null;
    }

    public void activate(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.getDropTarget().setActive(active);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        DragDropUtilities.dropNotSuccesfull();
    }

    int indexWithCheck(DropTargetDragEvent dtde) {
        int dropAction = ExplorerDnDManager.getDefault().getAdjustedDropAction(dtde.getDropAction(), this.view.getAllowedDropActions());
        if ((dropAction & this.view.getAllowedDropActions()) == 0) {
            return -1;
        }
        int index = this.list.locationToIndex(dtde.getLocation());
        if (index == -1) {
            return -1;
        }
        Object obj = this.list.getModel().getElementAt(index);
        if (obj instanceof VisualizerNode) {
            obj = ((VisualizerNode)obj).node;
        }
        if (index < 0) {
            return -1;
        }
        if (!(obj instanceof Node)) {
            return -1;
        }
        return index;
    }

    DropTarget getDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this.list, this.view.getAllowedDropActions(), this, false);
        }
        return this.dropTarget;
    }
}

