/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.ClassNameTextField;
import org.netbeans.modules.junit.GuiUtils;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.MessageStack;
import org.netbeans.modules.junit.SelfResizingPanel;
import org.netbeans.modules.junit.TestUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class JUnitCfgOfCreate
extends SelfResizingPanel
implements ChangeListener {
    private static final String TEST_CLASS_SUFFIX = "Test";
    private final Node[] nodes;
    private final boolean multipleClasses;
    private boolean singlePackage;
    private boolean singleClass;
    private String testClassName;
    private List changeListeners;
    private String initialMessage;
    private boolean hasTargetFolders = false;
    private boolean checkBoxesOK;
    private String msgChkBoxesInvalid;
    private boolean classNameValid;
    private boolean isAcceptable;
    private static final int MSG_TYPE_NO_TARGET_FOLDERS = 0;
    private static final int MSG_TYPE_INVALID_CHKBOXES = 1;
    private static final int MSG_TYPE_CLASSNAME_INVALID = 2;
    private static final int MSG_TYPE_CLASSNAME_NOT_DEFAULT = 3;
    private MessageStack msgStack = new MessageStack(4);
    public ResourceBundle bundle;
    private JLabel lblClassToTestValue;
    private ClassNameTextField tfClassName;
    private JTextArea txtAreaMessage;
    private JComboBox cboxLocation;
    private JCheckBox chkAbstractImpl;
    private JCheckBox chkComments;
    private JCheckBox chkContent;
    private JCheckBox chkExceptions;
    private JCheckBox chkGenerateSuites;
    private JCheckBox chkJavaDoc;
    private JCheckBox chkPackage;
    private JCheckBox chkPackagePrivateClasses;
    private JCheckBox chkProtected;
    private JCheckBox chkPublic;
    private JCheckBox chkSetUp;
    private JCheckBox chkTearDown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JUnitCfgOfCreate(Node[] nodes) {
        assert (nodes != null && nodes.length != 0);
        this.nodes = nodes;
        this.multipleClasses = this.checkMultipleClasses();
        this.initBundle();
        try {
            this.initComponents();
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
            this.addAccessibleDescriptions();
            this.initializeCheckBoxStates();
            this.fillFormData();
            this.checkAcceptability();
            this.setupUserInteraction();
        }
        finally {
            this.unlinkBundle();
        }
    }

    private void addAccessibleDescriptions() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.AD"));
        if (this.tfClassName != null) {
            this.tfClassName.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.clsName.toolTip"));
            this.tfClassName.getAccessibleContext().setAccessibleName(this.bundle.getString("JUnitCfgOfCreate.clsName.AN"));
            this.tfClassName.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.clsName.AD"));
        }
        this.cboxLocation.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.location.toolTip"));
        this.cboxLocation.getAccessibleContext().setAccessibleName(this.bundle.getString("JUnitCfgOfCreate.location.AN"));
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.location.AD"));
        this.chkPublic.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPublic.toolTip"));
        this.chkPublic.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPublic.AD"));
        this.chkProtected.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkProtected.toolTip"));
        this.chkProtected.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkProtected.AD"));
        this.chkPackage.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPackage.toolTip"));
        this.chkPackage.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPackage.AD"));
        this.chkComments.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkComments.toolTip"));
        this.chkComments.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkComments.AD"));
        this.chkContent.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkContent.toolTip"));
        this.chkContent.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkContent.AD"));
        this.chkJavaDoc.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkJavaDoc.toolTip"));
        this.chkJavaDoc.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkJavaDoc.AD"));
        if (this.multipleClasses) {
            this.chkExceptions.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkExceptions.toolTip"));
            this.chkExceptions.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkExceptions.AD"));
            this.chkAbstractImpl.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkAbstractImpl.toolTip"));
            this.chkAbstractImpl.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkAbstractImpl.AD"));
            this.chkPackagePrivateClasses.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPackagePrivateClasses.toolTip"));
            this.chkPackagePrivateClasses.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPackagePrivateClasses.AD"));
            this.chkGenerateSuites.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkGenerateSuites.toolTip"));
            this.chkGenerateSuites.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkGenerateSuites.AD"));
        }
    }

    private boolean checkMultipleClasses() {
        if (this.nodes.length > 1) {
            return true;
        }
        Lookup nodeLookup = this.nodes[0].getLookup();
        if (nodeLookup.lookup(DataObject.Container.class) != null) {
            this.singlePackage = nodeLookup.lookup(DataFolder.class) != null;
            return true;
        }
        this.singleClass = nodeLookup.lookup(SourceCookie.class) != null;
        return !this.singleClass;
    }

    boolean configure() {
        String title = NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"JUnitCfgOfCreate.Title");
        final JButton btnOK = new JButton(NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"LBL_OK"));
        btnOK.setEnabled(this.isAcceptable());
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                btnOK.setEnabled(JUnitCfgOfCreate.this.isAcceptable());
            }
        };
        this.addChangeListener(changeListener);
        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)this, title, true, new Object[]{btnOK, DialogDescriptor.CANCEL_OPTION}, (Object)btnOK, 0, new HelpCtx(JUnitCfgOfCreate.class), (ActionListener)null));
        this.removeChangeListener(changeListener);
        if (returned == btnOK) {
            this.rememberCheckBoxStates();
            this.testClassName = this.tfClassName != null ? this.tfClassName.getText() : null;
            return true;
        }
        return false;
    }

    boolean isSingleClass() {
        return this.singleClass;
    }

    String getTestClassName() {
        return this.testClassName;
    }

    private void initializeCheckBoxStates() {
        JUnitSettings settings = JUnitSettings.getDefault();
        this.chkPublic.setSelected(settings.isMembersPublic());
        this.chkProtected.setSelected(settings.isMembersProtected());
        this.chkPackage.setSelected(settings.isMembersPackage());
        this.chkComments.setSelected(settings.isBodyComments());
        this.chkContent.setSelected(settings.isBodyContent());
        this.chkJavaDoc.setSelected(settings.isJavaDoc());
        if (this.multipleClasses) {
            this.chkGenerateSuites.setSelected(settings.isGenerateSuiteClasses());
            this.chkPackagePrivateClasses.setSelected(settings.isIncludePackagePrivateClasses());
            this.chkAbstractImpl.setSelected(settings.isGenerateAbstractImpl());
            this.chkExceptions.setSelected(settings.isGenerateExceptionClasses());
        }
        this.chkSetUp.setSelected(settings.isGenerateSetUp());
        this.chkTearDown.setSelected(settings.isGenerateTearDown());
        this.checkChkBoxesStates();
    }

    private void rememberCheckBoxStates() {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setMembersPublic(this.chkPublic.isSelected());
        settings.setMembersProtected(this.chkProtected.isSelected());
        settings.setMembersPackage(this.chkPackage.isSelected());
        settings.setBodyComments(this.chkComments.isSelected());
        settings.setBodyContent(this.chkContent.isSelected());
        settings.setJavaDoc(this.chkJavaDoc.isSelected());
        if (this.multipleClasses) {
            settings.setGenerateSuiteClasses(this.chkGenerateSuites.isSelected());
            settings.setIncludePackagePrivateClasses(this.chkPackagePrivateClasses.isSelected());
            settings.setGenerateAbstractImpl(this.chkAbstractImpl.isSelected());
            settings.setGenerateExceptionClasses(this.chkExceptions.isSelected());
        }
        settings.setGenerateSetUp(this.chkSetUp.isSelected());
        settings.setGenerateTearDown(this.chkTearDown.isSelected());
    }

    private void initBundle() {
        this.bundle = NbBundle.getBundle(JUnitCfgOfCreate.class);
    }

    private void unlinkBundle() {
        this.bundle = null;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 12));
        this.add(this.createNameAndLocationPanel(), "North");
        this.add(this.createMessagePanel(), "Center");
        this.add(this.createCodeGenPanel(), "South");
    }

    private void setupUserInteraction() {
        CheckBoxListener listener = new CheckBoxListener();
        this.chkPublic.addItemListener(listener);
        this.chkProtected.addItemListener(listener);
        this.chkPackage.addItemListener(listener);
    }

    private void checkChkBoxesStates() {
        boolean bl = this.checkBoxesOK = this.chkPublic.isSelected() || this.chkProtected.isSelected() || this.chkPackage.isSelected();
        if (this.checkBoxesOK) {
            this.setMessage(null, 1);
        } else {
            if (this.msgChkBoxesInvalid == null) {
                this.msgChkBoxesInvalid = NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"MSG_AllMethodTypesDisabled");
            }
            this.setMessage(this.msgChkBoxesInvalid, 1);
        }
    }

    private Component createNameAndLocationPanel() {
        Font labelFont;
        JPanel panel = new JPanel();
        boolean askForClassName = this.singleClass;
        JLabel lblClassToTest = new JLabel();
        JLabel lblClassName = askForClassName ? new JLabel() : null;
        JLabel lblLocation = new JLabel();
        String classToTestKey = this.singlePackage ? "LBL_PackageToTest" : (this.singleClass ? "LBL_ClassToTest" : "LBL_MultipleClassesSelected");
        Mnemonics.setLocalizedText((JLabel)lblClassToTest, (String)NbBundle.getMessage(this.getClass(), (String)classToTestKey));
        if (askForClassName) {
            Mnemonics.setLocalizedText((JLabel)lblClassName, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_ClassName"));
        }
        Mnemonics.setLocalizedText((JLabel)lblLocation, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_Location"));
        if (this.singlePackage || this.singleClass) {
            this.lblClassToTestValue = new JLabel();
        }
        if (askForClassName) {
            this.tfClassName = new ClassNameTextField();
            this.tfClassName.setChangeListener(this);
        }
        this.cboxLocation = new JComboBox();
        if (askForClassName) {
            lblClassName.setLabelFor(this.tfClassName);
        }
        lblLocation.setLabelFor(this.cboxLocation);
        if (this.lblClassToTestValue != null && (labelFont = UIManager.getDefaults().getFont("TextField.font")) != null) {
            this.lblClassToTestValue.setFont(labelFont);
        }
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcLeft = new GridBagConstraints();
        gbcLeft.anchor = 17;
        gbcLeft.insets.bottom = 12;
        gbcLeft.insets.right = 6;
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcRight.anchor = 17;
        gbcRight.insets.bottom = 12;
        gbcRight.weightx = 1.0;
        gbcRight.fill = 1;
        gbcRight.gridwidth = 0;
        if (this.lblClassToTestValue != null) {
            panel.add((Component)lblClassToTest, gbcLeft);
            panel.add((Component)this.lblClassToTestValue, gbcRight);
        } else {
            panel.add((Component)lblClassToTest, gbcRight);
        }
        if (askForClassName) {
            panel.add((Component)lblClassName, gbcLeft);
            panel.add((Component)this.tfClassName, gbcRight);
        }
        gbcLeft.insets.bottom = 0;
        gbcRight.insets.bottom = 0;
        panel.add((Component)lblLocation, gbcLeft);
        panel.add((Component)this.cboxLocation, gbcRight);
        return panel;
    }

    private void checkClassNameValidity() {
        if (this.tfClassName == null) {
            this.classNameValid = true;
            return;
        }
        String key = null;
        int state = this.tfClassName.getStatus();
        switch (state) {
            case 1: {
                key = "MSG_ClassnameMustNotBeEmpty";
                break;
            }
            case 2: {
                key = "MSG_InvalidClassName";
                break;
            }
            case 3: {
                key = "MSG_ClassNameNotDefault";
            }
        }
        if (state != 3) {
            this.setMessage(null, 3);
        }
        this.setMessage(key != null ? NbBundle.getMessage(this.getClass(), (String)key) : null, 2);
        this.classNameValid = state == 0 || state == 3;
    }

    public void stateChanged(ChangeEvent e) {
        this.checkClassNameValidity();
        this.checkAcceptability();
    }

    private void checkAcceptability() {
        boolean wasAcceptable = this.isAcceptable;
        boolean bl = this.isAcceptable = this.hasTargetFolders && this.classNameValid && this.checkBoxesOK;
        if (this.isAcceptable != wasAcceptable) {
            this.fireStateChange();
        }
    }

    private boolean isAcceptable() {
        return this.isAcceptable;
    }

    protected void paintedFirstTime(Graphics g) {
        if (this.initialMessage != null) {
            this.displayMessage(this.initialMessage);
            this.initialMessage = null;
        }
    }

    private void setMessage(String message, int msgType) {
        String msgToDisplay = this.msgStack.setMessage(msgType, message);
        if (msgToDisplay == null) {
            return;
        }
        if (!this.isPainted()) {
            this.initialMessage = msgToDisplay;
        } else {
            this.displayMessage(msgToDisplay);
        }
    }

    private void displayMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.txtAreaMessage.setText(message);
        this.adjustWindowSize();
    }

    private Component createMessagePanel() {
        this.txtAreaMessage = (JTextArea)GuiUtils.createMultilineLabel("");
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(89, 79, 191);
        }
        this.txtAreaMessage.setForeground(color);
        return this.txtAreaMessage;
    }

    private Component createCodeGenPanel() {
        String[] chkBoxIDs = this.multipleClasses ? new String[]{"Public", "Protected", "Package", "PackagePrivateClasses", "AbstractImpl", "Exceptions", "GenerateSuites", "SetUp", "TearDown", "Content", "JavaDoc", "Comments"} : new String[]{"Public", "Protected", "Package", null, null, null, null, "SetUp", "TearDown", "Content", "JavaDoc", "Comments"};
        JCheckBox[] chkBoxes = GuiUtils.createCheckBoxes(chkBoxIDs);
        int i = 0;
        this.chkPublic = chkBoxes[i++];
        this.chkProtected = chkBoxes[i++];
        this.chkPackage = chkBoxes[i++];
        this.chkPackagePrivateClasses = chkBoxes[i++];
        this.chkAbstractImpl = chkBoxes[i++];
        this.chkExceptions = chkBoxes[i++];
        this.chkGenerateSuites = chkBoxes[i++];
        this.chkSetUp = chkBoxes[i++];
        this.chkTearDown = chkBoxes[i++];
        this.chkContent = chkBoxes[i++];
        this.chkJavaDoc = chkBoxes[i++];
        this.chkComments = chkBoxes[i++];
        JComponent methodAccessLevels = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupAccessLevels"), new JCheckBox[]{this.chkPublic, this.chkProtected, this.chkPackage});
        JComponent classTypes = null;
        JComponent optionalClasses = null;
        if (this.multipleClasses) {
            classTypes = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupClassTypes"), new JCheckBox[]{this.chkPackagePrivateClasses, this.chkAbstractImpl, this.chkExceptions});
            optionalClasses = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptClasses"), new JCheckBox[]{this.chkGenerateSuites});
        }
        JComponent optionalCode = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptCode"), new JCheckBox[]{this.chkSetUp, this.chkTearDown, this.chkContent});
        JComponent optionalComments = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptComments"), new JCheckBox[]{this.chkJavaDoc, this.chkComments});
        Box leftColumn = Box.createVerticalBox();
        leftColumn.add(methodAccessLevels);
        if (this.multipleClasses) {
            leftColumn.add(Box.createVerticalStrut(11));
            leftColumn.add(classTypes);
        } else {
            leftColumn.add(Box.createVerticalStrut(0));
        }
        leftColumn.add(Box.createVerticalGlue());
        Box rightColumn = Box.createVerticalBox();
        if (this.multipleClasses) {
            rightColumn.add(optionalClasses);
            rightColumn.add(Box.createVerticalStrut(11));
        }
        rightColumn.add(optionalCode);
        rightColumn.add(Box.createVerticalStrut(11));
        rightColumn.add(optionalComments);
        rightColumn.add(Box.createVerticalGlue());
        JPanel jpCodeGen = new JPanel();
        jpCodeGen.setLayout(new BoxLayout(jpCodeGen, 0));
        jpCodeGen.add(leftColumn);
        jpCodeGen.add(Box.createHorizontalStrut(24));
        jpCodeGen.add(rightColumn);
        JUnitCfgOfCreate.addTitledBorder(jpCodeGen, new Insets(12, 12, 11, 12), this.bundle.getString("JUnitCfgOfCreate.jpCodeGen.title"));
        methodAccessLevels.setAlignmentX(0.0f);
        if (this.multipleClasses) {
            classTypes.setAlignmentX(0.0f);
            optionalClasses.setAlignmentX(0.0f);
        }
        optionalCode.setAlignmentX(0.0f);
        optionalComments.setAlignmentX(0.0f);
        return jpCodeGen;
    }

    private static void addTitledBorder(JComponent component, Insets insets, String title) {
        Border insideBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        TitledBorder outsideBorder = new TitledBorder(BorderFactory.createEtchedBorder(), title);
        component.setBorder(new CompoundBorder(outsideBorder, insideBorder));
    }

    FileObject getTargetFolder() {
        Object selectedLocation = this.cboxLocation.getSelectedItem();
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder();
        }
        assert (selectedLocation instanceof FileObject);
        return (FileObject)selectedLocation;
    }

    private void fillFormData() {
        DataObject dataObj = (DataObject)this.nodes[0].getLookup().lookup(DataObject.class);
        FileObject fileObj = dataObj.getPrimaryFile();
        if (this.singleClass) {
            assert (this.nodes.length == 1);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String className = cp.getResourceName(fileObj, '.', false);
            this.lblClassToTestValue.setText(className);
            if (this.tfClassName != null) {
                String prefilledName = className + TEST_CLASS_SUFFIX;
                this.tfClassName.setText(prefilledName);
                this.tfClassName.setDefaultText(prefilledName);
                this.tfClassName.setCaretPosition(prefilledName.length());
            }
        } else if (this.singlePackage) {
            assert (this.nodes.length == 1);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String packageName = cp.getResourceName(fileObj, '.', true);
            if (packageName.length() == 0) {
                packageName = NbBundle.getMessage(this.getClass(), (String)"DefaultPackageName");
            }
            this.lblClassToTestValue.setText(packageName);
        }
        this.setupLocationChooser(fileObj);
        this.checkClassNameValidity();
    }

    private void setupLocationChooser(FileObject refFileObject) {
        Object[] targetFolders = TestUtil.getTestTargets(refFileObject);
        if (targetFolders.length != 0) {
            this.hasTargetFolders = true;
            this.cboxLocation.setModel(new DefaultComboBoxModel<Object>(targetFolders));
            this.cboxLocation.setRenderer(new LocationChooserRenderer());
        } else {
            this.hasTargetFolders = false;
            String msgNoTargetsFound = NbBundle.getMessage(this.getClass(), (String)(refFileObject.isFolder() ? "MSG_NoTestTarget_Fo" : "MSG_NoTestTarget_Fi"), (Object)refFileObject.getNameExt());
            this.setMessage(msgNoTargetsFound, 0);
            this.disableComponents();
        }
    }

    private void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(3);
        }
        this.changeListeners.add(l);
    }

    private void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.remove(l) && this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }

    private void fireStateChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            Iterator i = this.changeListeners.iterator();
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(e);
            }
        }
    }

    private void disableComponents() {
        Stack<Component> stack = new Stack<Component>();
        stack.push(this);
        while (!stack.empty()) {
            Container container = (Container)stack.pop();
            Component[] comps = container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (comp == this.txtAreaMessage) continue;
                if (comp instanceof JPanel) {
                    stack.push(comp);
                    Border border = ((JPanel)comp).getBorder();
                    if (border == null) continue;
                    JUnitCfgOfCreate.disableBorderTitles(border);
                    continue;
                }
                comp.setEnabled(false);
                if (!(comp instanceof Container) || ((Container)comp).getComponentCount() == 0) continue;
                stack.push(comp);
            }
        }
    }

    private static void disableBorderTitles(Border border) {
        if (border instanceof TitledBorder) {
            JUnitCfgOfCreate.disableBorderTitle((TitledBorder)border);
            return;
        }
        if (!(border instanceof CompoundBorder)) {
            return;
        }
        Stack<Border> stack = new Stack<Border>();
        stack.push(border);
        while (!stack.empty()) {
            CompoundBorder cb = (CompoundBorder)stack.pop();
            Border b = cb.getOutsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push(b);
            } else if (b instanceof TitledBorder) {
                JUnitCfgOfCreate.disableBorderTitle((TitledBorder)b);
            }
            b = cb.getInsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push(b);
                continue;
            }
            if (!(b instanceof TitledBorder)) continue;
            JUnitCfgOfCreate.disableBorderTitle((TitledBorder)b);
        }
    }

    private static void disableBorderTitle(TitledBorder border) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            border.setTitleColor(color);
        }
    }

    private final class LocationChooserRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, value instanceof SourceGroup ? ((SourceGroup)value).getDisplayName() : (value instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)value)) : value.toString()), index, isSelected, cellHasFocus);
        }
    }

    private final class CheckBoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            assert (source == JUnitCfgOfCreate.this.chkPublic || source == JUnitCfgOfCreate.this.chkProtected || source == JUnitCfgOfCreate.this.chkPackage);
            JUnitCfgOfCreate.this.checkChkBoxesStates();
            JUnitCfgOfCreate.this.checkAcceptability();
        }
    }
}

