/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.actions.CookieAction;

abstract class TestAction
extends CookieAction {
    protected Class[] cookieClasses() {
        return new Class[]{DataFolder.class, SourceCookie.class};
    }

    protected int mode() {
        return 7;
    }

    public boolean asynchronous() {
        return true;
    }

    protected boolean enable(Node[] nodes) {
        if (!super.enable(nodes)) {
            return false;
        }
        if (nodes.length == 0) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (TestAction.isEnabledOnNode(nodes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isEnabledOnNode(Node node) {
        DataObject dob = (DataObject)node.getCookie(DataObject.class);
        FileObject fo = null;
        if (dob != null) {
            fo = dob.getPrimaryFile();
        }
        if (fo == null) {
            return false;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return false;
        }
        return TestAction.getSourceGroup(fo, prj) != null;
    }

    private static SourceGroup getSourceGroup(FileObject file, Project prj) {
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] srcgrps = src.getSourceGroups("java");
        for (int i = 0; i < srcgrps.length; ++i) {
            FileObject rootFolder = srcgrps[i].getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcgrps[i].contains(file)) continue;
            return srcgrps[i];
        }
        return null;
    }
}

