/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultPanelTree;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

final class ResultViewTree
implements MultiViewElement,
ChangeListener {
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private final ResultDisplayHandler displayHandler;
    private ResultPanelTree visualPanel;
    private JComponent toolBar;
    private MultiViewElementCallback callback;
    private Report report;

    ResultViewTree(ResultDisplayHandler displayHandler) {
        this.displayHandler = displayHandler;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        assert (EventQueue.isDispatchThread());
        assert (this.visualPanel != null);
        assert (this.callback != null);
        this.showToolBar();
        ((ResultPanelTree)this.getVisualRepresentation()).requestFocusInWindow();
    }

    public void componentDeactivated() {
        assert (EventQueue.isDispatchThread());
        assert (this.visualPanel != null);
        assert (this.callback != null);
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentHidden() {
        this.hideToolBar();
    }

    public void componentShowing() {
        this.showToolBar();
    }

    private void showToolBar() {
        if (this.toolBar != null) {
            this.toolBar.setVisible(true);
        }
    }

    private void hideToolBar() {
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
    }

    public Action[] getActions() {
        return new Action[0];
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolBar == null) {
            this.getVisualRepresentation();
            this.toolBar = this.createToolbar(this.visualPanel.getFilterButton());
        }
        return this.toolBar;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public JComponent getVisualRepresentation() {
        if (this.visualPanel == null) {
            this.visualPanel = this.createTreePanel();
        }
        return this.visualPanel;
    }

    public void stateChanged(ChangeEvent e) {
    }

    private ResultPanelTree createTreePanel() {
        return new ResultPanelTree(this.displayHandler);
    }

    private JComponent createToolbar(AbstractButton filterButton) {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        toolbar.addSeparator();
        toolbar.add(filterButton);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.setFocusable(false);
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        return toolbar;
    }
}

