/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;

public class Utils {
    static String keyStrokesToString(List keys) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keys.iterator();
        if (it.hasNext()) {
            sb.append(Utilities.keyToString((KeyStroke)((KeyStroke)it.next())));
            while (it.hasNext()) {
                sb.append('$').append(Utilities.keyToString((KeyStroke)((KeyStroke)it.next())));
            }
        }
        return sb.toString();
    }

    static KeyStroke[] stringToKeyStrokes(String key) {
        StringTokenizer st = new StringTokenizer(key, "$");
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        key = null;
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)ks);
            if (keyStroke == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("no key stroke for:" + key);
                continue;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    static FileObject getFileObject(String[] mimeTypes, String profile, String fileNameExt) {
        String name = Utils.getFileName(mimeTypes, profile, fileNameExt);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        return fs.findResource(name);
    }

    static FileObject createFileObject(String[] mimeTypes, String profile, String fileName) {
        String name = Utils.getFileName(mimeTypes, profile, fileName);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        try {
            if (fileName == null) {
                return FileUtil.createFolder((FileObject)fs.getRoot(), (String)name);
            }
            return FileUtil.createData((FileObject)fs.getRoot(), (String)name);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    static void deleteFileObject(String[] mimeTypes, String profile, String fileName) {
        String name = Utils.getFileName(mimeTypes, profile, fileName);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource(name);
        if (fo == null) {
            return;
        }
        try {
            fo.delete();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    static String getFileName(String[] mimeTypes, String profile, String fileName) {
        StringBuffer sb = new StringBuffer("Editors");
        int k = mimeTypes.length;
        for (int i = 0; i < k; ++i) {
            sb.append('/').append(mimeTypes[i]);
        }
        if (profile != null) {
            sb.append('/').append(profile);
        }
        if (fileName != null) {
            sb.append('/').append(fileName);
        }
        return sb.toString();
    }

    private static FileObject createFile(FileObject fo, String next) throws IOException {
        FileObject fo1 = fo.getFileObject(next);
        if (fo1 == null) {
            return fo.createFolder(next);
        }
        return fo1;
    }
}

