/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

public class Position {
    public static final int NOPOS = -1;
    public static final int FIRSTPOS = 0;
    public static final int FIRSTLINE = 1;
    public static final int FIRSTCOLUMN = 1;
    public static final int MAXPOS = Integer.MAX_VALUE;

    public static class LineMap {
        private int[] startPosition;
        private int lastPosition = 0;
        private int lastLine = 1;

        public LineMap(char[] src, int max) {
            int c = 0;
            int i = 0;
            int[] linebuf = new int[max];
            block0: while (i < max) {
                linebuf[c++] = i;
                do {
                    if (src[i] != '\r' && src[i] != '\n') continue;
                    if (src[i] == '\r' && i + 1 < max && src[i + 1] == '\n') {
                        i += 2;
                        continue block0;
                    }
                    ++i;
                    continue block0;
                } while (++i < max);
            }
            this.startPosition = new int[c];
            System.arraycopy(linebuf, 0, this.startPosition, 0, c);
        }

        public int getStartPosition(int line) {
            return this.startPosition[line - 1];
        }

        public int getPosition(int line, int column) {
            return this.startPosition[line - 1] + column - 1;
        }

        public int getLineNumber(int pos) {
            if (pos == this.lastPosition) {
                return this.lastLine;
            }
            this.lastPosition = pos;
            int low = 0;
            int high = this.startPosition.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int midVal = this.startPosition[mid];
                if (midVal < pos) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > pos) {
                    high = mid - 1;
                    continue;
                }
                this.lastLine = mid + 1;
                return this.lastLine;
            }
            this.lastLine = low;
            return this.lastLine;
        }

        public int getColumnNumber(int pos) {
            return pos - this.startPosition[this.getLineNumber(pos) - 1] + 1;
        }
    }
}

