/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.j2seproject.SourceRoots;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class CompiledSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private static final String PROP_BUILD_DIR = "build.dir";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Map cache = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompiledSourceForBinaryQuery(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots srcRoots, SourceRoots testRoots) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = srcRoots;
        this.testRoots = testRoots;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res;
        if (FileUtil.getArchiveFile((URL)binaryRoot) != null) {
            binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
        }
        if ((res = (SourceForBinaryQuery.Result)this.cache.get(binaryRoot)) != null) {
            return res;
        }
        SourceRoots src = null;
        if (this.hasSources(binaryRoot, "build.classes.dir")) {
            src = this.sourceRoots;
        } else if (this.hasSources(binaryRoot, "dist.jar")) {
            src = this.sourceRoots;
        } else if (this.hasSources(binaryRoot, "build.test.classes.dir")) {
            src = this.testRoots;
        }
        if (src == null) {
            return null;
        }
        res = new Result(src);
        this.cache.put(binaryRoot, res);
        return res;
    }

    private boolean hasSources(URL binaryRoot, String binaryProperty) {
        try {
            String outDir = this.evaluator.getProperty(binaryProperty);
            if (outDir != null) {
                File f = this.helper.resolveFile(outDir);
                URL url = f.toURI().toURL();
                if (!f.exists() && !f.getPath().toLowerCase().endsWith(".jar")) {
                    if (!$assertionsDisabled && url.toExternalForm().endsWith("/")) {
                        throw new AssertionError(f);
                    }
                    url = new URL(url.toExternalForm() + "/");
                }
                if (url.equals(binaryRoot)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURL) {
            ErrorManager.getDefault().notify((Throwable)malformedURL);
        }
        return false;
    }

    static {
        $assertionsDisabled = !CompiledSourceForBinaryQuery.class.desiredAssertionStatus();
    }

    private class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private ArrayList listeners;
        private SourceRoots sourceRoots;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Result(SourceRoots sourceRoots) {
            this.sourceRoots = sourceRoots;
            this.sourceRoots.addPropertyChangeListener(this);
        }

        public FileObject[] getRoots() {
            ArrayList<FileObject> result = new ArrayList<FileObject>();
            result.addAll(Arrays.asList(this.sourceRoots.getRoots()));
            try {
                String buildDir = CompiledSourceForBinaryQuery.this.evaluator.getProperty(CompiledSourceForBinaryQuery.PROP_BUILD_DIR);
                if (buildDir != null) {
                    FileObject root;
                    File f = new File(CompiledSourceForBinaryQuery.this.helper.resolveFile(buildDir), "generated/wsclient");
                    URL url = f.toURI().toURL();
                    if (!f.exists()) {
                        if (!$assertionsDisabled && url.toExternalForm().endsWith("/")) {
                            throw new AssertionError();
                        }
                        url = new URL(url.toExternalForm() + '/');
                    }
                    if ((root = URLMapper.findFileObject((URL)url)) != null) {
                        result.add(root);
                    }
                    f = new File(CompiledSourceForBinaryQuery.this.helper.resolveFile(buildDir), "generated/wsimport/client");
                    url = f.toURI().toURL();
                    if (!f.exists()) {
                        if (!$assertionsDisabled && url.toExternalForm().endsWith("/")) {
                            throw new AssertionError();
                        }
                        url = new URL(url.toExternalForm() + '/');
                    }
                    if ((root = URLMapper.findFileObject((URL)url)) != null) {
                        result.add(root);
                    }
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return result.toArray(new FileObject[result.size()]);
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("roots".equals(evt.getPropertyName())) {
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator it;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$queries$CompiledSourceForBinaryQuery == null ? (class$org$netbeans$modules$java$j2seproject$queries$CompiledSourceForBinaryQuery = CompiledSourceForBinaryQuery.class$("org.netbeans.modules.java.j2seproject.queries.CompiledSourceForBinaryQuery")) : class$org$netbeans$modules$java$j2seproject$queries$CompiledSourceForBinaryQuery).desiredAssertionStatus();
        }
    }
}

