/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.awt.Image;
import java.lang.reflect.Modifier;
import java.text.Format;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.javadoc.comments.AutoCommenter;
import org.openide.util.Utilities;

final class ElementDescriptor {
    private static final int offsetPublic = 0;
    private static final int offsetPackage = 4;
    private static final int offsetProtected = 8;
    private static final int offsetPrivate = 12;
    private static final int iconNothing = 0;
    private static final int iconClass = 1;
    private static final int iconInterface = 2;
    private static final int iconField = 3;
    private static final int iconConstructor = 16;
    private static final int iconMethod = 29;
    private static final int iconEnum = 42;
    private static final int iconAnnType = 55;
    private static final int iconConstant = 68;
    private static String[] EMPTY_ARRAY;
    private String name;
    private String formattedName;
    private int modifiers;
    private int effectiveAccess;
    private ImageIcon icon;
    private String declaringClassName;
    private String[] paramNames = EMPTY_ARRAY;
    private String[] throwFQNames = EMPTY_ARRAY;
    private String typeFQName;
    private final AutoCommenter.Element element;
    private final String identity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ElementDescriptor(AutoCommenter.Element el, Format nameFormat) throws JmiException {
        this.element = el;
        ClassMember cm = el.getSrcElement();
        this.name = cm.getName();
        this.formattedName = nameFormat.format(cm);
        this.modifiers = cm.getModifiers();
        ClassDefinition cd = cm.getDeclaringClass();
        if (cd != null) {
            this.declaringClassName = cd.getName();
        }
        if (cm instanceof CallableFeature) {
            CallableFeature cf = (CallableFeature)cm;
            this.paramNames = ElementDescriptor.getParameterNames(cf);
            this.throwFQNames = ElementDescriptor.getThrowFQNames(cf);
        }
        if (cm instanceof TypedElement) {
            this.typeFQName = ((TypedElement)cm).getType().getName();
        }
        this.effectiveAccess = ElementDescriptor.getEffectiveAccess(cm);
        this.identity = cm.refMofId();
    }

    public final String getName() {
        return this.name;
    }

    public final String getFormattedName() {
        return this.formattedName;
    }

    public final String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final int getEffectiveAccess() {
        return this.effectiveAccess;
    }

    public final String[] getParameterNames() {
        return this.paramNames;
    }

    public final String[] getThrowFQNames() {
        return this.throwFQNames;
    }

    public final String getTypeFQName() {
        return this.typeFQName;
    }

    public final Icon getIcon() {
        if (!$assertionsDisabled && this.icon == null) {
            throw new AssertionError();
        }
        return this.icon;
    }

    public String getIdentity() {
        return this.identity;
    }

    public final void recomputeIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon();
        }
        this.icon.setImage(this.getMergedImage());
    }

    private static String[] getParameterNames(CallableFeature cf) {
        List params = cf.getParameters();
        String[] names = new String[params.size()];
        int i = 0;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            names[i] = param.getName();
            ++i;
        }
        return names;
    }

    private static String[] getThrowFQNames(CallableFeature cf) {
        List exs = cf.getExceptions();
        String[] names = new String[exs.size()];
        int i = 0;
        Iterator it = exs.iterator();
        while (it.hasNext()) {
            JavaClass ex = (JavaClass)it.next();
            names[i] = ex.getName();
            ++i;
        }
        return names;
    }

    private Image getMergedImage() {
        int error = this.element.getErrorNumber();
        int type = this.resolveIconIndex();
        Image im1 = ElementDescriptor.getImage(error);
        Image im2 = ElementDescriptor.getMemberImage(type);
        return Utilities.mergeImages((Image)im1, (Image)im2, (int)18, (int)0);
    }

    private int resolveIconIndex() throws JmiException {
        ClassMember me = this.element.getSrcElement();
        int offset = (1 & this.modifiers) != 0 ? 0 : ((2 & this.modifiers) != 0 ? 12 : ((4 & this.modifiers) != 0 ? 8 : 4));
        if (me instanceof JavaEnum) {
            return offset + 42;
        }
        if (me instanceof AnnotationType) {
            return offset + 55;
        }
        if (me instanceof JavaClass) {
            return offset + (Modifier.isInterface(this.modifiers) ? 2 : 1);
        }
        if (me instanceof Method || me instanceof Attribute) {
            return offset + 29;
        }
        if (me instanceof Constructor) {
            return offset + 16;
        }
        if (me instanceof EnumConstant) {
            return 68;
        }
        if (me instanceof Field) {
            return offset + 3;
        }
        return 0;
    }

    private static Image getMemberImage(int index) {
        switch (index) {
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                return Utilities.loadImage((String)"org/openide/src/resources/class.gif");
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                return Utilities.loadImage((String)"org/openide/src/resources/interface.gif");
            }
            case 42: 
            case 46: 
            case 50: 
            case 54: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/enum.gif");
            }
            case 55: 
            case 59: 
            case 63: 
            case 67: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/annotation_type.gif");
            }
            case 68: {
                return Utilities.loadImage((String)"org/netbeans/modules/java/resources/constant.gif");
            }
            case 3: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePublic.gif");
            }
            case 7: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePackage.gif");
            }
            case 11: {
                return Utilities.loadImage((String)"org/openide/src/resources/variableProtected.gif");
            }
            case 15: {
                return Utilities.loadImage((String)"org/openide/src/resources/variablePrivate.gif");
            }
            case 16: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPublic.gif");
            }
            case 20: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPackage.gif");
            }
            case 24: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorProtected.gif");
            }
            case 28: {
                return Utilities.loadImage((String)"org/openide/src/resources/constructorPrivate.gif");
            }
            case 29: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPublic.gif");
            }
            case 33: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPackage.gif");
            }
            case 37: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodProtected.gif");
            }
            case 41: {
                return Utilities.loadImage((String)"org/openide/src/resources/methodPrivate.gif");
            }
        }
        return null;
    }

    private static Image getImage(int index) {
        switch (index) {
            case 1: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/ok.gif");
            }
            case 2: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/missing.gif");
            }
            case 4: {
                return Utilities.loadImage((String)"org/netbeans/modules/javadoc/comments/resources/error.gif");
            }
        }
        return null;
    }

    private static int getEffectiveAccess(ClassMember el) {
        int access = el.getModifiers() & 7;
        if (access == 2) {
            return access;
        }
        JavaClass decl = (JavaClass)el.getDeclaringClass();
        if (decl == null) {
            return access;
        }
        if (decl.isInterface()) {
            access = 1;
        }
        int parentAccess = ElementDescriptor.getEffectiveAccess((ClassMember)decl);
        switch (parentAccess) {
            case 0: 
            case 2: {
                return parentAccess;
            }
            case 4: {
                return access == 0 ? 0 : parentAccess;
            }
        }
        return access;
    }

    static {
        $assertionsDisabled = !ElementDescriptor.class.desiredAssertionStatus();
        EMPTY_ARRAY = new String[0];
    }
}

