/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.BrowseFolders;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class Utils {
    public static final String ICON_BASE_DD_VALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    public static final String ICON_BASE_DD_INVALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    public static final String ICON_BASE_EJB_MODULE_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbModuleNodeIcon";
    public static final String ICON_BASE_ENTERPRISE_JAVA_BEANS_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbContainerNodeIcon";
    public static final String ICON_BASE_SESSION_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/SessionNodeIcon";
    public static final String ICON_BASE_ENTITY_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EntityNodeIcon";
    public static final String ICON_BASE_MESSAGE_DRIVEN_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MessageNodeIcon";
    public static final String ICON_BASE_MISC_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MiscNodeIcon";
    private static BrowseFolders.FileObjectFilter imageFileFilter = new BrowseFolders.FileObjectFilter(){

        public boolean accept(FileObject fileObject) {
            return fileObject.getMIMEType().startsWith("image/");
        }
    };

    public static String browseIcon(EjbJarMultiViewDataObject dataObject) {
        String relativePath;
        FileObject fileObject = BrowseFolders.showDialog(dataObject.getSourceGroups(), imageFileFilter);
        if (fileObject != null) {
            FileObject projectDirectory = dataObject.getProjectDirectory();
            relativePath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)fileObject);
        } else {
            relativePath = null;
        }
        return relativePath;
    }

    public static Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        return c == null ? new Color(89, 79, 191) : c;
    }

    public static JTree findTreeComponent(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            for (int i = 0; i < components.length; ++i) {
                JTree tree = Utils.findTreeComponent(components[i]);
                if (tree == null) continue;
                return tree;
            }
        }
        return null;
    }

    public static void scrollToVisible(JComponent component) {
        org.netbeans.modules.xml.multiview.Utils.scrollToVisible((JComponent)component);
    }

    public static String getBundleMessage(String messageId) {
        return NbBundle.getMessage((Class)Utils.class, (String)messageId);
    }

    public static String getBundleMessage(String messageId, Object param1) {
        return NbBundle.getMessage((Class)Utils.class, (String)messageId, (Object)param1);
    }

    public static String getBundleMessage(String messageId, Object param1, Object param2) {
        return NbBundle.getMessage((Class)Utils.class, (String)messageId, (Object)param1, (Object)param2);
    }

    public static String getBundleMessage(String messageId, Object param1, Object param2, Object param3) {
        return NbBundle.getMessage((Class)Utils.class, (String)messageId, (Object)param1, (Object)param2, (Object)param3);
    }

    public static boolean isJavaIdentifier(String id) {
        return Utilities.isJavaIdentifier((String)id);
    }

    public static boolean isValidPackageName(String packageName) {
        String[] strings = packageName.split("[.]");
        if (strings.length == 0) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (Utils.isJavaIdentifier(strings[i])) continue;
            return false;
        }
        return packageName.charAt(packageName.length() - 1) != '.';
    }

    public static void removeClass(ClassPath classPath, String className) {
        FileObject sourceFile = Utils.getSourceFile(classPath, className);
        if (sourceFile != null) {
            try {
                JavaDataObject.find((FileObject)sourceFile).delete();
            }
            catch (DataObjectNotFoundException e) {
                Utils.notifyError((Exception)((Object)e));
            }
            catch (IOException e) {
                Utils.notifyError(e);
            }
        }
    }

    public static FileObject getPackageFile(ClassPath classPath, String packageName) {
        return classPath.findResource(Utils.packageToPath(packageName));
    }

    private static String packageToPath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getPackage(String ejbClass) {
        int i = ejbClass.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return ejbClass.substring(0, i);
    }

    public static void notifyError(Exception ex) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    public static FileObject getSourceFile(ClassPath classPath, String className) {
        return classPath.findResource(Utils.packageToPath(className) + ".java");
    }

    public static Node createEntityNode(FileObject ejbJarFile, ClassPath classPath, Entity entity) {
        EjbJar ejbJar;
        try {
            ejbJar = DDProvider.getDefault().getDDRoot(ejbJarFile);
        }
        catch (IOException e) {
            Utils.notifyError(e);
            return null;
        }
        return J2eeProjectView.getEjbNodesFactory().createEntityNode(entity, ejbJar, classPath, ejbJarFile);
    }

    public static ClassPath getSourceClassPath(FileObject ejbJarFile) {
        Sources sources = ProjectUtils.getSources((Project)FileOwnerQuery.getOwner((FileObject)ejbJarFile));
        SourceGroup[] groups = sources.getSourceGroups("java");
        ClassPath srcClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ClassPathImpl(groups));
        ClassPath bootClassPath = ClassPath.getClassPath((FileObject)ejbJarFile, (String)"classpath/boot");
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{srcClassPath, bootClassPath});
    }

    public static Method getMethod(JavaClass javaClass, Method method) {
        if (javaClass == null || method == null) {
            return null;
        }
        LinkedList<Type> parameters = new LinkedList<Type>();
        Iterator it = method.getParameters().iterator();
        while (it.hasNext()) {
            parameters.add(((Parameter)it.next()).getType());
        }
        return javaClass.getMethod(method.getName(), parameters, false);
    }

    public static void addMethod(JavaClass javaClass, Method prototype) {
        Utils.addMethod(javaClass, prototype, false);
    }

    public static void addMethod(JavaClass javaClass, Method prototype, boolean remote) {
        if (prototype != null) {
            Utils.addMethod(javaClass, prototype, remote, prototype.getModifiers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethod(JavaClass interfaceClass, Method prototype, boolean remote, int modifiers) {
        if (interfaceClass == null || prototype == null) {
            return;
        }
        if (Utils.getMethod(interfaceClass, prototype) != null) {
            return;
        }
        Utils.beginJmiTransaction(true);
        boolean rollback = true;
        try {
            Method method = JMIUtils.createMethod((JavaClass)interfaceClass);
            method.setName(prototype.getName());
            Type type = prototype.getType();
            if (type != null) {
                method.setType(JMIUtils.resolveType((String)type.getName()));
            }
            JMIUtils.replaceParameters((Method)method, (List)prototype.getParameters());
            method.setModifiers(modifiers);
            if (remote) {
                JMIUtils.addException((Method)method, (String)RemoteException.class.getName());
            }
            Iterator it = prototype.getExceptionNames().iterator();
            while (it.hasNext()) {
                MultipartId mpId = (MultipartId)it.next();
                String exceptionName = mpId.getName();
                if ("RemoteException".equals(exceptionName) || "java.rmi.RemoteException".equals(exceptionName)) continue;
                JMIUtils.addException((Method)method, (String)exceptionName);
            }
            Utils.getContents(interfaceClass).add(method);
            rollback = false;
        }
        finally {
            Utils.endJmiTransaction(rollback);
        }
    }

    public static List getContents(JavaClass javaClass) {
        return ((JavaClass)JMIUtils.resolveType((String)javaClass.getName())).getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMethod(JavaClass javaClass, Method method) {
        if (javaClass == null || method == null) {
            return;
        }
        Utils.beginJmiTransaction(true);
        boolean rollback = true;
        try {
            Utils.getContents(javaClass).remove(Utils.getMethod(javaClass, method));
            rollback = false;
        }
        finally {
            Utils.endJmiTransaction(rollback);
        }
    }

    private static Lookup createClassRefactoringLookup(String fullClassName) {
        Node node = SourceNodes.getExplorerFactory().createClassNode((JavaClass)JMIUtils.resolveType((String)fullClassName));
        InstanceContent ic = new InstanceContent();
        ic.add((Object)node);
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    public static void activateRenameClassUI(String fullClassName) {
        Lookup lookup = Utils.createClassRefactoringLookup(fullClassName);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance(lookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    public static void activateMoveClassUI(String fullClassName) {
        Lookup lookup = Utils.createClassRefactoringLookup(fullClassName);
        Action action = RefactoringActionsFactory.moveClassAction().createContextAwareInstance(lookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    public static void renameMethod(Method method, String name) {
        if (method != null) {
            method.setName(name);
        }
    }

    public static String getEjbDisplayName(Ejb ejb) {
        String name = ejb.getDefaultDisplayName();
        if (name == null && (name = ejb.getEjbName()) == null) {
            name = " ";
        }
        return name;
    }

    public static void openEditorFor(FileObject ejbJarFile, JavaClass javaClass) {
        if (javaClass == null) {
            return;
        }
        FileObject sourceFile = Utils.getSourceFile(Utils.getSourceClassPath(ejbJarFile), javaClass.getName());
        if (sourceFile != null) {
            DataObject javaDo;
            try {
                javaDo = DataObject.find((FileObject)sourceFile);
            }
            catch (DataObjectNotFoundException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Utils.getBundleMessage("MSG_sourceNotFound")));
                return;
            }
            OpenCookie cookie = (OpenCookie)javaDo.getCookie(OpenCookie.class);
            if (cookie != null) {
                cookie.open();
            }
        }
    }

    public static void runInAwtDispatchThread(Runnable runnable) {
        org.netbeans.modules.xml.multiview.Utils.runInAwtDispatchThread((Runnable)runnable);
    }

    public static void changeParameterType(Method method, Type type) {
        if (method != null) {
            Parameter parameter = (Parameter)method.getParameters().get(0);
            parameter.setType(type);
        }
    }

    public static void beginJmiTransaction(boolean writeAccess) {
        JavaModel.getJavaRepository().beginTrans(writeAccess);
    }

    public static void endJmiTransaction(boolean rollback) {
        JavaModel.getJavaRepository().endTrans(rollback);
    }

    private static class ClassPathImpl
    implements ClassPathImplementation {
        private List resources = new LinkedList();

        public ClassPathImpl(SourceGroup[] groups) {
            for (int i = 0; i < groups.length; ++i) {
                SourceGroup group = groups[i];
                try {
                    this.resources.add(new PathResourceImpl(group.getRootFolder().getURL()));
                    continue;
                }
                catch (FileStateInvalidException e) {
                    Utils.notifyError((Exception)((Object)e));
                }
            }
        }

        public List getResources() {
            return this.resources;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        private class PathResourceImpl
        implements PathResourceImplementation {
            URL[] roots;

            public PathResourceImpl(URL root) {
                this.roots = new URL[]{root};
            }

            public URL[] getRoots() {
                return this.roots;
            }

            public ClassPathImplementation getContent() {
                return ClassPathImpl.this;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        }
    }
}

