/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddIndexDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class AddIndexAction
extends DatabaseAction {
    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            IndexListNodeInfo nfo = (IndexListNodeInfo)info.getParent(this.nodename);
            String tablename = (String)nfo.get("table");
            String columnname = (String)nfo.get("column");
            Specification spec = (Specification)nfo.getSpecification();
            String index = (String)nfo.get("index");
            DriverSpecification drvSpec = info.getDriverSpecification();
            Vector<String> cols = new Vector<String>(5);
            drvSpec.getColumns(tablename, "%");
            ResultSet rs = drvSpec.getResultSet();
            HashMap rset = new HashMap();
            while (rs.next()) {
                rset = drvSpec.getRow();
                cols.add((String)rset.get(new Integer(4)));
                rset.clear();
            }
            rs.close();
            if (cols.size() == 0) {
                throw new Exception(AddIndexAction.bundle().getString("EXC_NoUsableColumnInPlace"));
            }
            AddIndexDialog dlg = new AddIndexDialog(cols, spec, info);
            dlg.setIndexName(tablename + "_idx");
            if (dlg.run()) {
                nfo.addIndex(dlg.getIndexName());
            }
        }
        catch (Exception exc) {
            String message = MessageFormat.format(AddIndexAction.bundle().getString("ERR_UnableToPerformOperation"), node.getName(), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }
}

