/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;

public class DriverNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 6994829681095273161L;

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get("dbdriver");
    }

    public void setDatabaseDriver(DatabaseDriver drv) {
        this.put("name", drv.getName());
        this.put("url", drv.getURL());
        this.put("prefix", drv.getDatabasePrefix());
        this.put("dbdriver", drv);
    }

    public void delete() throws IOException {
        try {
            JDBCDriver driver = this.getJDBCDriver();
            if (driver != null) {
                JDBCDriverManager.getDefault().removeDriver(driver);
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    public String getIconBase() {
        return (String)(this.checkDriverFiles() ? this.get("iconbaseprefered") : this.get("iconbasepreferednotinstalled"));
    }

    public void setIconBase(String base) {
        if (this.checkDriverFiles()) {
            this.put("iconbaseprefered", base);
        } else {
            this.put("iconbasepreferednotinstalled", base);
        }
    }

    private boolean checkDriverFiles() {
        JDBCDriver driver = this.getJDBCDriver();
        if (driver != null) {
            return JDBCDriverSupport.isAvailable(driver);
        }
        return false;
    }

    public JDBCDriver getJDBCDriver() {
        DatabaseDriver dbdrv = this.getDatabaseDriver();
        if (dbdrv == null) {
            return null;
        }
        return dbdrv.getJDBCDriver();
    }
}

