/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

public final class DatabaseRuntimeManager {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(DatabaseRuntimeManager.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final String RUNTIMES_PATH = "Databases/Runtimes";
    private static DatabaseRuntimeManager DEFAULT = null;
    private Lookup.Result result = this.getLookupResult();

    public static synchronized DatabaseRuntimeManager getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new DatabaseRuntimeManager();
        }
        return DEFAULT;
    }

    public DatabaseRuntime[] getRuntimes() {
        Collection runtimes = this.result.allInstances();
        return runtimes.toArray(new DatabaseRuntime[runtimes.size()]);
    }

    public DatabaseRuntime[] getRuntimes(String jdbcDriverClassName) {
        if (jdbcDriverClassName == null) {
            throw new NullPointerException();
        }
        LinkedList<DatabaseRuntime> runtimeList = new LinkedList<DatabaseRuntime>();
        Iterator i = this.result.allInstances().iterator();
        while (i.hasNext()) {
            DatabaseRuntime runtime = (DatabaseRuntime)i.next();
            if (LOG) {
                LOGGER.log(1, "Runtime: " + runtime.getClass().getName() + " for driver " + runtime.getJDBCDriverClass());
            }
            if (!jdbcDriverClassName.equals(runtime.getJDBCDriverClass())) continue;
            runtimeList.add(runtime);
        }
        return runtimeList.toArray(new DatabaseRuntime[runtimeList.size()]);
    }

    private synchronized Lookup.Result getLookupResult() {
        if (this.result == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(RUNTIMES_PATH);
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            this.result = new FolderLookup((DataObject.Container)folder).getLookup().lookup(new Lookup.Template(DatabaseRuntime.class));
        }
        return this.result;
    }
}

