/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.comparators;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import org.netbeans.api.java.comparators.ArrayComparator;
import org.netbeans.api.java.comparators.ClassComparator;
import org.netbeans.api.java.comparators.ConstructorComparator;
import org.netbeans.api.java.comparators.FieldComparator;
import org.netbeans.api.java.comparators.IdentifierComparator;
import org.netbeans.api.java.comparators.MParameterComparator;
import org.netbeans.api.java.comparators.MethodComparator;
import org.netbeans.api.java.comparators.TypeComparator;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public abstract class JavaElementComparator
implements Comparator {
    protected int type;
    private static HashMap element2comparator;
    public static final int SOURCE = 1;
    public static final int RETURN_TYPE = 2;
    public static final int NAME = 4;
    public static final int PARAMETERS = 8;
    public static final int EXCEPTIONS = 16;
    public static final int TYPE = 32;
    public static final int MODIFIERS = 64;
    public static final int ISCLASS = 128;
    public static final int PARAM_NAME = 256;
    public static final int PARAM_MODIFIERS = 512;
    public static final int PARAM_TYPE = 1024;

    protected JavaElementComparator(int t) {
        this.type = t;
    }

    protected int getType() {
        return this.type;
    }

    public abstract int compare(Object var1, Object var2);

    public boolean equals(Object ob) {
        return this.getClass().isInstance(ob) && this.type == ((JavaElementComparator)ob).getType();
    }

    public static Comparator createIdentifierComparator(boolean source) {
        return IdentifierComparator.createComparator(source ? 1 : 0);
    }

    public static Comparator createTypeComparator(boolean source) {
        return TypeComparator.createComparator(source ? 1 : 0);
    }

    public static Comparator createClassComparator(boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(ClassElement.class, source, ordering);
    }

    public static Comparator createConstructorComparator(boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(ConstructorElement.class, source, ordering);
    }

    public static Comparator createFiledComparator(boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(FieldElement.class, source, ordering);
    }

    public static Comparator createMParameterComparator(boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(MethodParameter.class, source, ordering);
    }

    public static Comparator createMethodComparator(boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(MethodElement.class, source, ordering);
    }

    public static Comparator createComparator(Object element, boolean source, int[] ordering) {
        return JavaElementComparator.createComparator(element.getClass(), source, ordering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Comparator createComparator(Class elementClass, boolean source, int[] ordering) {
        Integer type;
        Method createCompMethod;
        int sourceType = source ? 1 : 0;
        Comparator[] comparators = new Comparator[ordering.length];
        if (element2comparator == null) {
            Class clazz = JavaElementComparator.class;
            synchronized (clazz) {
                if (element2comparator == null) {
                    JavaElementComparator.createElementMap();
                }
            }
        }
        if ((createCompMethod = (Method)element2comparator.get(elementClass)) == null) {
            return null;
        }
        if (ordering == null || ordering.length == 0) {
            try {
                type = new Integer(sourceType);
                return (Comparator)createCompMethod.invoke(null, type);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
                return null;
            }
        }
        for (int i = 0; i < ordering.length; ++i) {
            try {
                type = new Integer(ordering[i] | sourceType);
                comparators[i] = (Comparator)createCompMethod.invoke(null, type);
                continue;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
                return null;
            }
        }
        return new ArrayComparator(comparators);
    }

    private static void createElementMap() {
        Class[] args = new Class[]{Integer.TYPE};
        element2comparator = new HashMap();
        try {
            element2comparator.put(ClassElement.class, ClassComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(ConstructorElement.class, ConstructorComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(FieldElement.class, FieldComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(Identifier.class, IdentifierComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(MethodParameter.class, MParameterComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(MethodElement.class, MethodComparator.class.getDeclaredMethod("createComparator", args));
            element2comparator.put(Type.class, TypeComparator.class.getDeclaredMethod("createComparator", args));
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
    }
}

