/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.FieldCustomizer;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class FieldElementNode
extends MemberElementNode {
    public FieldElementNode(FieldElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        this.setElementFormat0(sourceOptions.getFieldElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.FieldNode");
    }

    protected String resolveIconBase() {
        int modif = ((FieldElement)this.element).getModifiers();
        if (!Modifier.isStatic(modif)) {
            if (Modifier.isPrivate(modif)) {
                return "org/openide/src/resources/variablePrivate";
            }
            if (Modifier.isProtected(modif)) {
                return "org/openide/src/resources/variableProtected";
            }
            if (Modifier.isPublic(modif)) {
                return "org/openide/src/resources/variablePublic";
            }
            return "org/openide/src/resources/variablePackage";
        }
        if (Modifier.isPrivate(modif)) {
            return "org/openide/src/resources/variableStPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/src/resources/variableStProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/src/resources/variableStPublic";
        }
        return "org/openide/src/resources/variableStPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getFieldElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createTypeProperty(this.writeable));
        ps.put(this.createInitValueProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                FieldElement el = (FieldElement)FieldElementNode.this.element;
                el.getDeclaringClass().removeField(el);
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new FieldCustomizer((FieldElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createTypeProperty(boolean canW) {
        ElementNode.ElementProp prop = new ElementNode.ElementProp("type", Type.class, canW){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getType();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((FieldElement)(this).FieldElementNode.this.element).setType((Type)val);
                    }
                });
            }
        };
        prop.setValue("acceptVoidType", Boolean.FALSE);
        return prop;
    }

    protected Node.Property createInitValueProperty(boolean canW) {
        return new ElementNode.ElementProp("initValue", String.class, canW){

            public Object getValue() {
                return ((FieldElement)FieldElementNode.this.element).getInitValue();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(FieldElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((FieldElement)(this).FieldElementNode.this.element).setInitValue((String)val);
                    }
                });
            }
        };
    }
}

