/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnElementHolder;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.DBMemoryCollection;
import org.netbeans.modules.dbschema.TableElement;

public final class IndexElement
extends DBMemberElement
implements ColumnElementHolder {
    public IndexElement() {
        this(new Memory(), null);
    }

    public IndexElement(Impl impl, TableElement declaringTable) {
        super(impl, declaringTable);
    }

    final Impl getIndexImpl() {
        return (Impl)this.getElementImpl();
    }

    public boolean isUnique() {
        return this.getIndexImpl().isUnique();
    }

    public void setUnique(boolean flag) throws DBException {
        this.getIndexImpl().setUnique(flag);
    }

    public void addColumn(ColumnElement el) throws DBException {
        this.addColumns(new ColumnElement[]{el});
    }

    public void addColumns(ColumnElement[] els) throws DBException {
        for (int i = 0; i < els.length; ++i) {
            if (this.getColumn(els[i].getName()) == null) continue;
            this.throwAddException("FMT_EXC_AddColumn", els[i]);
        }
        this.getIndexImpl().changeColumns(els, 1);
    }

    public void removeColumn(ColumnElement el) throws DBException {
        this.removeColumns(new ColumnElement[]{el});
    }

    public void removeColumns(ColumnElement[] els) throws DBException {
        this.getIndexImpl().changeColumns(els, -1);
    }

    public void setColumns(ColumnElement[] els) throws DBException {
        if (els == null) {
            throw new NullPointerException(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("NulIndexes"));
        }
        this.getIndexImpl().changeColumns(els, 0);
    }

    public ColumnElement[] getColumns() {
        return this.getIndexImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier name) {
        return this.getIndexImpl().getColumn(name);
    }

    private void throwAddException(String formatKey, ColumnElement element) throws DBException {
        String msg = element.getName().getName();
        throw new DBException(msg);
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private boolean _unique;
        private DBMemoryCollection.Column columns;

        Memory() {
            this._unique = true;
        }

        Memory(IndexElement index) {
            super(index);
            this._unique = index.isUnique();
        }

        public boolean isUnique() {
            return this._unique;
        }

        public void setUnique(boolean flag) {
            boolean old = this._unique;
            this._unique = flag;
            this.firePropertyChange("unique", old, flag);
        }

        public synchronized void changeColumns(ColumnElement[] elems, int action) {
            this.initColumns();
            this.columns.change(elems, action);
        }

        public synchronized ColumnElement[] getColumns() {
            this.initColumns();
            return (ColumnElement[])this.columns.getElements();
        }

        public synchronized ColumnElement getColumn(DBIdentifier name) {
            this.initColumns();
            return (ColumnElement)this.columns.getElement(name);
        }

        void initColumns() {
            if (this.columns == null) {
                this.columns = new DBMemoryCollection.Column(this);
            }
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public boolean isUnique();

        public void setUnique(boolean var1) throws DBException;

        public void changeColumns(ColumnElement[] var1, int var2) throws DBException;

        public ColumnElement[] getColumns();

        public ColumnElement getColumn(DBIdentifier var1);
    }
}

