/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ui.ComponentPanel;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanPanelView;
import org.netbeans.modules.j2ee.sun.share.config.ui.PanelView;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class ConfigBeanTopComponent
extends CloneableTopComponent {
    private ConfigurationStorage storage = null;
    private Node rootNode = null;
    private TwoPanelComponentPanel componentPanel;
    public static final String APPLICATION_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/application.gif";
    public static final String EJBMODULE_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/ejbmodule.gif";
    public static final String WEBMODULE_ICON_NORMAL = "org/netbeans/modules/j2ee/sun/share/config/ui/resources/webmodule.gif";
    private boolean appConfig = false;

    public ConfigBeanTopComponent() {
        this.putClientProperty("PersistenceType", "Never");
    }

    public ConfigBeanTopComponent(ConfigurationStorage storage) {
        this();
        this.storage = storage;
        this.initialize();
    }

    public ConfigDataObject getConfigDataObject() {
        return this.storage.getPrimaryDataObject();
    }

    public void setName(String name) {
        if (name != null && name.startsWith("sun-ejb-jar")) {
            name = "sun-ejb-jar.xml / sun-cmp-mappings.xml";
        }
        super.setName(name);
    }

    public boolean isFor(FileObject document) {
        boolean result = false;
        ConfigDataObject configDO = this.getConfigDataObject();
        if (configDO != null) {
            result = configDO.getPrimaryFile().equals(document);
        }
        return result;
    }

    public boolean isFor(ConfigurationStorage otherStorage) {
        return this.getConfigStorage() == otherStorage;
    }

    private ConfigurationStorage getConfigStorage() {
        return this.storage;
    }

    public static ConfigBeanTopComponent findByConfigStorage(ConfigurationStorage configStorage) {
        Iterator it = TopComponent.getRegistry().getOpened().iterator();
        while (it.hasNext()) {
            ConfigBeanTopComponent beanTC;
            TopComponent tc = (TopComponent)it.next();
            if (!(tc instanceof ConfigBeanTopComponent) || configStorage != (beanTC = (ConfigBeanTopComponent)tc).getConfigStorage()) continue;
            return beanTC;
        }
        return null;
    }

    public void refresh() {
        try {
            this.rootNode = this.buildTree();
            Node[] topNodes = this.rootNode.getChildren().getNodes();
            if (topNodes.length > 0) {
                Node mainNode = topNodes[0];
                this.componentPanel.refresh(this.rootNode, mainNode);
            } else {
                ErrorManager.getDefault().log(1, "ConfigBeanTopComponent: empty top level node list.  Root: " + this.rootNode + ", topNodes: " + topNodes);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        String preferredID = "";
        ConfigDataObject configDO = this.getConfigDataObject();
        if (configDO != null) {
            preferredID = configDO.getPrimaryFile().getPath();
        }
        return preferredID;
    }

    public void initialize() {
        ConfigDataObject configDO = this.getConfigDataObject();
        Node selNode = configDO.getNodeDelegate();
        try {
            if (this.getConfigStorage() == null) {
                throw new IllegalArgumentException("ConfigDataObject without ConfigurationStorage cookie!");
            }
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return;
        }
        this.initComponents();
        this.setName(selNode.getDisplayName());
        String fsName = "";
        FileObject fo = configDO.getPrimaryFile();
        try {
            fsName = fo.getFileSystem().getDisplayName() + "/" + fo.getPath();
        }
        catch (FileStateInvalidException fse) {
            fsName = fo.getPath();
        }
        char sep = File.separatorChar;
        char another = sep == '/' ? (char)'\\' : '/';
        fsName = fsName.replace(another, sep);
        this.setToolTipText(fsName);
        Node[] topNodes = this.rootNode.getChildren().getNodes();
        Node[] activatedNode = new Node[]{topNodes.length > 0 ? topNodes[0] : selNode};
        this.setActivatedNodes(activatedNode);
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/sun/share/config/ui/resources/ConfigFile.gif"));
    }

    public synchronized void reset() {
        this.rootNode = null;
        this.componentPanel = null;
        this.appConfig = false;
    }

    private void initComponents() {
        try {
            this.rootNode = this.buildTree();
            Node[] topNodes = this.rootNode.getChildren().getNodes();
            Node mainNode = null;
            if (topNodes.length > 0) {
                mainNode = topNodes[0];
            }
            this.setLayout(new BorderLayout());
            ConfigBeanPanelView panelView = new ConfigBeanPanelView(this.rootNode);
            this.componentPanel = new TwoPanelComponentPanel(panelView, this.appConfig);
            this.add("Center", (Component)((Object)this.componentPanel));
            this.componentPanel.getExplorerManager().setSelectedNodes(new Node[]{mainNode});
            ((PanelView)panelView).showSelection(new Node[]{mainNode});
        }
        catch (IllegalArgumentException ie) {
            ErrorManager.getDefault().log(ie.getMessage());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private Node getMainNode() {
        return this.getConfigStorage().getMainNode();
    }

    private Node buildTree() {
        ConfigDataObject configDO = this.getConfigDataObject();
        Node filterRoot = configDO.getNodeDelegate();
        AbstractNode root = null;
        Children.Array children = new Children.Array();
        Node[] beanNodes = this.getConfigStorage().getMainNodes();
        children.add(beanNodes);
        root = new AbstractNode((Children)children);
        return root;
    }

    private Node[] createModuleNode(J2eeModule module) {
        Children.Array modChildren = new Children.Array();
        Node[] modConfigBeanNode = this.getConfigStorage().getNodes(module);
        for (int j = 0; j < modConfigBeanNode.length; ++j) {
            if (modConfigBeanNode[j] == null) continue;
            modChildren.add(new Node[]{modConfigBeanNode[j]});
        }
        AbstractNode modNode = new AbstractNode((Children)modChildren);
        modNode.setName(module.getUrl());
        if (module.getModuleType() == ModuleType.EJB) {
            modNode.setIconBaseWithExtension(EJBMODULE_ICON_NORMAL);
        } else if (module.getModuleType() == ModuleType.WAR) {
            modNode.setIconBaseWithExtension(WEBMODULE_ICON_NORMAL);
        }
        return new Node[]{modNode};
    }

    protected void componentClosed() {
        super.componentClosed();
        ConfigDataObject configDO = this.getConfigDataObject();
        if (configDO != null) {
            configDO.editorClosed(this);
        }
    }

    public void open() {
        super.open();
    }

    /*
     * Unable to fully structure code
     */
    public boolean closeLast() {
        super.closeLast();
        configDO = this.getConfigDataObject();
        if (configDO != null && configDO.isModified()) {
            bundle = NbBundle.getBundle((Class)ConfigBeanTopComponent.class);
            msg = NbBundle.getMessage((Class)ConfigBeanTopComponent.class, (String)"MSG_ConfirmSave", (Object)configDO.getName());
            saveOption = new JButton(bundle.getString("CTL_Save"));
            saveOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Save"));
            saveOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Save"));
            discardOption = new JButton(bundle.getString("CTL_Discard"));
            discardOption.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Discard"));
            discardOption.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_CTL_Discard"));
            discardOption.setMnemonic(bundle.getString("CTL_Discard_Mnemonic").charAt(0));
            nd = new NotifyDescriptor((Object)msg, bundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{saveOption, discardOption, NotifyDescriptor.CANCEL_OPTION}, (Object)saveOption);
            ret = DialogDisplayer.getDefault().notify(nd);
            if (saveOption.equals(ret)) {
                try {
                    sc = (SaveCookie)configDO.getCookie(SaveCookie.class);
                    if (sc == null) ** GOTO lbl36
                    sc.save();
                }
                catch (IOException e) {
                    return false;
                }
            } else if (discardOption.equals(ret)) {
                try {
                    configDO.setModified(false);
                    configDO.resetAllChanged();
                    this.getConfigStorage().load();
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
            } else {
                return false;
            }
        }
lbl36:
        // 6 sources

        if (this.appConfig = this.rootNode != null) {
            modules = this.rootNode.getChildren();
            modNodes = modules.getNodes();
            for (i = 0; i < modNodes.length; ++i) {
                if (!(modNodes[i] instanceof AbstractNode)) continue;
                mod = (AbstractNode)modNodes[i];
                ch = mod.getChildren();
                ch.remove(ch.getNodes());
            }
            modules.remove(modules.getNodes());
        }
        return true;
    }

    protected CloneableTopComponent createClonedObject() {
        return new ConfigBeanTopComponent(this.storage);
    }

    private class TwoPanelComponentPanel
    extends ComponentPanel {
        protected TwoPanelComponentPanel() {
        }

        public TwoPanelComponentPanel(PanelView panel) {
            super(panel);
        }

        public TwoPanelComponentPanel(PanelView panel, boolean rootVisible) {
            super(panel);
            JComponent view = this.getStructureView();
            if (view instanceof TreeView) {
                TreeView tree = (TreeView)view;
                tree.setRootVisible(rootVisible);
            }
        }

        public HelpCtx getHelpCtx() {
            Node[] nodes = this.getExplorerManager().getSelectedNodes();
            if (nodes.length > 0) {
                return nodes[0].getHelpCtx();
            }
            if (ConfigBeanTopComponent.this.rootNode != null) {
                return ConfigBeanTopComponent.this.rootNode.getHelpCtx();
            }
            ConfigDataObject configDO = ConfigBeanTopComponent.this.getConfigDataObject();
            if (configDO != null) {
                return configDO.getHelpCtx();
            }
            return HelpCtx.DEFAULT_HELP;
        }

        protected void createHorizontalSplit() {
            this.split1 = this.panelOrientation == 1 ? new JSplitPane(1, this.getContentView(), this.getStructureView()) : new JSplitPane(1, this.getStructureView(), this.getContentView());
            this.split1.setDividerSize(4);
        }

        protected void createVerticalSplit() {
        }

        protected PanelView getPanelView() {
            return (PanelView)((Object)this.contentView);
        }

        public void refresh(Node root, Node selected) throws PropertyVetoException {
            this.getPanelView().setRoot(root);
            this.setRootContext(root);
            this.getExplorerManager().setSelectedNodes(new Node[]{selected});
            this.getPanelView().showSelection(new Node[]{selected});
        }
    }
}

