/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;

public abstract class BeanInputDialog
extends InputDialog {
    public static final String USER_DATA_CHANGED = "UserDataChanged";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private JPanel parentPanel;
    private JPanel dialogPanel;
    private boolean editmode;
    protected ValidationSupport validationSupport;

    public BeanInputDialog(JPanel parent, String title, Object[] values) {
        this(parent, title, false, values);
    }

    public BeanInputDialog(JPanel parent, String title, boolean showRequiredNote, Object[] values) {
        super(parent, title, showRequiredNote);
        this.editmode = true;
        this.parentPanel = parent;
        this.dialogPanel = this.getDialogPanel(values);
        this.validationSupport = new ValidationSupport();
        this.initComponents();
    }

    public BeanInputDialog(JPanel parent, String title) {
        this(parent, title, false);
    }

    public BeanInputDialog(JPanel parent, String title, boolean showRequiredNote) {
        super(parent, title, showRequiredNote);
        this.editmode = false;
        this.parentPanel = parent;
        this.dialogPanel = this.getDialogPanel();
        this.validationSupport = new ValidationSupport();
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.addListeners();
        this.adjustSize();
        this.pack();
        this.setLocationInside(this.parentPanel);
        this.handleErrorDisplay();
    }

    private void adjustSize() {
        int preferredWidth = this.parentPanel.getWidth() * 3 / 4;
        int noOfFields = this.getNOofFields();
        if (-1 != noOfFields) {
            Dimension dm = this.getContentPane().getPreferredSize();
            int preferredHeight = (int)this.dialogPanel.getPreferredSize().getHeight();
            if ((double)preferredWidth < dm.getWidth()) {
                preferredWidth = (int)dm.getWidth();
            }
            if ((double)preferredHeight < dm.getHeight()) {
                preferredHeight = (int)dm.getHeight();
            }
        }
    }

    protected int getNOofFields() {
        return -1;
    }

    protected abstract Object[] getValues();

    protected abstract Collection getErrors();

    protected abstract JPanel getDialogPanel();

    protected abstract JPanel getDialogPanel(Object[] var1);

    protected abstract String getHelpId();

    private void addListeners() {
        this.dialogPanel.addPropertyChangeListener(USER_DATA_CHANGED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BeanInputDialog.this.handleErrorDisplay();
            }
        });
    }

    private void handleErrorDisplay() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.hasDuplicateEntry()) {
            errors.add(bundle.getString("ERR_ObjectIsDuplicate"));
        } else {
            errors.addAll(this.getErrors());
        }
        this.setErrors(errors);
    }

    protected boolean hasDuplicateEntry() {
        boolean result = false;
        if (this.parentPanel instanceof BeanTablePanel) {
            BeanTablePanel beanPanel = (BeanTablePanel)this.parentPanel;
            BeanTableModel model = beanPanel.getModel();
            Object[] newValues = this.getValues();
            if (!this.editmode && model.alreadyExists(newValues)) {
                result = true;
            }
        }
        return result;
    }

    protected BeanTableModel getModel() {
        BeanTableModel model = null;
        if (this.parentPanel instanceof BeanTablePanel) {
            BeanTablePanel beanPanel = (BeanTablePanel)this.parentPanel;
            model = beanPanel.getModel();
        }
        return model;
    }
}

