/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.ErrorMessageDB;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BaseCustomizer;

public class CustomizerErrorPanel
extends JPanel {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private ErrorClient errorClient;

    public CustomizerErrorPanel(ErrorClient client) {
        this.errorClient = client;
        this.initComponents();
        this.initUserComponents();
    }

    public GridBagConstraints getConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(6, 12, 11, 11);
        return constraints;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ErrorTextArea"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ErrorTextArea"));
    }

    private void initUserComponents() {
    }

    public void showErrors(Base bean) {
        Container parent;
        List errorList = null;
        this.removeAll();
        ErrorMessageDB messageDB = ErrorMessageDB.getMessageDB(bean);
        if (messageDB != null) {
            ValidationError.Partition visiblePartition = this.errorClient.getPartition();
            errorList = messageDB.getErrors(visiblePartition);
        }
        if (errorList != null && errorList.size() > 0) {
            Object[] args = new Object[2];
            Iterator iter = errorList.iterator();
            while (iter.hasNext()) {
                ValidationError error = (ValidationError)iter.next();
                args[0] = error.getFieldId();
                args[1] = error.getMessage();
                String message = MessageFormat.format(bundle.getString("MSG_ErrorDisplayFormat"), args);
                JLabel label = new JLabel();
                label.setIcon(BaseCustomizer.errorMessageIcon);
                label.setText(message);
                label.getAccessibleContext().setAccessibleName(bundle.getString("ASCN_ErrorMessage"));
                label.getAccessibleContext().setAccessibleDescription(message);
                label.setForeground(this.errorClient.getErrorMessageForegroundColor());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridwidth = 0;
                constraints.fill = 2;
                constraints.weightx = 1.0;
                this.add((Component)label, constraints);
            }
        }
        if ((parent = this.getParent()) != null) {
            parent.validate();
        }
    }

    public static interface ErrorClient {
        public Color getErrorMessageForegroundColor();

        public ValidationError.Partition getPartition();
    }
}

