/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.sun.validation.ValidationManager;
import org.netbeans.modules.j2ee.sun.validation.ValidationManagerFactory;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;

public class ValidationSupport {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private ValidationManager validationManager;

    public ValidationSupport() {
        ValidationManagerFactory validationManagerFactory = new ValidationManagerFactory();
        this.validationManager = validationManagerFactory.getValidationManager();
    }

    public Collection validate(String value, String xpath, String label) {
        ArrayList<String> errors = new ArrayList<String>();
        Collection failures = this.validationManager.validateIndividualProperty(value, xpath, label);
        if (failures != null) {
            Iterator iterator = failures.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof ConstraintFailure)) continue;
                ConstraintFailure failure = (ConstraintFailure)object;
                String error = failure.getName() + ": " + failure.getGenericfailureMessage();
                errors.add(error);
            }
        }
        return errors;
    }

    public boolean isRequiredProperty(String xpath) {
        boolean isRequired = false;
        String property = "";
        Collection errors = this.validate(property, xpath, null);
        if (!errors.isEmpty()) {
            isRequired = true;
        }
        return isRequired;
    }

    public String getMarkedLabel(String label) {
        String format = bundle.getString("FMT_Required_Field_Label");
        String requiedMark = bundle.getString("LBL_RequiredMark");
        Object[] arguments = new Object[]{requiedMark, label};
        return MessageFormat.format(format, arguments);
    }
}

