/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.templates;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SunDDVisualPanel
extends JPanel {
    private Project project;
    private String sunDDFileName;
    private File sunDDFile;
    private File sunDDLocation;
    private JLabel filler1;
    private JLabel labelCreatedFile;
    private JLabel labelFileName;
    private JLabel labelLocation;
    private JLabel labelProjectName;
    private JTextField textCreatedFile;
    private JTextField textFileName;
    private JTextField textLocation;
    private JTextField textProjectName;

    public SunDDVisualPanel() {
        this.initComponents();
    }

    void setProject(Project project) {
        this.project = project;
        Lookup lookup = project.getLookup();
        J2eeModuleProvider provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
        J2eeModule j2eeModule = provider.getJ2eeModule();
        this.sunDDFileName = this.getConfigFileName(j2eeModule);
        this.sunDDFile = this.sunDDFileName != null ? provider.getDeploymentConfigurationFile(this.sunDDFileName) : null;
        this.sunDDLocation = this.sunDDFile != null ? this.sunDDFile.getParentFile() : null;
        this.textFileName.setText(this.sunDDFileName);
        this.textProjectName.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        File projectFolder = FileUtil.toFile((FileObject)project.getProjectDirectory());
        this.textLocation.setText(this.sunDDLocation != null ? SunDDVisualPanel.getRelativePath(this.sunDDLocation, projectFolder) : null);
        this.textCreatedFile.setText(this.sunDDLocation != null ? SunDDVisualPanel.getRelativePath(this.sunDDFile, projectFolder) : null);
    }

    String getFileName() {
        return this.sunDDFileName;
    }

    File getFile() {
        return this.sunDDFile;
    }

    File getSelectedLocation() {
        return this.sunDDLocation;
    }

    public String getName() {
        return NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"LBL_CreateSunDeploymentDescriptor");
    }

    private void initComponents() {
        this.labelFileName = new JLabel();
        this.textFileName = new JTextField();
        this.labelProjectName = new JLabel();
        this.textProjectName = new JTextField();
        this.labelLocation = new JLabel();
        this.textLocation = new JTextField();
        this.labelCreatedFile = new JLabel();
        this.textCreatedFile = new JTextField();
        this.filler1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelFileName.setDisplayedMnemonic(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"MNE_Name").charAt(0));
        this.labelFileName.setLabelFor(this.textFileName);
        Mnemonics.setLocalizedText((JLabel)this.labelFileName, (String)NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelFileName, gridBagConstraints);
        this.textFileName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.textFileName, gridBagConstraints);
        this.textFileName.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCN_Name"));
        this.textFileName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCD_Name"));
        this.labelProjectName.setDisplayedMnemonic(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"MNE_Project").charAt(0));
        this.labelProjectName.setLabelFor(this.textProjectName);
        Mnemonics.setLocalizedText((JLabel)this.labelProjectName, (String)NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.labelProjectName, gridBagConstraints);
        this.textProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.textProjectName, gridBagConstraints);
        this.textProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCN_Project"));
        this.textProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCD_Project"));
        this.labelLocation.setDisplayedMnemonic(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"MNE_Location").charAt(0));
        this.labelLocation.setLabelFor(this.textLocation);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        this.textLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.textLocation, gridBagConstraints);
        this.textLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCN_Location"));
        this.textLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCD_Location"));
        this.labelCreatedFile.setDisplayedMnemonic(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"MNE_CreatedFile").charAt(0));
        this.labelCreatedFile.setLabelFor(this.textCreatedFile);
        Mnemonics.setLocalizedText((JLabel)this.labelCreatedFile, (String)NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 11, 0);
        this.add((Component)this.labelCreatedFile, gridBagConstraints);
        this.textCreatedFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 0);
        this.add((Component)this.textCreatedFile, gridBagConstraints);
        this.textCreatedFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCN_CreatedFile"));
        this.textCreatedFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SunDDVisualPanel.class, (String)"ASCD_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private String getConfigFileName(J2eeModule j2eeModule) {
        String result = null;
        Object moduleType = j2eeModule.getModuleType();
        if (J2eeModule.WAR.equals(moduleType)) {
            result = "sun-web.xml";
        } else if (J2eeModule.EJB.equals(moduleType)) {
            result = "sun-ejb-jar.xml";
        } else if (J2eeModule.EAR.equals(moduleType)) {
            result = "sun-application.xml";
        } else if (J2eeModule.CLIENT.equals(moduleType)) {
            result = "sun-application-client.xml";
        }
        return result;
    }

    private static String getRelativePath(File file, File base) {
        String basePath = base.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(basePath)) {
            String prefix = "";
            int baseIndex = basePath.lastIndexOf(File.separatorChar);
            if (baseIndex < 0 || baseIndex >= filePath.length()) {
                baseIndex = 0;
            } else {
                prefix = "...";
            }
            return prefix + filePath.substring(baseIndex);
        }
        return filePath;
    }
}

