/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.client.model_1_3.ApplicationClient;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.j2ee.dd.impl.ejb.model_2_0.EjbJar;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDUtils {
    public static EjbJarProxy createEjbJarProxy(InputStream inputStream) throws IOException {
        return DDUtils.createEjbJarProxy(new InputSource(inputStream));
    }

    public static EjbJarProxy createEjbJarProxy(Reader reader) throws IOException {
        return DDUtils.createEjbJarProxy(new InputSource(reader));
    }

    public static EjbJarProxy createEjbJarProxy(InputSource inputSource) throws IOException {
        try {
            return (EjbJarProxy)DDProvider.getDefault().getDDRoot(inputSource);
        }
        catch (SAXException ex) {
            EjbJar ejbJar = EjbJar.createGraph();
            EjbJarProxy ejbJarProxy = new EjbJarProxy(ejbJar, ejbJar.getVersion().toString());
            ejbJarProxy.setStatus(2);
            if (ex instanceof SAXParseException) {
                ejbJarProxy.setError((SAXParseException)ex);
            } else if (ex.getException() instanceof SAXParseException) {
                ejbJarProxy.setError((SAXParseException)ex.getException());
            }
            return ejbJarProxy;
        }
    }

    public static void merge(EjbJarProxy ejbJarProxy, Reader reader) {
        try {
            EjbJarProxy newEjbJarProxy = DDUtils.createEjbJarProxy(reader);
            if (newEjbJarProxy.getStatus() == 2) {
                ejbJarProxy.setStatus(2);
                ejbJarProxy.setError(newEjbJarProxy.getError());
                return;
            }
            ejbJarProxy.merge(newEjbJarProxy, 3);
            ejbJarProxy.setStatus(newEjbJarProxy.getStatus());
            ejbJarProxy.setError(newEjbJarProxy.getError());
        }
        catch (IOException ex) {
            ejbJarProxy.setStatus(2);
        }
        catch (Schema2BeansRuntimeException ex2) {
            ejbJarProxy.setStatus(2);
            ejbJarProxy.setError(new SAXParseException(null, null, (Exception)((Object)ex2)));
        }
    }

    public static WebApp createWebApp(InputStream is, String version) throws IOException, SAXException {
        try {
            if ("2.3".equals(version)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_2_3.WebApp.createGraph(is);
            }
            if ("2.4".equals(version)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_2_4.WebApp.createGraph(is);
            }
            return org.netbeans.modules.j2ee.dd.impl.web.model_2_5.WebApp.createGraph(is);
        }
        catch (RuntimeException ex) {
            throw new SAXException(ex);
        }
    }

    public static AppClient createAppClient(InputStream is, String version) throws IOException, SAXException {
        try {
            if ("1.3".equals(version)) {
                return ApplicationClient.createGraph(is);
            }
            if ("1.4".equals(version)) {
                return org.netbeans.modules.j2ee.dd.impl.client.model_1_4.ApplicationClient.createGraph(is);
            }
            if ("5".equals(version)) {
                return org.netbeans.modules.j2ee.dd.impl.client.model_5_0.ApplicationClient.createGraph(is);
            }
        }
        catch (RuntimeException ex) {
            throw new SAXException(ex);
        }
        return null;
    }
}

