/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

abstract class JPDADebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebuggerImpl debugger;
    private static RequestProcessor actionsRequestProcessor;
    private static Set providersToDisableOnLazyActions;
    private volatile boolean disabled;

    JPDADebuggerActionProvider(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
        debugger.addPropertyChangeListener("state", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.debugger.getState() == 4) {
            Class clazz = JPDADebuggerActionProvider.class;
            synchronized (clazz) {
                if (actionsRequestProcessor != null) {
                    actionsRequestProcessor.stop();
                    actionsRequestProcessor = null;
                }
            }
        }
        this.checkEnabled(this.debugger.getState());
    }

    protected abstract void checkEnabled(int var1);

    public boolean isEnabled(Object action) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(action);
    }

    JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    void removeStepRequests(ThreadReference tr) {
        try {
            VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
            if (vm == null) {
                return;
            }
            EventRequestManager erm = vm.eventRequestManager();
            ArrayList<StepRequest> l = new ArrayList<StepRequest>(erm.stepRequests());
            Iterator<StepRequest> it = l.iterator();
            while (it.hasNext()) {
                StepRequest stepRequest = it.next();
                if (!stepRequest.thread().equals(tr)) continue;
                erm.deleteEventRequest(stepRequest);
                break;
            }
        }
        catch (VMDisconnectedException e) {
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
        }
        catch (InvalidRequestStateException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProviderToDisableOnLazyAction(JPDADebuggerActionProvider provider) {
        Class clazz = JPDADebuggerActionProvider.class;
        synchronized (clazz) {
            providersToDisableOnLazyActions.add(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Runnable run) {
        HashSet disabledActions;
        Class clazz = JPDADebuggerActionProvider.class;
        synchronized (clazz) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("JPDA Processor", 1);
            }
            disabledActions = new HashSet(providersToDisableOnLazyActions);
        }
        Iterator it = disabledActions.iterator();
        while (it.hasNext()) {
            JPDADebuggerActionProvider ap = (JPDADebuggerActionProvider)it.next();
            Set actions = ap.getActions();
            ap.disabled = true;
            Iterator ait = actions.iterator();
            while (ait.hasNext()) {
                Object action = ait.next();
                ap.setEnabled(action, false);
            }
        }
        actionsRequestProcessor.post(new Runnable(){

            public void run() {
                try {
                    run.run();
                    Iterator it = disabledActions.iterator();
                    while (it.hasNext()) {
                        JPDADebuggerActionProvider ap = (JPDADebuggerActionProvider)it.next();
                        Set actions = ap.getActions();
                        ap.disabled = false;
                        ap.checkEnabled(JPDADebuggerActionProvider.this.debugger.getState());
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        providersToDisableOnLazyActions = new WeakSet();
    }
}

