/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.StackFrame;
import java.util.List;

public class EvaluationContext {
    private StackFrame frame;
    private List sourceImports;
    private List staticImports;
    private boolean canInvokeMethods;
    private Runnable methodInvokePreproc;

    public EvaluationContext(StackFrame frame, List imports, List staticImports, boolean canInvokeMethods, Runnable methodInvokePreproc) {
        if (frame == null) {
            throw new IllegalArgumentException("Frame argument must not be null");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Imports argument must not be null");
        }
        if (staticImports == null) {
            throw new IllegalArgumentException("Static imports argument must not be null");
        }
        this.frame = frame;
        this.sourceImports = imports;
        this.staticImports = staticImports;
        this.canInvokeMethods = canInvokeMethods;
        this.methodInvokePreproc = methodInvokePreproc;
    }

    public List getStaticImports() {
        return this.staticImports;
    }

    public List getImports() {
        return this.sourceImports;
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    public boolean canInvokeMethods() {
        return this.canInvokeMethods;
    }

    void setCanInvokeMethods(boolean canInvokeMethods) {
        this.canInvokeMethods = canInvokeMethods;
    }

    void methodToBeInvoked() {
        if (this.methodInvokePreproc != null) {
            this.methodInvokePreproc.run();
        }
    }
}

