/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectUtilities {
    static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    static final String OPEN_FILES_ELEMENT = "open-files";
    static final String FILE_ELEMENT = "file";
    static OpenCloseProjectDocument OPEN_CLOSE_PROJECT_DOCUMENT_IMPL;
    private static final ErrorManager ERR;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project p) {
        SwingUtilities.invokeLater(new Runnable(){
            final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");

            public void run() {
                Node root = this.ptLogial.getExplorerManager().getRootContext();
                Node projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                if (projNode != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        this.ptLogial.expandNode(projNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject newDo) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Node node = newDo.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
                }
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                }
                final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");
                final ProjectTab ptPhysical = ProjectTab.findDefault("projectTab_tc");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean success = ptLogial.selectNode(newDo.getPrimaryFile());
                        if (!success) {
                            ptPhysical.selectNode(newDo.getPrimaryFile());
                        }
                    }
                });
            }
        });
    }

    public static void makeProjectTabVisible(boolean requestFocus) {
        ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
        ptLogical.open();
        if (requestFocus) {
            ptLogical.requestActive();
        } else {
            ptLogical.requestVisible();
        }
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension, boolean allowFileSeparator) {
        if (!$assertionsDisabled && newObjectName == null) {
            throw new AssertionError();
        }
        boolean allowSlash = false;
        boolean allowBackslash = false;
        int errorVariant = 0;
        if (allowFileSeparator) {
            if (File.separatorChar == '\\') {
                errorVariant = 3;
                allowBackslash = true;
                allowSlash = true;
            } else {
                errorVariant = 1;
                allowSlash = true;
            }
        }
        if (!allowSlash && newObjectName.indexOf(47) != -1 || !allowBackslash && newObjectName.indexOf(92) != -1) {
            if (!$assertionsDisabled && errorVariant != 0 && errorVariant != 1) {
                throw new AssertionError((Object)("Invalid error variant: " + errorVariant));
            }
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_not_valid_filename", (Object)newObjectName, (Object)new Integer(errorVariant));
        }
        if (targetFolder == null) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_fs_is_readonly");
        }
        StringBuffer relFileName = new StringBuffer();
        if (folderName != null) {
            if (!allowBackslash && folderName.indexOf(92) != -1) {
                return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_not_valid_folder", (Object)folderName, (Object)new Integer(1));
            }
            relFileName.append(folderName);
            relFileName.append('/');
        }
        relFileName.append(newObjectName);
        if (extension != null) {
            relFileName.append('.');
            relFileName.append(extension);
        }
        if (targetFolder.getFileObject(relFileName.toString()) != null) {
            return NbBundle.getMessage((Class)ProjectUtilities.class, (String)"MSG_file_already_exist", (Object)newObjectName);
        }
        return null;
    }

    public static boolean closeAllDocuments(Project[] projects) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects are specified.");
        }
        if (projects.length == 0) {
            return true;
        }
        Map urls4project = OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.close(projects);
        if (urls4project != null) {
            Iterator loop = urls4project.keySet().iterator();
            while (loop.hasNext()) {
                Project p = (Project)loop.next();
                ProjectUtilities.storeProjectOpenFiles(p, (SortedSet)urls4project.get(p));
            }
        }
        return urls4project != null;
    }

    private static void storeProjectOpenFiles(Project p, SortedSet urls) {
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
        if (aux != null) {
            aux.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
            Document xml = XMLUtil.createDocument((String)OPEN_FILES_ELEMENT, (String)OPEN_FILES_NS, null, null);
            Element openFiles = xml.createElementNS(OPEN_FILES_NS, OPEN_FILES_ELEMENT);
            Iterator it = urls.iterator();
            while (it.hasNext()) {
                Element fileEl = openFiles.getOwnerDocument().createElement(FILE_ELEMENT);
                fileEl.appendChild(fileEl.getOwnerDocument().createTextNode((String)it.next()));
                openFiles.appendChild(fileEl);
            }
            aux.putConfigurationFragment(openFiles, false);
        }
    }

    public static void openProjectFiles(Project p) {
        AuxiliaryConfiguration aux;
        boolean dolog = ERR.isLoggable(1);
        if (dolog) {
            ERR.log("Trying to open files from " + p + "...");
        }
        if ((aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class)) == null) {
            if (dolog) {
                ERR.log("No AuxiliaryConfiguration in " + p);
            }
            return;
        }
        Element openFiles = aux.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
        if (openFiles == null) {
            if (dolog) {
                ERR.log("No open-files in private.xml");
            }
            return;
        }
        NodeList list = openFiles.getElementsByTagName(FILE_ELEMENT);
        if (list == null) {
            if (dolog) {
                ERR.log("No file in open-files");
            }
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            FileObject fo;
            String url = list.item(i).getChildNodes().item(0).getNodeValue();
            if (dolog) {
                ERR.log("Will try to open " + url);
            }
            try {
                fo = URLMapper.findFileObject((URL)new URL(url));
            }
            catch (MalformedURLException mue) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("MalformedURLException in " + url));
                }
                continue;
            }
            if (fo == null) {
                if (!dolog) continue;
                ERR.log("Could not find " + url);
                continue;
            }
            OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.open(fo);
        }
        aux.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
    }

    static {
        $assertionsDisabled = !ProjectUtilities.class.desiredAssertionStatus();
        OPEN_CLOSE_PROJECT_DOCUMENT_IMPL = new OpenCloseProjectDocument(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean open(FileObject fo) {
                DataObject dobj;
                try {
                    dobj = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException donfo) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("DataObject must exist for " + fo));
                    }
                    return false;
                }
                EditCookie ec = (EditCookie)dobj.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = ProjectUtilities.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                OpenCookie oc = (OpenCookie)dobj.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ProjectUtilities.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (ec != null) {
                    ec.edit();
                } else if (oc != null) {
                    oc.open();
                } else {
                    if (ERR.isLoggable(1)) {
                        ERR.log("No EditCookie nor OpenCookie for " + dobj);
                    }
                    return false;
                }
                return true;
            }

            public Map close(Project[] projects) {
                List<Project> listOfProjects = Arrays.asList(projects);
                HashSet<DataObject> openFiles = new HashSet<DataObject>();
                HashSet<TopComponent> tc2close = new HashSet<TopComponent>();
                HashMap urls4project = new HashMap();
                Iterator openTCs = WindowManager.getDefault().getRegistry().getOpened().iterator();
                while (openTCs.hasNext()) {
                    FileObject fobj;
                    Project owner;
                    DataObject dobj;
                    Mode m;
                    TopComponent tc = (TopComponent)openTCs.next();
                    if (tc instanceof ExplorerManager.Provider || (m = WindowManager.getDefault().findMode(tc)) == null || !"editor".equals(m.getName()) || (dobj = (DataObject)tc.getLookup().lookup(class$org$openide$loaders$DataObject == null ? ProjectUtilities.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null || !listOfProjects.contains(owner = FileOwnerQuery.getOwner((FileObject)(fobj = dobj.getPrimaryFile())))) continue;
                    openFiles.add(dobj);
                    tc2close.add(tc);
                    if (!urls4project.containsKey(owner)) {
                        urls4project.put(owner, new TreeSet());
                    }
                    URL url = null;
                    try {
                        url = dobj.getPrimaryFile().getURL();
                        ((SortedSet)urls4project.get(owner)).add(url.toExternalForm());
                    }
                    catch (FileStateInvalidException fsie) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("FileStateInvalidException in " + dobj.getPrimaryFile()));
                        }
                    }
                }
                Iterator iter = DataObject.getRegistry().getModifiedSet().iterator();
                while (iter.hasNext()) {
                    FileObject fobj;
                    Project owner;
                    DataObject dobj = (DataObject)iter.next();
                    if (dobj == null || !listOfProjects.contains(owner = FileOwnerQuery.getOwner((FileObject)(fobj = dobj.getPrimaryFile()))) || openFiles.contains(dobj)) continue;
                    openFiles.add(dobj);
                }
                if (!openFiles.isEmpty() && ExitDialog.showDialog(openFiles)) {
                    Iterator it = tc2close.iterator();
                    while (it.hasNext()) {
                        ((TopComponent)it.next()).close();
                    }
                } else if (!openFiles.isEmpty()) {
                    urls4project = null;
                }
                return urls4project;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$project$ui$ProjectUtilities == null ? (class$org$netbeans$modules$project$ui$ProjectUtilities = ProjectUtilities.class$("org.netbeans.modules.project.ui.ProjectUtilities")) : class$org$netbeans$modules$project$ui$ProjectUtilities).desiredAssertionStatus();
            }
        };
        ERR = ErrorManager.getDefault().getInstance(ProjectUtilities.class.getName());
    }

    static interface OpenCloseProjectDocument {
        public boolean open(FileObject var1);

        public Map close(Project[] var1);
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            if (SwingUtilities.isEventDispatchThread()) {
                wc.run();
            } else {
                SwingUtilities.invokeLater(wc);
            }
        }

        public void run() {
            try {
                JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
                Component c = f.getGlassPane();
                c.setVisible(this.show);
                c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                ErrorManager.getDefault().notify(1, (Throwable)npe);
            }
        }
    }
}

