/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.config.WSDLModelInfo;
import com.sun.tools.ws.processor.config.parser.CustomizationParser;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.processor.util.ClientProcessorEnvironment;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.xml.sax.EntityResolver;

public class WsdlModeler {
    private WsdlModel wsdlModel;
    private WSDLModeler ideWSDLModeler;
    private URL wsdlUrl;
    private URL[] bindings;
    private URL catalog;
    private EntityResolver entityResolver;
    private Set<String> bindingFiles;
    private String packageName;
    private List modelListeners;
    RequestProcessor.Task task;
    int listenersSize;
    protected Properties properties;
    protected ProcessorEnvironment environment;
    protected Configuration configuration;
    private Throwable creationException;

    WsdlModeler(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        this.modelListeners = new ArrayList();
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WsdlModeler.this.generateWsdlModel();
                1 var1_1 = this;
                synchronized (var1_1) {
                    WsdlModeler.this.listenersSize = WsdlModeler.this.modelListeners.size();
                    WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel, WsdlModeler.this.listenersSize);
                }
            }
        }, true);
        this.task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    int size = WsdlModeler.this.modelListeners.size();
                    if (size > 0) {
                        if (size == WsdlModeler.this.listenersSize) {
                            WsdlModeler.this.removeListeners();
                        } else {
                            for (int i = WsdlModeler.this.listenersSize - 1; i >= 0; --i) {
                                WsdlModeler.this.modelListeners.remove(i);
                            }
                            ((RequestProcessor.Task)task).schedule(0);
                        }
                    }
                }
            }
        });
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setJAXBBindings(URL[] bindings) {
        this.bindings = bindings;
    }

    public URL[] getJAXBBindings() {
        return this.bindings;
    }

    public void setCatalog(URL catalog) {
        this.catalog = catalog;
    }

    public URL getCatalog() {
        return this.catalog;
    }

    void setWsdlUrl(URL url) {
        this.wsdlUrl = url;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public WsdlModel getAndWaitForWsdlModel() {
        if (this.getWsdlModel() == null) {
            this.generateWsdlModel();
        }
        return this.wsdlModel;
    }

    public void generateWsdlModel(WsdlModelListener listener) {
        this.generateWsdlModel(listener, false);
    }

    public void generateWsdlModel(WsdlModelListener listener, boolean forceReload) {
        if (forceReload) {
            try {
                this.task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addWsdlModelListener(listener);
            this.task.schedule(0);
        } else {
            this.addWsdlModelListener(listener);
            if (this.task.isFinished()) {
                this.task.schedule(0);
            }
        }
    }

    private synchronized void generateWsdlModel() {
        this.properties = new Properties();
        this.bindingFiles = new HashSet<String>();
        if (this.bindings != null) {
            for (int i = 0; i < this.bindings.length; ++i) {
                this.bindingFiles.add(JAXWSUtils.absolutize((String)this.bindings[i].toExternalForm()));
            }
        }
        this.properties.put("bindingFiles", this.bindingFiles);
        this.properties.put("validationWSDL", (Object)true);
        this.properties.put("useWSIBasicProfile", (Object)false);
        this.properties.setProperty("extension", "true");
        try {
            this.environment = this.createEnvironment();
            this.configuration = this.createConfiguration();
            if (this.packageName != null) {
                this.properties.setProperty("defaultpackage", this.packageName);
                this.configuration.getModelInfo().setDefaultJavaPackage(this.packageName);
            }
            if (this.catalog != null) {
                CatalogManager manager = new CatalogManager(null);
                manager.setCatalogFiles(this.catalog.toExternalForm());
                this.entityResolver = new CatalogResolver(manager);
                this.configuration.getModelInfo().setEntityResolver(this.entityResolver);
            }
            this.ideWSDLModeler = new WSDLModeler((WSDLModelInfo)this.configuration.getModelInfo(), this.properties);
            Model tmpModel = this.ideWSDLModeler.buildModel();
            if (tmpModel != null) {
                this.wsdlModel = new WsdlModel(tmpModel);
                this.creationException = null;
            }
        }
        catch (Exception ex) {
            this.wsdlModel = null;
            this.creationException = ex;
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private synchronized void addWsdlModelListener(WsdlModelListener listener) {
        if (listener != null) {
            this.modelListeners.add(listener);
        }
    }

    private void removeListeners() {
        this.modelListeners.clear();
    }

    private void fireModelCreated(WsdlModel model, int listenersSize) {
        for (int i = 0; i < listenersSize; ++i) {
            ((WsdlModelListener)this.modelListeners.get(i)).modelCreated(model);
        }
    }

    protected Configuration createConfiguration() throws Exception {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        ArrayList<String> inputFiles = new ArrayList<String>();
        inputFiles.add(JAXWSUtils.absolutize((String)this.wsdlUrl.toExternalForm()));
        IdeCustomizationParser parser = new IdeCustomizationParser(this.entityResolver, this.environment, this.properties);
        return parser.parse(inputFiles);
    }

    private ProcessorEnvironment createEnvironment() throws Exception {
        ClientProcessorEnvironment env = new ClientProcessorEnvironment((OutputStream)System.out, null, null);
        return env;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IdeCustomizationParser
    extends CustomizationParser {
        public IdeCustomizationParser(EntityResolver entityResolver, ProcessorEnvironment env, Properties options) {
            super(entityResolver, env, options);
        }

        protected Configuration parse(List<String> inputFiles) throws Exception {
            return super.parse(inputFiles);
        }
    }
}

