/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlOperation {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_ASYNC_POLLING = 1;
    public static final int TYPE_ASYNC_CALLBACK = 2;
    private Operation operation;

    public WsdlOperation(Operation operation) {
        this.operation = operation;
    }

    public Object getInternalJAXWSOperation() {
        return this.operation;
    }

    public String getName() {
        String operationName = this.operation.getName().getLocalPart();
        String postfix = null;
        switch (this.getOperationType()) {
            case 0: {
                break;
            }
            case 1: {
                postfix = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_asyncPolling");
                break;
            }
            case 2: {
                postfix = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_asyncCallback");
            }
        }
        if (postfix != null) {
            operationName = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_operationName", (Object)operationName, (Object)postfix);
        }
        return operationName;
    }

    public String getJavaName() {
        return this.operation.getJavaMethod().getName();
    }

    public String getReturnTypeName() {
        return this.operation.getJavaMethod().getReturnType().getName();
    }

    public List<WsdlParameter> getParameters() {
        ArrayList<WsdlParameter> wsdlParameters = new ArrayList<WsdlParameter>();
        if (this.operation == null) {
            return wsdlParameters;
        }
        List parameterList = this.operation.getJavaMethod().getParametersList();
        for (JavaParameter param : parameterList) {
            wsdlParameters.add(new WsdlParameter(param));
        }
        return wsdlParameters;
    }

    public List<String> getExceptions() {
        return this.operation.getJavaMethod().getExceptionsList();
    }

    public int getOperationType() {
        String returnType = this.getReturnTypeName();
        if (returnType.startsWith("javax.xml.ws.Response")) {
            return 1;
        }
        if (returnType.startsWith("java.util.concurrent.Future")) {
            return 2;
        }
        return 0;
    }
}

