/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.websvc.core.client.wizard.WebProxySetter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ProxySettingsDlg
extends JPanel {
    private String detectedProxy = null;
    private boolean isDetectedProxy = true;
    private JRadioButton autoDetectProxy;
    private JRadioButton directConnection;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JRadioButton manualProxy;
    private JPanel manualSettingsPanel;
    private JLabel portLabel;
    private JTextField portTextField;
    private ButtonGroup proxyChoiceButtons;

    public ProxySettingsDlg() {
        String fromSystem = System.getProperty("netbeans.system_http_proxy");
        this.isDetectedProxy = fromSystem != null;
        this.detectedProxy = this.isDetectedProxy ? fromSystem : "";
        this.initComponents();
        this.hostTextField.setText(WebProxySetter.getInstance().getProxyHost());
        this.portTextField.setText(WebProxySetter.getInstance().getProxyPort());
        this.setProxyType(WebProxySetter.getInstance().getProxyType());
        this.getAccessibleContext().setAccessibleDescription(ProxySettingsDlg.getBundle("CTL_ProxySettingsDlg_Title"));
        this.getAccessibleContext().setAccessibleDescription(ProxySettingsDlg.getBundle("ACS_ProxySettingsDlg"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(ProxySettingsDlg.getBundle("ACS_ProxySettingsDlg.hostTextField"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(ProxySettingsDlg.getBundle("ACS_ProxySettingsDlg.portTextField"));
    }

    private void initComponents() {
        this.proxyChoiceButtons = new ButtonGroup();
        this.directConnection = new JRadioButton();
        this.autoDetectProxy = new JRadioButton();
        this.manualProxy = new JRadioButton();
        this.manualSettingsPanel = new JPanel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.hostTextField = new JTextField();
        this.proxyChoiceButtons.add(this.directConnection);
        if (this.isDetectedProxy) {
            this.proxyChoiceButtons.add(this.autoDetectProxy);
        }
        this.proxyChoiceButtons.add(this.manualProxy);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        Mnemonics.setLocalizedText((AbstractButton)this.directConnection, (String)NbBundle.getBundle(ProxySettingsDlg.class).getString("BTN_directConnection"));
        this.directConnection.setToolTipText(NbBundle.getBundle(ProxySettingsDlg.class).getString("TT_ProxySettingsDlg_directConnection"));
        this.directConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxySettingsDlg.this.directConnectionActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.directConnection, gridBagConstraints);
        this.directConnection.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProxySettingsDlg.class).getString("ACD_directConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoDetectProxy, (String)NbBundle.getBundle(ProxySettingsDlg.class).getString("BTN_autoDetectProxy"));
        this.autoDetectProxy.setToolTipText(NbBundle.getMessage(ProxySettingsDlg.class, (String)"TT_ProxySettingsDlg_autoDetectProxy", (Object[])new Object[]{this.isDetectedProxy ? this.detectedProxy : NbBundle.getMessage(ProxySettingsDlg.class, (String)"MSG_ProxySettingsDlg_ProxyNotFound")}));
        this.autoDetectProxy.setEnabled(this.isDetectedProxy);
        this.autoDetectProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxySettingsDlg.this.autoDetectProxyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.autoDetectProxy, gridBagConstraints);
        this.autoDetectProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProxySettingsDlg.class).getString("ACD_autoDetectProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.manualProxy, (String)NbBundle.getBundle(ProxySettingsDlg.class).getString("BTN_manualProxy"));
        this.manualProxy.setToolTipText(NbBundle.getBundle(ProxySettingsDlg.class).getString("TT_ProxySettingsDlg_manualProxy"));
        this.manualProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxySettingsDlg.this.manualProxyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.manualProxy, gridBagConstraints);
        this.manualProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProxySettingsDlg.class).getString("ACD_manualProxy"));
        this.manualSettingsPanel.setLayout(new GridBagLayout());
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)ProxySettingsDlg.getBundle("ProxySettingsDlg.hostLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.manualSettingsPanel.add((Component)this.hostLabel, gridBagConstraints);
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProxySettingsDlg.class).getString("ACD_ProxySettingsDlg_hostLabel"));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)ProxySettingsDlg.getBundle("ProxySettingsDlg.portLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.manualSettingsPanel.add((Component)this.portLabel, gridBagConstraints);
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ProxySettingsDlg.class).getString("ACD_ProxySettingsDlg_portLabel"));
        this.portTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ProxySettingsDlg.this.portTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ProxySettingsDlg.this.portTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.manualSettingsPanel.add((Component)this.portTextField, gridBagConstraints);
        this.hostTextField.setColumns(30);
        this.hostTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxySettingsDlg.this.hostTextFieldActionPerformed(evt);
            }
        });
        this.hostTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ProxySettingsDlg.this.hostTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                ProxySettingsDlg.this.hostTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        this.manualSettingsPanel.add((Component)this.hostTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 28, 10, 24);
        this.add((Component)this.manualSettingsPanel, gridBagConstraints);
    }

    private void hostTextFieldActionPerformed(ActionEvent evt) {
    }

    private void portTextFieldFocusLost(FocusEvent evt) {
        this.portTextField.select(0, 0);
    }

    private void portTextFieldFocusGained(FocusEvent evt) {
        this.portTextField.selectAll();
    }

    private void hostTextFieldFocusLost(FocusEvent evt) {
        this.hostTextField.select(0, 0);
    }

    private void hostTextFieldFocusGained(FocusEvent evt) {
        this.hostTextField.selectAll();
    }

    private void manualProxyActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(2);
            this.hostTextField.requestFocus();
        }
    }

    private void autoDetectProxyActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(1);
        }
    }

    private void directConnectionActionPerformed(ActionEvent evt) {
        if (((JRadioButton)evt.getSource()).isSelected()) {
            this.setProxyType(0);
        }
    }

    private void setProxyType(int proxyType) {
        switch (proxyType) {
            case 0: {
                this.directConnection.setSelected(true);
                this.manualSettingsPanel.setEnabled(false);
                this.hostTextField.setEnabled(false);
                this.portTextField.setEnabled(false);
                this.hostLabel.setEnabled(false);
                this.portLabel.setEnabled(false);
                break;
            }
            case 1: {
                this.autoDetectProxy.setSelected(true);
                this.manualSettingsPanel.setEnabled(false);
                this.hostTextField.setEnabled(false);
                this.portTextField.setEnabled(false);
                this.hostLabel.setEnabled(false);
                this.portLabel.setEnabled(false);
                break;
            }
            case 2: {
                this.manualProxy.setSelected(true);
                this.manualSettingsPanel.setEnabled(true);
                this.hostTextField.setEnabled(true);
                this.portTextField.setEnabled(true);
                this.hostLabel.setEnabled(true);
                this.portLabel.setEnabled(true);
                break;
            }
            default: {
                assert (false) : "Unknown proxy type: " + proxyType;
                break;
            }
        }
    }

    static boolean showDialog() {
        boolean result = false;
        ProxySettingsDlg proxyPanel = new ProxySettingsDlg();
        DialogDescriptor dd = new DialogDescriptor((Object)proxyPanel, ProxySettingsDlg.getBundle("CTL_ProxySettingsDlg_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            WebProxySetter.getInstance().setProxyConfiguration(proxyPanel.getProxyType(), proxyPanel.getUserProxyHost(), proxyPanel.getUserProxyPort());
            result = true;
        }
        return result;
    }

    String getUserProxyHost() {
        return this.hostTextField.getText();
    }

    String getUserProxyPort() {
        return this.portTextField.getText();
    }

    int getProxyType() {
        if (this.directConnection.isSelected()) {
            return 0;
        }
        if (this.autoDetectProxy.isSelected()) {
            return 1;
        }
        if (this.manualProxy.isSelected()) {
            return 2;
        }
        assert (false) : "Any button must be selected";
        return 1;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(ProxySettingsDlg.class, (String)key);
    }
}

