/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.ext.java.JavaFastOpen;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FQNSearch
extends JavaFastOpen {
    private JTextComponent textComponent;
    private JavaClass parent;

    private FQNSearch(JTextComponent textComponent) {
        this.textComponent = textComponent;
    }

    private FQNSearch(JTextComponent textComponent, JavaClass parent) {
        this.textComponent = textComponent;
        this.parent = parent;
    }

    protected List findClasses(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        return FQNSearch.findAllClasses(exp, true, caseSensitive, includeInnerClasses, includeLibraryClasses, this.parent);
    }

    public static void showFastOpen(JTextComponent textComponent) {
        String initSearchText = textComponent.getText();
        if (!Utilities.isJavaIdentifier((String)initSearchText)) {
            initSearchText = null;
        }
        if (fastOpen == null) {
            fastOpen = new FQNSearch(textComponent);
        }
        if (initSearchText != null) {
            fastOpen.setSearchText(initSearchText);
        }
        fastOpen.setDialogVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.getButtons()[0] || src == this.getPanel()) {
            this.setCaseSensitive(this.caseSensitive);
            this.setIncludeInnerClasses(this.includeInnerClasses);
            this.setIncludeLibraryClasses(this.includeLibraryClasses);
            this.setDialogVisible(false);
            final int selIndex = this.getResultList().getSelectedIndex();
            if (selIndex >= 0) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaClass cls;
                        Object item = FQNSearch.this.getResultList().getModel().getElementAt(selIndex);
                        JavaClass javaClass = cls = item instanceof ResultItemImpl ? (JavaClass)((ResultItemImpl)((Object)item)).getAssociatedObject() : null;
                        if (cls != null) {
                            Mutex.EVENT.writeAccess(new Runnable(){

                                public void run() {
                                    FQNSearch.this.textComponent.setText(cls.getName());
                                }
                            });
                        }
                    }
                });
            }
        } else {
            super.actionPerformed(evt);
        }
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions((Class)kitClass);
            bop.setSettingValue("goto-class-case-sensitive", (Object)(caseSensitive ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions((Class)kitClass);
            bop.setSettingValue("goto-class-show-inner-classes", (Object)(includeInnerClasses ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
        Class kitClass = this.getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions((Class)kitClass);
            bop.setSettingValue("goto-class-show-library-classes", (Object)(includeLibraryClasses ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List findAllClasses(String exp, boolean createResultItems, boolean caseSensitive, boolean findInnerClasses, boolean findLibraryClasses, JavaClass parent) {
        ArrayList<ResultItemImpl> ret = new ArrayList<ResultItemImpl>();
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            List<FileObject> cpRoots = Arrays.asList(JavaMetamodel.getManager().getClassPath().getRoots());
            ArrayList classes = new ArrayList();
            for (FileObject cpRoot : cpRoots) {
                ClassIndex ci;
                if (!findLibraryClasses && FileOwnerQuery.getOwner((FileObject)cpRoot) == null || (ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoot))) == null) continue;
                classes.addAll(ci.getClassesBySNPrefix(exp, caseSensitive));
            }
            if (!createResultItems) {
                Iterator it = classes;
                return it;
            }
            for (JavaClass cls : classes) {
                if (!findInnerClasses && cls.isInner() || parent != null && (parent == null || !cls.isSubTypeOf((ClassDefinition)parent))) continue;
                ret.add(new ResultItemImpl(cls, true, false, false));
            }
            Collections.sort(ret, JMIUtils.getNaturalMemberNameComparator());
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return ret;
    }

    protected Dialog createDialog() {
        String title = NbBundle.getMessage(FQNSearch.class, (String)"LBL_FQN_Title");
        this.getButtons()[0].setText(NbBundle.getMessage(FQNSearch.class, (String)"LBL_FQN_OK"));
        Dialog dialog = DialogSupport.createDialog((String)title, (JPanel)this.getPanel(), (boolean)true, (JButton[])this.getButtons(), (boolean)false, (int)0, (int)1, (ActionListener)((Object)this));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FQNSearch.this.setDialogVisible(false);
            }

            public void windowClosed(WindowEvent evt) {
            }
        });
        return dialog;
    }

    private static class ResultItemImpl
    extends NbJMIResultItem.ClassResultItem {
        private JavaClass cls;

        public ResultItemImpl(JavaClass cls, boolean displayFQN, boolean addImport, boolean generateClassSkeleton) {
            super(cls, displayFQN, addImport, generateClassSkeleton);
            this.cls = cls;
        }

        protected Object getAssociatedObject() {
            return this.cls;
        }
    }
}

