/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3g;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.jdbc3.AbstractJdbc3ResultSet;
import org.postgresql.jdbc3g.Jdbc3gArray;
import org.postgresql.jdbc3g.Jdbc3gBlob;
import org.postgresql.jdbc3g.Jdbc3gClob;
import org.postgresql.jdbc3g.Jdbc3gResultSetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdbc3gResultSet
extends AbstractJdbc3ResultSet
implements ResultSet {
    Jdbc3gResultSet(Query originalQuery, BaseStatement statement, Field[] fields, Vector tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(originalQuery, statement, fields, tuples, cursor, maxRows, maxFieldSize, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new Jdbc3gResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc3gClob(this.connection, this.getLong(i));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new Jdbc3gBlob(this.connection, this.getLong(i));
    }

    @Override
    public Array createArray(int i) throws SQLException {
        this.checkResultSet(i);
        return new Jdbc3gArray(this.connection, i, this.fields[i - 1], this);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }
}

