'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.8/tcllib-1.8/modules/asn/asn.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\" Copyright (c) 2004 Jochen Loewer <loewerj@web.de>
'\" Copyright (c) 2004,2005 Michael Schlenker <mic42@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "asn" n 0.4 asn "ASN.1 processing"
.BS
.SH "NAME"
asn \- ASN.1 BER encoder/decoder
.SH "SYNOPSIS"
package require \fBTcl  8.4\fR
.sp
package require \fBasn  ?0.4?\fR
.sp
\fB::asn::asnSequence\fR \fIevalue\fR...
.sp
\fB::asn::asnSet\fR \fIevalue\fR...
.sp
\fB::asn::asnApplicationConstr\fR \fIappNumber\fR \fIevalue\fR...
.sp
\fB::asn::asnApplication\fR \fIappNumber\fR \fIdata\fR
.sp
\fB::asn::asnChoice\fR \fIappNumber\fR \fIevalue\fR...
.sp
\fB::asn::asnChoiceConstr\fR \fIappNumber\fR \fIevalue\fR...
.sp
\fB::asn::asnInteger\fR \fInumber\fR
.sp
\fB::asn::asnEnumeration\fR \fInumber\fR
.sp
\fB::asn::asnBoolean\fR \fIbool\fR
.sp
\fB::asn::asnOctetString\fR \fIstring\fR
.sp
\fB::asn::asnGetResponse\fR \fIchan\fR \fIdata_var\fR
.sp
\fB::asn::asnGetInteger\fR \fIdata_var\fR \fIint_var\fR
.sp
\fB::asn::asnGetEnumeration\fR \fIdata_var\fR \fIenum_var\fR
.sp
\fB::asn::asnGetOctetString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetPrintableString\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetIA5String\fR \fIdata_var\fR \fIstring_var\fR
.sp
\fB::asn::asnGetUTCTime\fR \fIdata_var\fR \fIutc_var\fR
.sp
\fB::asn::asnGetBitString\fR \fIdata_var\fR \fIbits_var\fR
.sp
\fB::asn::asnGetObjectIdentifier\fR \fIdata_var\fR \fIoid_var\fR
.sp
\fB::asn::asnGetBoolean\fR \fIdata_var\fR \fIbool_var\fR
.sp
\fB::asn::asnGetNull\fR \fIdata_var\fR
.sp
\fB::asn::asnGetSequence\fR \fIdata_var\fR \fIsequence_var\fR
.sp
\fB::asn::asnGetSet\fR \fIdata_var\fR \fIset_var\fR
.sp
\fB::asn::asnGetApplication\fR \fIdata_var\fR \fIappNumber_var\fR
.sp
\fB::asn::asnGetContext\fR \fIdata_var\fR \fIcontextNumber_var\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBasn\fR package provides \fIpartial\fR de- and encoder
commands for BER encoded ASN.1 data.
.PP
ASN.1 is a standard \fIAbstract Syntax Notation\fR, and BER are its
\fIBasic Encoding Rules\fR.
.PP
See \fIhttp://asn1.elibel.tm.fr/en/standards/index.htm\fR for more
information about the standard.
.PP
Also see \fIhttp://luca.ntop.org/Teaching/Appunti/asn1.html\fR for
\fIA Layman's Guide to a Subset of ASN.1, BER, and DER\fR, an RSA
Laboratories Technical Note by Burton S. Kaliski Jr. (Revised November
1, 1993). A text version of this note is part of the module sources
and should be read by any implementor.
.SH "PUBLIC API"
.SS "ENCODER"
.TP
\fB::asn::asnSequence\fR \fIevalue\fR...
Takes zero or more encoded values, packs them into an ASN sequence and
returns its encoded binary form.
.TP
\fB::asn::asnSet\fR \fIevalue\fR...
Takes zero or more encoded values, packs them into an ASN set and
returns its encoded binary form.
.TP
\fB::asn::asnApplicationConstr\fR \fIappNumber\fR \fIevalue\fR...
Takes zero or more encoded values, packs them into an ASN application
construct and returns its encoded binary form.
.TP
\fB::asn::asnApplication\fR \fIappNumber\fR \fIdata\fR
Takes a single encoded value \fIdata\fR, packs it into an ASN
application construct and returns its encoded binary form.
.TP
\fB::asn::asnChoice\fR \fIappNumber\fR \fIevalue\fR...
Takes zero or more encoded values, packs them into an ASN choice
construct and returns its encoded binary form.
.TP
\fB::asn::asnChoiceConstr\fR \fIappNumber\fR \fIevalue\fR...
Takes zero or more encoded values, packs them into an ASN choice
construct and returns its encoded binary form.
.TP
\fB::asn::asnInteger\fR \fInumber\fR
Returns the encoded form of the specified integer
\fInumber\fR.
.TP
\fB::asn::asnEnumeration\fR \fInumber\fR
Returns the encoded form of the specified enumeration id
\fInumber\fR.
.TP
\fB::asn::asnBoolean\fR \fIbool\fR
Returns the encoded form of the specified boolean value
\fIbool\fR.
.TP
\fB::asn::asnOctetString\fR \fIstring\fR
Returns the encoded form of the specified \fIstring\fR.
.PP
.SS "DECODER"
General notes:
.IP [1]
All decoder commands take two arguments. These arguments are variable
names, except for \fB::asn::asnGetResponse\fR. The first variable
contains the encoded ASN value to decode at the beginning, and more,
and the second variable is where the value is stored to. The remainder
of the input after the decoded value is stored back into the
datavariable.
.IP [2]
After extraction the data variable is always modified first, before by
writing the extracted value to its variable. This means that if both
arguments refer to the same variable, it will always contain the
extracted value after the call, and not the remainder of the input.
.PP
.TP
\fB::asn::asnGetResponse\fR \fIchan\fR \fIdata_var\fR
Reads an encoded ASN \fIsequence\fR from the channel \fIchan\fR and
stores it into the variable named by \fIdata_var\fR.
.TP
\fB::asn::asnGetInteger\fR \fIdata_var\fR \fIint_var\fR
Assumes that an encoded integer value is at the front of the data
stored in the variable named \fIdata_var\fR, extracts and stores it
into the variable named by \fIint_var\fR. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands.
.TP
\fB::asn::asnGetEnumeration\fR \fIdata_var\fR \fIenum_var\fR
Assumes that an enumeration id is at the front of the data stored in
the variable named \fIdata_var\fR, and stores it into the variable
named by \fIenum_var\fR. Additionally removes all bytes associated
with the value from the data for further processing by the following
decoder commands.
.TP
\fB::asn::asnGetOctetString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a string is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIstring_var\fR. Additionally removes all bytes associated with
the value from the data for further processing by the following
decoder commands.
.TP
\fB::asn::asnGetPrintableString\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a printable string value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIstring_var\fR. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetIA5String\fR \fIdata_var\fR \fIstring_var\fR
Assumes that a IA5 (ASCII) string value is at the front of the data stored
in the variable named \fIdata_var\fR, and stores it into the variable named
by \fIstring_var\fR. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetUTCTime\fR \fIdata_var\fR \fIutc_var\fR
Assumes that a UTC time value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIutc_var\fR. The UTC time value is stored as a string, which has to
be decoded with the usual clock scan commands.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetBitString\fR \fIdata_var\fR \fIbits_var\fR
Assumes that a bit string value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIbits_var\fR as a string containing only 0 and 1.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetObjectIdentifier\fR \fIdata_var\fR \fIoid_var\fR
Assumes that a object identifier (OID) value is at the front of the data
stored in the variable named \fIdata_var\fR, and stores it into the variable
named by \fIoid_var\fR as a list of integers.
Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetBoolean\fR \fIdata_var\fR \fIbool_var\fR
Assumes that a boolean value is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIbool_var\fR. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.TP
\fB::asn::asnGetNull\fR \fIdata_var\fR
Assumes that a NULL value is at the front of the data stored in the
variable named \fIdata_var\fR and removes the bytes used to encode it
from the data.
.TP
\fB::asn::asnGetSequence\fR \fIdata_var\fR \fIsequence_var\fR
Assumes that an ASN sequence is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIsequence_var\fR. Additionally removes all bytes associated with
the value from the data for further processing by the following
decoder commands.
.sp
The data in \fIsequence_var\fR is encoded binary and has to be
further decoded according to the definition of the sequence, using the
decoder commands here.
.TP
\fB::asn::asnGetSet\fR \fIdata_var\fR \fIset_var\fR
Assumes that an ASN set is at the front of the data stored in the
variable named \fIdata_var\fR, and stores it into the variable named
by \fIset_var\fR. Additionally removes all bytes associated with the
value from the data for further processing by the following decoder
commands.
.sp
The data in \fIset_var\fR is encoded binary and has to be further
decoded according to the definition of the set, using the decoder
commands here.
.TP
\fB::asn::asnGetApplication\fR \fIdata_var\fR \fIappNumber_var\fR
Assumes that an ASN application construct is at the front of the data
stored in the variable named \fIdata_var\fR, and stores its id into
the variable named by \fIappNumber_var\fR. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands.
.sp
It is the responsibility of the caller to decode the remainder of the
application construct based on the id retrieved by this command, using
the decoder commands here.
.TP
\fB::asn::asnGetContext\fR \fIdata_var\fR \fIcontextNumber_var\fR
Assumes that an ASN context tag construct is at the front of the data
stored in the variable named \fIdata_var\fR, and stores its id into
the variable named by \fIcontextNumber_var\fR. Additionally removes all
bytes associated with the value from the data for further processing
by the following decoder commands.
.sp
It is the responsibility of the caller to decode the remainder of the
construct based on the id retrieved by this command, using
the decoder commands here.
.PP
.SH "EXAMPLES"
Examples for the usage of this package can be found in the
implementation of package \fBldap\fR.
.SH "KEYWORDS"
asn, ber, cer, der, internet, protocol, x.208, x.209
.SH "COPYRIGHT"
.nf
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
Copyright (c) 2004 Jochen Loewer <loewerj@web.de>
Copyright (c) 2004,2005 Michael Schlenker <mic42@users.sourceforge.net>

.fi