#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * TpSvcChannel:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannel TpSvcChannel;

/**
 * TpSvcChannelClass:
 *
 * The class of TpSvcChannel.
 */
typedef struct _TpSvcChannelClass TpSvcChannelClass;

GType tp_svc_channel_get_type (void);
#define TP_TYPE_SVC_CHANNEL \
  (tp_svc_channel_get_type ())
#define TP_SVC_CHANNEL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL, TpSvcChannel))
#define TP_IS_SVC_CHANNEL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL))
#define TP_SVC_CHANNEL_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL, TpSvcChannelClass))


typedef void (*tp_svc_channel_close_impl) (TpSvcChannel *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_implement_close (TpSvcChannelClass *klass, tp_svc_channel_close_impl impl);
/**
 * tp_svc_channel_return_from_close:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_return_from_close (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_return_from_close (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_get_channel_type_impl) (TpSvcChannel *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_implement_get_channel_type (TpSvcChannelClass *klass, tp_svc_channel_get_channel_type_impl impl);
/**
 * tp_svc_channel_return_from_get_channel_type:
 * @context: The D-Bus method invocation context
 * @out0: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_return_from_get_channel_type (DBusGMethodInvocation *context,
    const gchar *out0);
static inline void
tp_svc_channel_return_from_get_channel_type (DBusGMethodInvocation *context,
    const gchar *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_get_handle_impl) (TpSvcChannel *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_implement_get_handle (TpSvcChannelClass *klass, tp_svc_channel_get_handle_impl impl);
/**
 * tp_svc_channel_return_from_get_handle:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 * @out1: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_return_from_get_handle (DBusGMethodInvocation *context,
    guint out0,
    guint out1);
static inline void
tp_svc_channel_return_from_get_handle (DBusGMethodInvocation *context,
    guint out0,
    guint out1)
{
  dbus_g_method_return (context,
      out0,
      out1);
}

typedef void (*tp_svc_channel_get_interfaces_impl) (TpSvcChannel *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_implement_get_interfaces (TpSvcChannelClass *klass, tp_svc_channel_get_interfaces_impl impl);
/**
 * tp_svc_channel_return_from_get_interfaces:
 * @context: The D-Bus method invocation context
 * @out0: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_return_from_get_interfaces (DBusGMethodInvocation *context,
    const gchar **out0);
static inline void
tp_svc_channel_return_from_get_interfaces (DBusGMethodInvocation *context,
    const gchar **out0)
{
  dbus_g_method_return (context,
      out0);
}

void tp_svc_channel_emit_closed (gpointer instance);

/**
 * TpSvcChannelInterfaceChatState:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelInterfaceChatState TpSvcChannelInterfaceChatState;

/**
 * TpSvcChannelInterfaceChatStateClass:
 *
 * The class of TpSvcChannelInterfaceChatState.
 */
typedef struct _TpSvcChannelInterfaceChatStateClass TpSvcChannelInterfaceChatStateClass;

GType tp_svc_channel_interface_chat_state_get_type (void);
#define TP_TYPE_SVC_CHANNEL_INTERFACE_CHAT_STATE \
  (tp_svc_channel_interface_chat_state_get_type ())
#define TP_SVC_CHANNEL_INTERFACE_CHAT_STATE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_CHAT_STATE, TpSvcChannelInterfaceChatState))
#define TP_IS_SVC_CHANNEL_INTERFACE_CHAT_STATE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_CHAT_STATE))
#define TP_SVC_CHANNEL_INTERFACE_CHAT_STATE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_CHAT_STATE, TpSvcChannelInterfaceChatStateClass))


typedef void (*tp_svc_channel_interface_chat_state_set_chat_state_impl) (TpSvcChannelInterfaceChatState *self,
    guint in_state,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_chat_state_implement_set_chat_state (TpSvcChannelInterfaceChatStateClass *klass, tp_svc_channel_interface_chat_state_set_chat_state_impl impl);
/**
 * tp_svc_channel_interface_chat_state_return_from_set_chat_state:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_chat_state_return_from_set_chat_state (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_chat_state_return_from_set_chat_state (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void tp_svc_channel_interface_chat_state_emit_chat_state_changed (gpointer instance,
    guint arg_contact,
    guint arg_state);

/**
 * TpSvcChannelInterfaceDTMF:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelInterfaceDTMF TpSvcChannelInterfaceDTMF;

/**
 * TpSvcChannelInterfaceDTMFClass:
 *
 * The class of TpSvcChannelInterfaceDTMF.
 */
typedef struct _TpSvcChannelInterfaceDTMFClass TpSvcChannelInterfaceDTMFClass;

GType tp_svc_channel_interface_dtmf_get_type (void);
#define TP_TYPE_SVC_CHANNEL_INTERFACE_DTMF \
  (tp_svc_channel_interface_dtmf_get_type ())
#define TP_SVC_CHANNEL_INTERFACE_DTMF(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_DTMF, TpSvcChannelInterfaceDTMF))
#define TP_IS_SVC_CHANNEL_INTERFACE_DTMF(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_DTMF))
#define TP_SVC_CHANNEL_INTERFACE_DTMF_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_DTMF, TpSvcChannelInterfaceDTMFClass))


typedef void (*tp_svc_channel_interface_dtmf_start_tone_impl) (TpSvcChannelInterfaceDTMF *self,
    guint in_stream_id,
    guchar in_event,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_dtmf_implement_start_tone (TpSvcChannelInterfaceDTMFClass *klass, tp_svc_channel_interface_dtmf_start_tone_impl impl);
/**
 * tp_svc_channel_interface_dtmf_return_from_start_tone:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_dtmf_return_from_start_tone (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_dtmf_return_from_start_tone (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_interface_dtmf_stop_tone_impl) (TpSvcChannelInterfaceDTMF *self,
    guint in_stream_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_dtmf_implement_stop_tone (TpSvcChannelInterfaceDTMFClass *klass, tp_svc_channel_interface_dtmf_stop_tone_impl impl);
/**
 * tp_svc_channel_interface_dtmf_return_from_stop_tone:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_dtmf_return_from_stop_tone (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_dtmf_return_from_stop_tone (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * TpSvcChannelInterfaceGroup:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelInterfaceGroup TpSvcChannelInterfaceGroup;

/**
 * TpSvcChannelInterfaceGroupClass:
 *
 * The class of TpSvcChannelInterfaceGroup.
 */
typedef struct _TpSvcChannelInterfaceGroupClass TpSvcChannelInterfaceGroupClass;

GType tp_svc_channel_interface_group_get_type (void);
#define TP_TYPE_SVC_CHANNEL_INTERFACE_GROUP \
  (tp_svc_channel_interface_group_get_type ())
#define TP_SVC_CHANNEL_INTERFACE_GROUP(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_GROUP, TpSvcChannelInterfaceGroup))
#define TP_IS_SVC_CHANNEL_INTERFACE_GROUP(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_GROUP))
#define TP_SVC_CHANNEL_INTERFACE_GROUP_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_GROUP, TpSvcChannelInterfaceGroupClass))


typedef void (*tp_svc_channel_interface_group_add_members_impl) (TpSvcChannelInterfaceGroup *self,
    const GArray *in_contacts,
    const gchar *in_message,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_add_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_add_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_add_members:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_add_members (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_group_return_from_add_members (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_interface_group_get_all_members_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_all_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_all_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_all_members:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 * @out1: const GArray * (FIXME, generate documentation)
 * @out2: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_all_members (DBusGMethodInvocation *context,
    const GArray *out0,
    const GArray *out1,
    const GArray *out2);
static inline void
tp_svc_channel_interface_group_return_from_get_all_members (DBusGMethodInvocation *context,
    const GArray *out0,
    const GArray *out1,
    const GArray *out2)
{
  dbus_g_method_return (context,
      out0,
      out1,
      out2);
}

typedef void (*tp_svc_channel_interface_group_get_group_flags_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_group_flags (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_group_flags_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_group_flags:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_group_flags (DBusGMethodInvocation *context,
    guint out0);
static inline void
tp_svc_channel_interface_group_return_from_get_group_flags (DBusGMethodInvocation *context,
    guint out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_handle_owners_impl) (TpSvcChannelInterfaceGroup *self,
    const GArray *in_handles,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_handle_owners (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_handle_owners_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_handle_owners:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_handle_owners (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_interface_group_return_from_get_handle_owners (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_local_pending_members_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_local_pending_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_local_pending_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_local_pending_members:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_local_pending_members (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_interface_group_return_from_get_local_pending_members (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_local_pending_members_with_info_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_local_pending_members_with_info (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_local_pending_members_with_info_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_local_pending_members_with_info:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_local_pending_members_with_info (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_interface_group_return_from_get_local_pending_members_with_info (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_members_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_members:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_members (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_interface_group_return_from_get_members (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_remote_pending_members_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_remote_pending_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_remote_pending_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_remote_pending_members:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_remote_pending_members (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_interface_group_return_from_get_remote_pending_members (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_get_self_handle_impl) (TpSvcChannelInterfaceGroup *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_get_self_handle (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_get_self_handle_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_get_self_handle:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_get_self_handle (DBusGMethodInvocation *context,
    guint out0);
static inline void
tp_svc_channel_interface_group_return_from_get_self_handle (DBusGMethodInvocation *context,
    guint out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_group_remove_members_impl) (TpSvcChannelInterfaceGroup *self,
    const GArray *in_contacts,
    const gchar *in_message,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_remove_members (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_remove_members_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_remove_members:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_remove_members (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_group_return_from_remove_members (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_interface_group_remove_members_with_reason_impl) (TpSvcChannelInterfaceGroup *self,
    const GArray *in_contacts,
    const gchar *in_message,
    guint in_reason,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_group_implement_remove_members_with_reason (TpSvcChannelInterfaceGroupClass *klass, tp_svc_channel_interface_group_remove_members_with_reason_impl impl);
/**
 * tp_svc_channel_interface_group_return_from_remove_members_with_reason:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_group_return_from_remove_members_with_reason (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_interface_group_return_from_remove_members_with_reason (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void tp_svc_channel_interface_group_emit_group_flags_changed (gpointer instance,
    guint arg_added,
    guint arg_removed);
void tp_svc_channel_interface_group_emit_members_changed (gpointer instance,
    const gchar *arg_message,
    const GArray *arg_added,
    const GArray *arg_removed,
    const GArray *arg_local_pending,
    const GArray *arg_remote_pending,
    guint arg_actor,
    guint arg_reason);

/**
 * TpSvcChannelInterfaceMediaSignalling:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelInterfaceMediaSignalling TpSvcChannelInterfaceMediaSignalling;

/**
 * TpSvcChannelInterfaceMediaSignallingClass:
 *
 * The class of TpSvcChannelInterfaceMediaSignalling.
 */
typedef struct _TpSvcChannelInterfaceMediaSignallingClass TpSvcChannelInterfaceMediaSignallingClass;

GType tp_svc_channel_interface_media_signalling_get_type (void);
#define TP_TYPE_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING \
  (tp_svc_channel_interface_media_signalling_get_type ())
#define TP_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING, TpSvcChannelInterfaceMediaSignalling))
#define TP_IS_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING))
#define TP_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_MEDIA_SIGNALLING, TpSvcChannelInterfaceMediaSignallingClass))


typedef void (*tp_svc_channel_interface_media_signalling_get_session_handlers_impl) (TpSvcChannelInterfaceMediaSignalling *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_media_signalling_implement_get_session_handlers (TpSvcChannelInterfaceMediaSignallingClass *klass, tp_svc_channel_interface_media_signalling_get_session_handlers_impl impl);
/**
 * tp_svc_channel_interface_media_signalling_return_from_get_session_handlers:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_media_signalling_return_from_get_session_handlers (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_interface_media_signalling_return_from_get_session_handlers (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

void tp_svc_channel_interface_media_signalling_emit_new_session_handler (gpointer instance,
    const gchar *arg_session_handler,
    const gchar *arg_type);

/**
 * TpSvcChannelInterfacePassword:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelInterfacePassword TpSvcChannelInterfacePassword;

/**
 * TpSvcChannelInterfacePasswordClass:
 *
 * The class of TpSvcChannelInterfacePassword.
 */
typedef struct _TpSvcChannelInterfacePasswordClass TpSvcChannelInterfacePasswordClass;

GType tp_svc_channel_interface_password_get_type (void);
#define TP_TYPE_SVC_CHANNEL_INTERFACE_PASSWORD \
  (tp_svc_channel_interface_password_get_type ())
#define TP_SVC_CHANNEL_INTERFACE_PASSWORD(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_PASSWORD, TpSvcChannelInterfacePassword))
#define TP_IS_SVC_CHANNEL_INTERFACE_PASSWORD(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_PASSWORD))
#define TP_SVC_CHANNEL_INTERFACE_PASSWORD_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_INTERFACE_PASSWORD, TpSvcChannelInterfacePasswordClass))


typedef void (*tp_svc_channel_interface_password_get_password_flags_impl) (TpSvcChannelInterfacePassword *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_password_implement_get_password_flags (TpSvcChannelInterfacePasswordClass *klass, tp_svc_channel_interface_password_get_password_flags_impl impl);
/**
 * tp_svc_channel_interface_password_return_from_get_password_flags:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_password_return_from_get_password_flags (DBusGMethodInvocation *context,
    guint out0);
static inline void
tp_svc_channel_interface_password_return_from_get_password_flags (DBusGMethodInvocation *context,
    guint out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_interface_password_provide_password_impl) (TpSvcChannelInterfacePassword *self,
    const gchar *in_password,
    DBusGMethodInvocation *context);
void tp_svc_channel_interface_password_implement_provide_password (TpSvcChannelInterfacePasswordClass *klass, tp_svc_channel_interface_password_provide_password_impl impl);
/**
 * tp_svc_channel_interface_password_return_from_provide_password:
 * @context: The D-Bus method invocation context
 * @out0: gboolean  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_interface_password_return_from_provide_password (DBusGMethodInvocation *context,
    gboolean out0);
static inline void
tp_svc_channel_interface_password_return_from_provide_password (DBusGMethodInvocation *context,
    gboolean out0)
{
  dbus_g_method_return (context,
      out0);
}

void tp_svc_channel_interface_password_emit_password_flags_changed (gpointer instance,
    guint arg_added,
    guint arg_removed);

/**
 * TpSvcChannelTypeContactList:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelTypeContactList TpSvcChannelTypeContactList;

/**
 * TpSvcChannelTypeContactListClass:
 *
 * The class of TpSvcChannelTypeContactList.
 */
typedef struct _TpSvcChannelTypeContactListClass TpSvcChannelTypeContactListClass;

GType tp_svc_channel_type_contact_list_get_type (void);
#define TP_TYPE_SVC_CHANNEL_TYPE_CONTACT_LIST \
  (tp_svc_channel_type_contact_list_get_type ())
#define TP_SVC_CHANNEL_TYPE_CONTACT_LIST(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_TYPE_CONTACT_LIST, TpSvcChannelTypeContactList))
#define TP_IS_SVC_CHANNEL_TYPE_CONTACT_LIST(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_TYPE_CONTACT_LIST))
#define TP_SVC_CHANNEL_TYPE_CONTACT_LIST_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_TYPE_CONTACT_LIST, TpSvcChannelTypeContactListClass))



/**
 * TpSvcChannelTypeRoomList:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelTypeRoomList TpSvcChannelTypeRoomList;

/**
 * TpSvcChannelTypeRoomListClass:
 *
 * The class of TpSvcChannelTypeRoomList.
 */
typedef struct _TpSvcChannelTypeRoomListClass TpSvcChannelTypeRoomListClass;

GType tp_svc_channel_type_room_list_get_type (void);
#define TP_TYPE_SVC_CHANNEL_TYPE_ROOM_LIST \
  (tp_svc_channel_type_room_list_get_type ())
#define TP_SVC_CHANNEL_TYPE_ROOM_LIST(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_TYPE_ROOM_LIST, TpSvcChannelTypeRoomList))
#define TP_IS_SVC_CHANNEL_TYPE_ROOM_LIST(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_TYPE_ROOM_LIST))
#define TP_SVC_CHANNEL_TYPE_ROOM_LIST_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_TYPE_ROOM_LIST, TpSvcChannelTypeRoomListClass))


typedef void (*tp_svc_channel_type_room_list_get_listing_rooms_impl) (TpSvcChannelTypeRoomList *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_room_list_implement_get_listing_rooms (TpSvcChannelTypeRoomListClass *klass, tp_svc_channel_type_room_list_get_listing_rooms_impl impl);
/**
 * tp_svc_channel_type_room_list_return_from_get_listing_rooms:
 * @context: The D-Bus method invocation context
 * @out0: gboolean  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_room_list_return_from_get_listing_rooms (DBusGMethodInvocation *context,
    gboolean out0);
static inline void
tp_svc_channel_type_room_list_return_from_get_listing_rooms (DBusGMethodInvocation *context,
    gboolean out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_room_list_list_rooms_impl) (TpSvcChannelTypeRoomList *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_room_list_implement_list_rooms (TpSvcChannelTypeRoomListClass *klass, tp_svc_channel_type_room_list_list_rooms_impl impl);
/**
 * tp_svc_channel_type_room_list_return_from_list_rooms:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_room_list_return_from_list_rooms (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_room_list_return_from_list_rooms (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_type_room_list_stop_listing_impl) (TpSvcChannelTypeRoomList *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_room_list_implement_stop_listing (TpSvcChannelTypeRoomListClass *klass, tp_svc_channel_type_room_list_stop_listing_impl impl);
/**
 * tp_svc_channel_type_room_list_return_from_stop_listing:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_room_list_return_from_stop_listing (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_room_list_return_from_stop_listing (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void tp_svc_channel_type_room_list_emit_got_rooms (gpointer instance,
    const GPtrArray *arg_rooms);
void tp_svc_channel_type_room_list_emit_listing_rooms (gpointer instance,
    gboolean arg_listing);

/**
 * TpSvcChannelTypeStreamedMedia:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelTypeStreamedMedia TpSvcChannelTypeStreamedMedia;

/**
 * TpSvcChannelTypeStreamedMediaClass:
 *
 * The class of TpSvcChannelTypeStreamedMedia.
 */
typedef struct _TpSvcChannelTypeStreamedMediaClass TpSvcChannelTypeStreamedMediaClass;

GType tp_svc_channel_type_streamed_media_get_type (void);
#define TP_TYPE_SVC_CHANNEL_TYPE_STREAMED_MEDIA \
  (tp_svc_channel_type_streamed_media_get_type ())
#define TP_SVC_CHANNEL_TYPE_STREAMED_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_TYPE_STREAMED_MEDIA, TpSvcChannelTypeStreamedMedia))
#define TP_IS_SVC_CHANNEL_TYPE_STREAMED_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_TYPE_STREAMED_MEDIA))
#define TP_SVC_CHANNEL_TYPE_STREAMED_MEDIA_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_TYPE_STREAMED_MEDIA, TpSvcChannelTypeStreamedMediaClass))


typedef void (*tp_svc_channel_type_streamed_media_list_streams_impl) (TpSvcChannelTypeStreamedMedia *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_streamed_media_implement_list_streams (TpSvcChannelTypeStreamedMediaClass *klass, tp_svc_channel_type_streamed_media_list_streams_impl impl);
/**
 * tp_svc_channel_type_streamed_media_return_from_list_streams:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_streamed_media_return_from_list_streams (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_type_streamed_media_return_from_list_streams (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_streamed_media_remove_streams_impl) (TpSvcChannelTypeStreamedMedia *self,
    const GArray *in_streams,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_streamed_media_implement_remove_streams (TpSvcChannelTypeStreamedMediaClass *klass, tp_svc_channel_type_streamed_media_remove_streams_impl impl);
/**
 * tp_svc_channel_type_streamed_media_return_from_remove_streams:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_streamed_media_return_from_remove_streams (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_streamed_media_return_from_remove_streams (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_type_streamed_media_request_stream_direction_impl) (TpSvcChannelTypeStreamedMedia *self,
    guint in_stream_id,
    guint in_stream_direction,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_streamed_media_implement_request_stream_direction (TpSvcChannelTypeStreamedMediaClass *klass, tp_svc_channel_type_streamed_media_request_stream_direction_impl impl);
/**
 * tp_svc_channel_type_streamed_media_return_from_request_stream_direction:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_streamed_media_return_from_request_stream_direction (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_streamed_media_return_from_request_stream_direction (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_type_streamed_media_request_streams_impl) (TpSvcChannelTypeStreamedMedia *self,
    guint in_contact_handle,
    const GArray *in_types,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_streamed_media_implement_request_streams (TpSvcChannelTypeStreamedMediaClass *klass, tp_svc_channel_type_streamed_media_request_streams_impl impl);
/**
 * tp_svc_channel_type_streamed_media_return_from_request_streams:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_streamed_media_return_from_request_streams (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_type_streamed_media_return_from_request_streams (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

void tp_svc_channel_type_streamed_media_emit_stream_added (gpointer instance,
    guint arg_stream_id,
    guint arg_contact_handle,
    guint arg_stream_type);
void tp_svc_channel_type_streamed_media_emit_stream_direction_changed (gpointer instance,
    guint arg_stream_id,
    guint arg_stream_direction,
    guint arg_pending_flags);
void tp_svc_channel_type_streamed_media_emit_stream_error (gpointer instance,
    guint arg_stream_id,
    guint arg_errno,
    const gchar *arg_message);
void tp_svc_channel_type_streamed_media_emit_stream_removed (gpointer instance,
    guint arg_stream_id);
void tp_svc_channel_type_streamed_media_emit_stream_state_changed (gpointer instance,
    guint arg_stream_id,
    guint arg_stream_state);

/**
 * TpSvcChannelTypeText:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelTypeText TpSvcChannelTypeText;

/**
 * TpSvcChannelTypeTextClass:
 *
 * The class of TpSvcChannelTypeText.
 */
typedef struct _TpSvcChannelTypeTextClass TpSvcChannelTypeTextClass;

GType tp_svc_channel_type_text_get_type (void);
#define TP_TYPE_SVC_CHANNEL_TYPE_TEXT \
  (tp_svc_channel_type_text_get_type ())
#define TP_SVC_CHANNEL_TYPE_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_TYPE_TEXT, TpSvcChannelTypeText))
#define TP_IS_SVC_CHANNEL_TYPE_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_TYPE_TEXT))
#define TP_SVC_CHANNEL_TYPE_TEXT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_TYPE_TEXT, TpSvcChannelTypeTextClass))


typedef void (*tp_svc_channel_type_text_acknowledge_pending_messages_impl) (TpSvcChannelTypeText *self,
    const GArray *in_ids,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_text_implement_acknowledge_pending_messages (TpSvcChannelTypeTextClass *klass, tp_svc_channel_type_text_acknowledge_pending_messages_impl impl);
/**
 * tp_svc_channel_type_text_return_from_acknowledge_pending_messages:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_text_return_from_acknowledge_pending_messages (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_text_return_from_acknowledge_pending_messages (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_type_text_get_message_types_impl) (TpSvcChannelTypeText *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_text_implement_get_message_types (TpSvcChannelTypeTextClass *klass, tp_svc_channel_type_text_get_message_types_impl impl);
/**
 * tp_svc_channel_type_text_return_from_get_message_types:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_text_return_from_get_message_types (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_type_text_return_from_get_message_types (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_text_list_pending_messages_impl) (TpSvcChannelTypeText *self,
    gboolean in_clear,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_text_implement_list_pending_messages (TpSvcChannelTypeTextClass *klass, tp_svc_channel_type_text_list_pending_messages_impl impl);
/**
 * tp_svc_channel_type_text_return_from_list_pending_messages:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_text_return_from_list_pending_messages (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_type_text_return_from_list_pending_messages (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_text_send_impl) (TpSvcChannelTypeText *self,
    guint in_type,
    const gchar *in_text,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_text_implement_send (TpSvcChannelTypeTextClass *klass, tp_svc_channel_type_text_send_impl impl);
/**
 * tp_svc_channel_type_text_return_from_send:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_text_return_from_send (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_text_return_from_send (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void tp_svc_channel_type_text_emit_lost_message (gpointer instance);
void tp_svc_channel_type_text_emit_received (gpointer instance,
    guint arg_id,
    guint arg_timestamp,
    guint arg_sender,
    guint arg_type,
    guint arg_flags,
    const gchar *arg_text);
void tp_svc_channel_type_text_emit_send_error (gpointer instance,
    guint arg_error,
    guint arg_timestamp,
    guint arg_type,
    const gchar *arg_text);
void tp_svc_channel_type_text_emit_sent (gpointer instance,
    guint arg_timestamp,
    guint arg_type,
    const gchar *arg_text);

/**
 * TpSvcChannelTypeTubes:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TpSvcChannelTypeTubes TpSvcChannelTypeTubes;

/**
 * TpSvcChannelTypeTubesClass:
 *
 * The class of TpSvcChannelTypeTubes.
 */
typedef struct _TpSvcChannelTypeTubesClass TpSvcChannelTypeTubesClass;

GType tp_svc_channel_type_tubes_get_type (void);
#define TP_TYPE_SVC_CHANNEL_TYPE_TUBES \
  (tp_svc_channel_type_tubes_get_type ())
#define TP_SVC_CHANNEL_TYPE_TUBES(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TP_TYPE_SVC_CHANNEL_TYPE_TUBES, TpSvcChannelTypeTubes))
#define TP_IS_SVC_CHANNEL_TYPE_TUBES(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TP_TYPE_SVC_CHANNEL_TYPE_TUBES))
#define TP_SVC_CHANNEL_TYPE_TUBES_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TP_TYPE_SVC_CHANNEL_TYPE_TUBES, TpSvcChannelTypeTubesClass))


typedef void (*tp_svc_channel_type_tubes_get_available_stream_tube_types_impl) (TpSvcChannelTypeTubes *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_get_available_stream_tube_types (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_get_available_stream_tube_types_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_get_available_stream_tube_types:
 * @context: The D-Bus method invocation context
 * @out0: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_get_available_stream_tube_types (DBusGMethodInvocation *context,
    GHashTable *out0);
static inline void
tp_svc_channel_type_tubes_return_from_get_available_stream_tube_types (DBusGMethodInvocation *context,
    GHashTable *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_get_available_tube_types_impl) (TpSvcChannelTypeTubes *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_get_available_tube_types (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_get_available_tube_types_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_get_available_tube_types:
 * @context: The D-Bus method invocation context
 * @out0: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_get_available_tube_types (DBusGMethodInvocation *context,
    const GArray *out0);
static inline void
tp_svc_channel_type_tubes_return_from_get_available_tube_types (DBusGMethodInvocation *context,
    const GArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_list_tubes_impl) (TpSvcChannelTypeTubes *self,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_list_tubes (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_list_tubes_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_list_tubes:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_list_tubes (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_type_tubes_return_from_list_tubes (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_offer_d_bus_tube_impl) (TpSvcChannelTypeTubes *self,
    const gchar *in_service,
    GHashTable *in_parameters,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_offer_d_bus_tube (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_offer_d_bus_tube_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_offer_d_bus_tube:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_offer_d_bus_tube (DBusGMethodInvocation *context,
    guint out0);
static inline void
tp_svc_channel_type_tubes_return_from_offer_d_bus_tube (DBusGMethodInvocation *context,
    guint out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_offer_stream_tube_impl) (TpSvcChannelTypeTubes *self,
    const gchar *in_service,
    GHashTable *in_parameters,
    guint in_address_type,
    const GValue *in_address,
    guint in_access_control,
    const GValue *in_access_control_param,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_offer_stream_tube (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_offer_stream_tube_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_offer_stream_tube:
 * @context: The D-Bus method invocation context
 * @out0: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_offer_stream_tube (DBusGMethodInvocation *context,
    guint out0);
static inline void
tp_svc_channel_type_tubes_return_from_offer_stream_tube (DBusGMethodInvocation *context,
    guint out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_accept_d_bus_tube_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_accept_d_bus_tube (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_accept_d_bus_tube_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_accept_d_bus_tube:
 * @context: The D-Bus method invocation context
 * @out_address: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_accept_d_bus_tube (DBusGMethodInvocation *context,
    const gchar *out_address);
static inline void
tp_svc_channel_type_tubes_return_from_accept_d_bus_tube (DBusGMethodInvocation *context,
    const gchar *out_address)
{
  dbus_g_method_return (context,
      out_address);
}

typedef void (*tp_svc_channel_type_tubes_accept_stream_tube_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    guint in_address_type,
    guint in_access_control,
    const GValue *in_access_control_param,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_accept_stream_tube (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_accept_stream_tube_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_accept_stream_tube:
 * @context: The D-Bus method invocation context
 * @out_address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_accept_stream_tube (DBusGMethodInvocation *context,
    const GValue *out_address);
static inline void
tp_svc_channel_type_tubes_return_from_accept_stream_tube (DBusGMethodInvocation *context,
    const GValue *out_address)
{
  dbus_g_method_return (context,
      out_address);
}

typedef void (*tp_svc_channel_type_tubes_close_tube_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_close_tube (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_close_tube_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_close_tube:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_close_tube (DBusGMethodInvocation *context);
static inline void
tp_svc_channel_type_tubes_return_from_close_tube (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tp_svc_channel_type_tubes_get_d_bus_tube_address_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_get_d_bus_tube_address (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_get_d_bus_tube_address_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_get_d_bus_tube_address:
 * @context: The D-Bus method invocation context
 * @out0: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_get_d_bus_tube_address (DBusGMethodInvocation *context,
    const gchar *out0);
static inline void
tp_svc_channel_type_tubes_return_from_get_d_bus_tube_address (DBusGMethodInvocation *context,
    const gchar *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_get_d_bus_names_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_get_d_bus_names (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_get_d_bus_names_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_get_d_bus_names:
 * @context: The D-Bus method invocation context
 * @out0: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_get_d_bus_names (DBusGMethodInvocation *context,
    const GPtrArray *out0);
static inline void
tp_svc_channel_type_tubes_return_from_get_d_bus_names (DBusGMethodInvocation *context,
    const GPtrArray *out0)
{
  dbus_g_method_return (context,
      out0);
}

typedef void (*tp_svc_channel_type_tubes_get_stream_tube_socket_address_impl) (TpSvcChannelTypeTubes *self,
    guint in_id,
    DBusGMethodInvocation *context);
void tp_svc_channel_type_tubes_implement_get_stream_tube_socket_address (TpSvcChannelTypeTubesClass *klass, tp_svc_channel_type_tubes_get_stream_tube_socket_address_impl impl);
/**
 * tp_svc_channel_type_tubes_return_from_get_stream_tube_socket_address:
 * @context: The D-Bus method invocation context
 * @out_address_type: guint  (FIXME, generate documentation)
 * @out_address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tp_svc_channel_type_tubes_return_from_get_stream_tube_socket_address (DBusGMethodInvocation *context,
    guint out_address_type,
    const GValue *out_address);
static inline void
tp_svc_channel_type_tubes_return_from_get_stream_tube_socket_address (DBusGMethodInvocation *context,
    guint out_address_type,
    const GValue *out_address)
{
  dbus_g_method_return (context,
      out_address_type,
      out_address);
}

void tp_svc_channel_type_tubes_emit_new_tube (gpointer instance,
    guint arg_id,
    guint arg_initiator,
    guint arg_type,
    const gchar *arg_service,
    GHashTable *arg_parameters,
    guint arg_state);
void tp_svc_channel_type_tubes_emit_tube_state_changed (gpointer instance,
    guint arg_id,
    guint arg_state);
void tp_svc_channel_type_tubes_emit_tube_closed (gpointer instance,
    guint arg_id);
void tp_svc_channel_type_tubes_emit_d_bus_names_changed (gpointer instance,
    guint arg_id,
    const GPtrArray *arg_added,
    const GArray *arg_removed);
void tp_svc_channel_type_tubes_emit_stream_tube_new_connection (gpointer instance,
    guint arg_id,
    guint arg_handle);


G_END_DECLS
