/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private String enc;
    private boolean gotEnc = false;
    protected HashMap encoders = new HashMap();
    protected C2BConverter conv;
    private Response coyoteResponse;
    private boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
        this.cb = new CharChunk(size);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        this.cb.setLimit(size);
    }

    public void setResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void recycle() {
        this.state = 0;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.cb.recycle();
        this.bb.recycle();
        this.closed = false;
        this.suspended = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (!this.coyoteResponse.isCommitted() && this.coyoteResponse.getContentLengthLong() == -1L) {
            if (this.state == 1) {
                this.cb.flushBuffer();
                this.state = 2;
            }
            if (!this.coyoteResponse.isCommitted()) {
                this.coyoteResponse.setContentLength(this.bb.getLength());
            }
        }
        this.doFlush(false);
        this.closed = true;
        this.coyoteResponse.finish();
    }

    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.state == 1) {
            this.cb.flushBuffer();
            this.bb.flushBuffer();
            this.state = 2;
        } else if (this.state == 2) {
            this.bb.flushBuffer();
        } else if (this.state == 0) {
            this.coyoteResponse.sendHeaders();
        }
        this.doFlush = false;
        if (realFlush) {
            this.coyoteResponse.action(ActionCode.ACTION_CLIENT_FLUSH, (Object)this.coyoteResponse);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (IOException e) {
                throw new ClientAbortException(e);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b, off, len);
        this.bytesWritten += (long)len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.cb.append((char)c);
        ++this.charsWritten;
    }

    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.cb.append(c, off, len);
        this.charsWritten += (long)len;
    }

    public void write(StringBuffer sb) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        int len = sb.length();
        this.charsWritten += (long)len;
        this.cb.append(sb);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.charsWritten += (long)len;
        if (s == null) {
            s = "null";
        }
        this.cb.append(s, off, len);
    }

    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (s == null) {
            s = "null";
        }
        this.write(s, 0, s.length());
    }

    public void flushChars() throws IOException {
        this.cb.flushBuffer();
        this.state = 2;
    }

    public boolean flushCharsNeeded() {
        return this.state == 1;
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
        this.conv.convert(c, off, len);
        this.conv.flushBuffer();
    }

    public void checkConverter() throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        this.gotEnc = true;
        if (this.enc == null) {
            this.enc = "ISO-8859-1";
        }
        this.conv = (C2BConverter)this.encoders.get(this.enc);
        if (this.conv == null) {
            if (System.getSecurityManager() != null) {
                try {
                    this.conv = (C2BConverter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new C2BConverter(OutputBuffer.this.bb, OutputBuffer.this.enc);
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    e = ex.getException();
                    if (!(e instanceof IOException)) ** GOTO lbl17
                    throw (IOException)e;
                }
            } else {
                this.conv = new C2BConverter(this.bb, this.enc);
            }
lbl17:
            // 3 sources

            this.encoders.put(this.enc, this.conv);
        }
    }

    public void flushBytes() throws IOException {
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        if (this.bytesWritten < Integer.MAX_VALUE) {
            return (int)this.bytesWritten;
        }
        return -1;
    }

    public int getCharsWritten() {
        if (this.charsWritten < Integer.MAX_VALUE) {
            return (int)this.charsWritten;
        }
        return -1;
    }

    public int getContentWritten() {
        long size = this.bytesWritten + this.charsWritten;
        if (size < Integer.MAX_VALUE) {
            return (int)size;
        }
        return -1;
    }

    public long getContentWrittenLong() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0L;
        this.cb.recycle();
        this.charsWritten = 0L;
        this.gotEnc = false;
        this.enc = null;
        this.state = 0;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }
}

