/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM mozIStorageConnection.idl
 */

#ifndef __gen_mozIStorageConnection_h__
#define __gen_mozIStorageConnection_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class mozIStorageFunction; /* forward declaration */

class mozIStorageStatement; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    mozIStorageConnection */
#define MOZISTORAGECONNECTION_IID_STR "77015f88-bfc2-4669-b1c3-cc19fb07cd4e"

#define MOZISTORAGECONNECTION_IID \
  {0x77015f88, 0xbfc2, 0x4669, \
    { 0xb1, 0xc3, 0xcc, 0x19, 0xfb, 0x07, 0xcd, 0x4e }}

/**
 * mozIStorageConnection represents a database connection attached to
 * a specific file or to the in-memory data storage.  It is the
 * primary interface for interacting with a database, including
 * creating prepared statements, executing SQL, and examining database
 * errors.
 */
class NS_NO_VTABLE mozIStorageConnection : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(MOZISTORAGECONNECTION_IID)

  /**
   * whether the database is open or not
   */
  /* readonly attribute boolean connectionReady; */
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) = 0;

  /**
   * The current database nsIFile.  Null if the database
   * connection refers to an in-memory database.
   */
  /* readonly attribute nsIFile databaseFile; */
  NS_IMETHOD GetDatabaseFile(nsIFile * *aDatabaseFile) = 0;

  /**
   * lastInsertRowID returns the row ID from the last INSERT
   * operation.
   */
  /* readonly attribute long long lastInsertRowID; */
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) = 0;

  /**
   * The last error SQLite error code.
   */
  /* readonly attribute long lastError; */
  NS_IMETHOD GetLastError(PRInt32 *aLastError) = 0;

  /**
   * The last SQLite error as a string (in english, straight from the
   * sqlite library).
   */
  /* readonly attribute AUTF8String lastErrorString; */
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) = 0;

  /**
   * Create a mozIStorageStatement for the given SQL expression.  The
   * expression may use ? to indicate sequential numbered arguments,
   * or :name and $var to indicate named arguments.
   *
   * @param aSQLStatement  The SQL statement to execute
   *
   * @returns a new mozIStorageStatement
   */
  /* mozIStorageStatement createStatement (in AUTF8String aSQLStatement); */
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) = 0;

  /**
   * Execute a SQL expression, expecting no arguments.
   *
   * @param aSQLStatement  The SQL statement to execute
   */
  /* void executeSimpleSQL (in AUTF8String aSQLStatement); */
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) = 0;

  /**
   * Check if the given table exists.
   *
   * @param aTableName   The table to check
   * @returns TRUE if table exists, FALSE otherwise.
   */
  /* boolean tableExists (in AUTF8String aTableName); */
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) = 0;

  /**
   * Check if the given index exists.
   *
   * @param aIndexName   The index to check
   * @returns TRUE if the index exists, FALSE otherwise.
   */
  /* boolean indexExists (in AUTF8String aIndexName); */
  NS_IMETHOD IndexExists(const nsACString & aIndexName, PRBool *_retval) = 0;

  /**
   * Returns true if a transaction is active on this connection.
   */
  /* readonly attribute boolean transactionInProgress; */
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) = 0;

  /**
   * Begin a new transaction.  sqlite default transactions are deferred.
   * If a transaction is active, throws an error.
   */
  /* void beginTransaction (); */
  NS_IMETHOD BeginTransaction(void) = 0;

  /**
   * Begins a new transaction with the given type.
   */
  enum { TRANSACTION_DEFERRED = 0 };

  enum { TRANSACTION_IMMEDIATE = 1 };

  enum { TRANSACTION_EXCLUSIVE = 2 };

  /* void beginTransactionAs (in PRInt32 transactionType); */
  NS_IMETHOD BeginTransactionAs(PRInt32 transactionType) = 0;

  /**
   * Commits the current transaction.  If no transaction is active,
   * @throws NS_ERROR_STORAGE_NO_TRANSACTION.
   */
  /* void commitTransaction (); */
  NS_IMETHOD CommitTransaction(void) = 0;

  /**
   * Rolls back the current transaction.  If no transaction is active,
   * @throws NS_ERROR_STORAGE_NO_TRANSACTION.
   */
  /* void rollbackTransaction (); */
  NS_IMETHOD RollbackTransaction(void) = 0;

  /**
   * Create the table with the given name and schema.
   *
   * If the table already exists, NS_ERROR_FAILURE is thrown.
   * (XXX at some point in the future it will check if the schema is
   * the same as what is specified, but that doesn't happen currently.)
   *
   * @param aTableName the table name to be created, consisting of
   * [A-Za-z0-9_], and beginning with a letter.
   *
   * @param aTableSchema the schema of the table; what would normally
   * go between the parens in a CREATE TABLE statement: e.g., "foo
   * INTEGER, bar STRING".
   *
   * @throws NS_ERROR_FAILURE if the table already exists or could not
   * be created for any other reason.
   *
   */
  /* void createTable (in string aTableName, in string aTableSchema); */
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) = 0;

  /**
   * Create a new SQLite function
   */
  /* void createFunction (in string aFunctionName, in long aNumArguments, in mozIStorageFunction aFunction); */
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) = 0;

  /**
   * This is used to preload the database cache. It loads pages from the
   * start of the database file until the memory cache (specified by
   * "PRAGMA cache_size=") is full or the entire file is read.
   *
   * The cache MUST be active on the database for this to work. This means
   * that you must have a transaction open on the connection, or have a
   * transaction open on another connection that shares the same pager cache.
   * This cached data will go away when the transaction is closed.
   *
   * This preload operation can dramatically speed up read operations because
   * the data is loaded as one large block. Normally, pages are read in on
   * demand, which can cause many disk seeks.
   */
  /* void preload (); */
  NS_IMETHOD Preload(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_MOZISTORAGECONNECTION \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady); \
  NS_IMETHOD GetDatabaseFile(nsIFile * *aDatabaseFile); \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID); \
  NS_IMETHOD GetLastError(PRInt32 *aLastError); \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString); \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval); \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement); \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval); \
  NS_IMETHOD IndexExists(const nsACString & aIndexName, PRBool *_retval); \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress); \
  NS_IMETHOD BeginTransaction(void); \
  NS_IMETHOD BeginTransactionAs(PRInt32 transactionType); \
  NS_IMETHOD CommitTransaction(void); \
  NS_IMETHOD RollbackTransaction(void); \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema); \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction); \
  NS_IMETHOD Preload(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_MOZISTORAGECONNECTION(_to) \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) { return _to GetConnectionReady(aConnectionReady); } \
  NS_IMETHOD GetDatabaseFile(nsIFile * *aDatabaseFile) { return _to GetDatabaseFile(aDatabaseFile); } \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) { return _to GetLastInsertRowID(aLastInsertRowID); } \
  NS_IMETHOD GetLastError(PRInt32 *aLastError) { return _to GetLastError(aLastError); } \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) { return _to GetLastErrorString(aLastErrorString); } \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) { return _to CreateStatement(aSQLStatement, _retval); } \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) { return _to ExecuteSimpleSQL(aSQLStatement); } \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) { return _to TableExists(aTableName, _retval); } \
  NS_IMETHOD IndexExists(const nsACString & aIndexName, PRBool *_retval) { return _to IndexExists(aIndexName, _retval); } \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) { return _to GetTransactionInProgress(aTransactionInProgress); } \
  NS_IMETHOD BeginTransaction(void) { return _to BeginTransaction(); } \
  NS_IMETHOD BeginTransactionAs(PRInt32 transactionType) { return _to BeginTransactionAs(transactionType); } \
  NS_IMETHOD CommitTransaction(void) { return _to CommitTransaction(); } \
  NS_IMETHOD RollbackTransaction(void) { return _to RollbackTransaction(); } \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) { return _to CreateTable(aTableName, aTableSchema); } \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) { return _to CreateFunction(aFunctionName, aNumArguments, aFunction); } \
  NS_IMETHOD Preload(void) { return _to Preload(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_MOZISTORAGECONNECTION(_to) \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConnectionReady(aConnectionReady); } \
  NS_IMETHOD GetDatabaseFile(nsIFile * *aDatabaseFile) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDatabaseFile(aDatabaseFile); } \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastInsertRowID(aLastInsertRowID); } \
  NS_IMETHOD GetLastError(PRInt32 *aLastError) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastError(aLastError); } \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastErrorString(aLastErrorString); } \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateStatement(aSQLStatement, _retval); } \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExecuteSimpleSQL(aSQLStatement); } \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->TableExists(aTableName, _retval); } \
  NS_IMETHOD IndexExists(const nsACString & aIndexName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IndexExists(aIndexName, _retval); } \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransactionInProgress(aTransactionInProgress); } \
  NS_IMETHOD BeginTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginTransaction(); } \
  NS_IMETHOD BeginTransactionAs(PRInt32 transactionType) { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginTransactionAs(transactionType); } \
  NS_IMETHOD CommitTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CommitTransaction(); } \
  NS_IMETHOD RollbackTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RollbackTransaction(); } \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTable(aTableName, aTableSchema); } \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateFunction(aFunctionName, aNumArguments, aFunction); } \
  NS_IMETHOD Preload(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Preload(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public mozIStorageConnection
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MOZISTORAGECONNECTION

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, mozIStorageConnection)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute boolean connectionReady; */
NS_IMETHODIMP _MYCLASS_::GetConnectionReady(PRBool *aConnectionReady)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIFile databaseFile; */
NS_IMETHODIMP _MYCLASS_::GetDatabaseFile(nsIFile * *aDatabaseFile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long long lastInsertRowID; */
NS_IMETHODIMP _MYCLASS_::GetLastInsertRowID(PRInt64 *aLastInsertRowID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long lastError; */
NS_IMETHODIMP _MYCLASS_::GetLastError(PRInt32 *aLastError)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AUTF8String lastErrorString; */
NS_IMETHODIMP _MYCLASS_::GetLastErrorString(nsACString & aLastErrorString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* mozIStorageStatement createStatement (in AUTF8String aSQLStatement); */
NS_IMETHODIMP _MYCLASS_::CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void executeSimpleSQL (in AUTF8String aSQLStatement); */
NS_IMETHODIMP _MYCLASS_::ExecuteSimpleSQL(const nsACString & aSQLStatement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean tableExists (in AUTF8String aTableName); */
NS_IMETHODIMP _MYCLASS_::TableExists(const nsACString & aTableName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean indexExists (in AUTF8String aIndexName); */
NS_IMETHODIMP _MYCLASS_::IndexExists(const nsACString & aIndexName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean transactionInProgress; */
NS_IMETHODIMP _MYCLASS_::GetTransactionInProgress(PRBool *aTransactionInProgress)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void beginTransaction (); */
NS_IMETHODIMP _MYCLASS_::BeginTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void beginTransactionAs (in PRInt32 transactionType); */
NS_IMETHODIMP _MYCLASS_::BeginTransactionAs(PRInt32 transactionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void commitTransaction (); */
NS_IMETHODIMP _MYCLASS_::CommitTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void rollbackTransaction (); */
NS_IMETHODIMP _MYCLASS_::RollbackTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createTable (in string aTableName, in string aTableSchema); */
NS_IMETHODIMP _MYCLASS_::CreateTable(const char *aTableName, const char *aTableSchema)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createFunction (in string aFunctionName, in long aNumArguments, in mozIStorageFunction aFunction); */
NS_IMETHODIMP _MYCLASS_::CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void preload (); */
NS_IMETHODIMP _MYCLASS_::Preload()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_mozIStorageConnection_h__ */
